<?php
if (!defined("PHPUnit2_MAIN_METHOD")) {
      define("PHPUnit2_MAIN_METHOD", "test_phpdao_factory::main");
}
require_once "../src/cfg.php";
require_once "../src/db.php";
require_once "../src/dao/base.php";
require_once "../src/factory.php";
require_once "PHPUnit2/Framework/IncompleteTestError.php";
require_once "PHPUnit2/Framework/TestCase.php";
require_once "PHPUnit2/Framework/TestSuite.php";
require_once "PHPUnit2/TextUI/TestRunner.php";
/**
 * Test class for phpdao_db.
 * Generated by PHPUnit2_Util_Skeleton on 2005-04-23 at 23:15:11.
 */
class test_phpdao_factory extends PHPUnit2_Framework_TestCase {
    static $db = null; 
    static $schema =  //{{{
          array (
            'memo' =>  //{{{
            array (
              '@primary_key'=>'srl',
              'srl' => 
              array (
                'field' => 'srl',
                'type' => 'bigint',
                'len' => '20',
                'null' => false,
                'default' => NULL,
                'extra' => 'auto_increment',
              ),
              'usn' => 
              array (
                'field' => 'usn',
                'type' => 'bigint',
                'len' => '20',
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
              'url' => 
              array (
                'field' => 'url',
                'type' => 'varchar',
                'len' => '512',
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
              'comment' => 
              array (
                'field' => 'comment',
                'type' => 'text',
                'len' => NULL,
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
            ), //}}}
            'user' => //{{{
            array (
              '@primary_key' => 'usn',
              'usn' => 
              array (
                'field' => 'usn',
                'type' => 'bigint',
                'len' => '20',
                'null' => false,
                'default' => NULL,
                'extra' => 'auto_increment',
              ),
              'loginname' => 
              array (
                'field' => 'loginname',
                'type' => 'varchar',
                'len' => '64',
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
              'nickname' => 
              array (
                'field' => 'nickname',
                'type' => 'varchar',
                'len' => '128',
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
              'passwd' => 
              array (
                'field' => 'passwd',
                'type' => 'varchar',
                'len' => '64',
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
              'regdate' => 
              array (
                'field' => 'regdate',
                'type' => 'varchar',
                'len' => '19',
                'null' => true,
                'default' => NULL,
                'extra' => '',
              ),
            ), //}}}
          ); //}}}

    static  $relation =  //{{{
                      array (
                        'memo' => 
                        array (
                          '@primary_key' => 'srl',
                          'srl' => 
                          array (
                            'field' => 'srl',
                            'type' => 'bigint',
                            'len' => '20',
                            'null' => false,
                            'default' => NULL,
                            'extra' => 'auto_increment',
                          ),
                          'usn' => 
                          array (
                            'field' => 'usn',
                            'type' => 'bigint',
                            'len' => '20',
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                            '@relation' => 
                            array (
                              'user' => 'usn',
                            ),
                          ),
                          'url' => 
                          array (
                            'field' => 'url',
                            'type' => 'varchar',
                            'len' => '512',
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                          ),
                          'comment' => 
                          array (
                            'field' => 'comment',
                            'type' => 'text',
                            'len' => NULL,
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                          ),
                        ),
                        'user' => 
                        array (
                          '@primary_key' => 'usn',
                          'usn' => 
                          array (
                            'field' => 'usn',
                            'type' => 'bigint',
                            'len' => '20',
                            'null' => false,
                            'default' => NULL,
                            'extra' => 'auto_increment',
                            '@relation' => 
                            array (
                              'memo' => 'usn',
                            ),
                          ),
                          'loginname' => 
                          array (
                            'field' => 'loginname',
                            'type' => 'varchar',
                            'len' => '64',
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                          ),
                          'nickname' => 
                          array (
                            'field' => 'nickname',
                            'type' => 'varchar',
                            'len' => '128',
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                          ),
                          'passwd' => 
                          array (
                            'field' => 'passwd',
                            'type' => 'varchar',
                            'len' => '64',
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                          ),
                          'regdate' => 
                          array (
                            'field' => 'regdate',
                            'type' => 'varchar',
                            'len' => '19',
                            'null' => true,
                            'default' => NULL,
                            'extra' => '',
                          ),
                        ),
                      ); //}}}
    static $user_rows =  //{{{
               array(
                   array( 'usn'      => 1,
                          'loginname'=> 'loginname1',
                          'nickname' => 'nickname1',
                          'passwd'   => 'pwd1',
                          'regdate'  => '2000-01-01 00:00:00',
                          ),
                   array( 'usn'      => 2,
                          'loginname'=> 'loginname2',
                          'nickname' => 'nickname2',
                          'passwd'   => 'pwd2',
                          'regdate'  => '2001-01-01 00:00:00',
                          ),
                   ); //}}}
    // {{{
    static $write_data = "<?php
# このクラスはphpdao_factory::generate()を使って作成されています。
# 変更が必要な場合は、DBのスキーマを変更後、php ./bin/generate.php を行ってください
class phpdao_dao_schema
{
  public static \$schema = array (
      'memo'=>array( //{{{
        '@primary_key'=>'srl',
            'srl' => array(
              'field'    => 'srl',
              'type'     => 'bigint', 
              'len'      => '20', 
              'null'     => '',
              'default'  => '',
              'extra'    => 'auto_increment',
              
             ),
            'usn' => array(
              'field'    => 'usn',
              'type'     => 'bigint', 
              'len'      => '20', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              '@relation' => array(
                'user' => 'usn',
               ),
             ),
            'url' => array(
              'field'    => 'url',
              'type'     => 'varchar', 
              'len'      => '512', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              
             ),
            'comment' => array(
              'field'    => 'comment',
              'type'     => 'text', 
              'len'      => '', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              
             ),
          ), // }}}
      'user'=>array( //{{{
        '@primary_key'=>'usn',
            'usn' => array(
              'field'    => 'usn',
              'type'     => 'bigint', 
              'len'      => '20', 
              'null'     => '',
              'default'  => '',
              'extra'    => 'auto_increment',
              '@relation' => array(
                'memo' => 'usn',
               ),
             ),
            'loginname' => array(
              'field'    => 'loginname',
              'type'     => 'varchar', 
              'len'      => '64', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              
             ),
            'nickname' => array(
              'field'    => 'nickname',
              'type'     => 'varchar', 
              'len'      => '128', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              
             ),
            'passwd' => array(
              'field'    => 'passwd',
              'type'     => 'varchar', 
              'len'      => '64', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              
             ),
            'regdate' => array(
              'field'    => 'regdate',
              'type'     => 'varchar', 
              'len'      => '19', 
              'null'     => '1',
              'default'  => '',
              'extra'    => '',
              
             ),
          ), // }}}
  );

}"; //}}}
    static $array_where = array( //{{{
        "where usn = 1"                       => array('usn'=>1),
        "where nickname = 'test'"             => array('nickname'=>'test'),
        "where usn = 1 and nickname = 'test'" => array('usn'=>1,'nickname'=>'test'),
        "where usn is NULL"                   => array('usn'=>null),
        "where nickname is NULL"              => array('nickname'=>null),
        "where (usn > 10)"                    => array('@sql'=>'usn > 10'),
        ); //}}}
    static $array_quote = array( //{{{
        '1'           => array('usn'=>1),
        "'test'"      => array('nickname'=>'test'),
        ); //}}}

    public static function main() { // {{{
        $suite  = new PHPUnit2_Framework_TestSuite("test_phpdao_factory");
        $result = PHPUnit2_TextUI_TestRunner::run($suite);
    } // }}}
    /**
    * @todo Implement test_get_schema_from_db().
    */
    public function test_get_schema_from_db() { //{{{

      $schema = phpdao_factory::get_schema_from_db();
      if( false == $this->array_comp_recursive($schema,self::$schema))
      {
        throw new PHPUnit2_Framework_IncompleteTestError;
      }

      $schema = phpdao_factory::get_relation_from_file($schema);
      if( false == $this->array_comp_recursive($schema,self::$relation))
        throw new PHPUnit2_Framework_IncompleteTestError;
    } //}}}
    /**
    * @todo Implement test_write_schema().
    */
    public function test_write_schema() { //{{{
      try
      {
        $schema = phpdao_factory::get_schema_from_db();
        $schema = phpdao_factory::get_relation_from_file($schema);
        phpdao_factory::write_schema($schema);

        $content = file_get_contents( phpdao_cfg::get('root')."/dao/schema.php" );
      
        if( $content != self::$write_data )
        {
          $this->output("schema1",$content);
          $this->output("schema2",self::$write_data);
          throw new PHPUnit2_Framework_IncompleteTestError('schema.php fail');
        }

      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}
    /**
    * @todo Implement test_get_schema().
    */
    public function NOT_IMPREMENT_test_get_schema() { //{{{
      try
      {
        // 引数なし
        $all_schema = phpdao_factory::get_schema();
        if (false === $this->array_comp_recursive($all_schema, self::$schema))
          throw new PHPUnit2_Framework_IncompleteTestError('all_schema is failed');

        // tableを指定して取得
        $user_schema = phpdao_factory::get_schema('user');
        if (false === $this->array_comp_recursive($user_schema, self::$schema['user']))
          throw new PHPUnit2_Framework_IncompleteTestError('user_schema is failed');

        // columnを指定して取得
        $column = phpdao_factory::get_schema('user','usn');
        if (false === $this->array_comp_recursive($column, self::$schema['user']['usn']))
          throw new PHPUnit2_Framework_IncompleteTestError('column is failed');

        // 存在しないtableを指定 //{{{
        $ok = false;
        try 
        {
          $column = phpdao_factory::get_schema('NO_TABLE');
        }catch(exception $e)
        {
          $ok = true;
        }
        if(!$ok)
          throw new PHPUnit2_Framework_IncompleteTestError;
        //}}}
        // 存在しないcolumnを指定 //{{{
        $ok = false;
        try 
        {
          $column = phpdao_factory::get_schema('user','NO_COLUMN');
        }catch(exception $e)
        {
          $ok = true;
        }
        if(!$ok)
          throw new PHPUnit2_Framework_IncompleteTestError;
        //}}}

      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}

    /**
    * @todo Implement test_get_relation().
    */
    public function test_get_relation() { //{{{
      $test = array(
          'user' => array('memo',
                        array( 'source'=>array('table'=>'user','column'=>'usn'),
                               'target'=>array('table'=>'memo','column'=>'usn'),
                        ),
                    ),
          'memo' => array('user',
                        array( 'source'=>array('table'=>'memo','column'=>'usn'),
                               'target'=>array('table'=>'user','column'=>'usn'),
                        ),
                    ),
          );
      foreach( $test as $source_table => $relation )
      {
        $column = phpdao_factory::get_relation($source_table,$relation[0]);
        if( $column != $relation[1] )
        {
          echo "$column = {$relation[1]}\n";
          throw new PHPUnit2_Framework_IncompleteTestError;
        }
      }
    } //}}}

    /**
    * @todo Implement test_get_item().
    */
    public function test_get_item() { //{{{
      try
      {
        // where 条件なし
        if( $row = phpdao_factory::get_item('user') )
        {
          if( 1 != count($row) )
            throw new PHPUnit2_Framework_IncompleteTestError('count is failed.');

          if( false == $this->object_comp_recursive($row,self::$user_rows[0]) )
            throw new PHPUnit2_Framework_IncompleteTestError('$row is failed.');
        }else
        {
          throw new PHPUnit2_Framework_IncompleteTestError('phpdao_factory::get_item() returned false.');
        }
      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}
    /**
    * @todo Implement test_get_items().
    */
    public function test_get_items() { //{{{
      try
      {
        // where 条件なし
        if( $rows = phpdao_factory::get_items('user') )
        {
          if( 2 != count($rows) )
            throw new PHPUnit2_Framework_IncompleteTestError('count is failed.');

          if( false == $this->object_comp_recursive($rows,self::$user_rows) )
            throw new PHPUnit2_Framework_IncompleteTestError('$rows is failed.');
        }else
        {
          throw new PHPUnit2_Framework_IncompleteTestError('phpdao_factory::get_items() returned false.');
        }

      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}
    /**
    * @todo Implement test_array_to_where().
    */
    public function test_array_to_where() { //{{{
      try
      {
        foreach( self::$array_where as $sql => $where )
        {
          if( trim($sql) != trim(($result = phpdao_factory::array_to_where('user',$where))))
            throw new PHPUnit2_Framework_IncompleteTestError("Error:sql=[$sql]:result=[$result]");
        }
      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}
    /**
    * @todo Implement test_quote().
    */
    public function test_quote() { //{{{
      try
      {
        foreach( self::$array_quote as $quote => $value )
        {
          foreach( $value as $column => $value )
            if( trim($quote) != trim(($result = phpdao_factory::quote('user',$column,$value))))
              throw new PHPUnit2_Framework_IncompleteTestError("Error:quote=[$quote]:result=[$result]");
        }
      }catch(exception $e)
      {
        throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
      }
    } //}}}

    // 
    public function array_comp_recursive($arr1, $arr2) //{{{
    {
      ksort($arr1);
      ksort($arr2);
      if( $arr1 != $arr2 )
      {
        $this->output("arr1",$arr1);
        $this->output("arr2",$arr2);
        return false;
      }
      foreach($arr1 as $key => $val )
      {
        if( is_array($val) )
          if( false == $this->array_comp_recursive($val,$arr2[$key]) )
          {
            echo "arr1[$key] is different.\n";
            return false;
          }

        if( array_key_exists($key, $arr2) )
          if( $val != $arr2[$key] )
          {
            echo "arr1[$key] is different.\n";
            return false;
          }
      }
      return true;
    } //}}}
    public function object_comp_recursive($obj1, $obj2) //{{{
    {
      foreach($obj1 as $key => $val )
      {
        if( substr(0,2,$key) == '__')
          continue;

        if( is_array($val) || is_object($val))
        {
          if( false == $this->object_comp_recursive($val,$obj2[$key]) )
            return false;
          else
            continue;
        }

        if( array_key_exists($key, $obj2) )
          if( $val != $obj2[$key] )
            return false;
      }
      return true;
    } //}}}
    
    public function output($filename,$data) // {{{
    {
      ob_start();
      var_dump($data);
      $str = ob_get_contents();
      ob_end_flush();
      file_put_contents($filename,$str);
    } // }}}
}
if (PHPUnit2_MAIN_METHOD == "test_phpdao_factory::main") {
    test_phpdao_factory::main();
}
