<?php
if (!defined("PHPUnit2_MAIN_METHOD")) {
      define("PHPUnit2_MAIN_METHOD", "test_phpdao_dao_querybuilder::main");
}
require_once "../src/phpdao.php";
require_once "PHPUnit2/Framework/IncompleteTestError.php";
require_once "PHPUnit2/Framework/TestCase.php";
require_once "PHPUnit2/Framework/TestSuite.php";
require_once "PHPUnit2/TextUI/TestRunner.php";

class test_phpdao_dao_querybuilder extends PHPUnit2_Framework_TestCase {

    public static function main() { //{{{
        $suite  = new PHPUnit2_Framework_TestSuite("test_phpdao_dao_querybuilder");
        $result = PHPUnit2_TextUI_TestRunner::run($suite);
    } //}}}
    /**
    * insert
    */
    public function test_insert() { //{{{
      $testdata = array(  //{{{
          array('table'=>'user',
                'values'=>array('nickname'=>'testname'),
                "result"=>"insert into user (nickname) values ('testname')"), // 通常ケース(string)
          array('table'=>'user',
                'values'=>array('usn'=>1),
                "result"=>"insert into user (usn) values (1)"), // 通常ケース(int)
          array('table'=>'user',
                'values'=>array('nickname'=>null),
                "result"=>"insert into user (nickname) values ('')"), // 通常ケース(null)
          array('table'=>'user',
                'values'=>array('usn'=>1,'nickname'=>'testname'),
                "result"=>"insert into user (usn,nickname) values (1,'testname')"), // 通常ケース(複数value設定)
          array('table'=>'NOT_EXIST_TABLE',
                'values'=>array('usn'=>1),
                "result"=>null,
                'exception'=>true,), // tableがない ( exception発生)
          array('table'=>'user',
                'values'=>array('NOT_EXIST_COLUMN'=>1),
                "result"=>null,
                'exception'=>true,), // columnがない ( exception発生)
          ); //}}}
      foreach( $testdata as  $test )
      {
        try
        {
          if( $test['result'] != ($result = phpdao_dao_querybuilder::insert($test['table'],$test['values'])))
          {
            throw new PHPUnit2_Framework_IncompleteTestError("RESULT UNMATCH:$result != {$test['result']}");
          }

        }catch(exception $e)
        {
          if( true != $test['exception'] )
            throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
        }
      }
    } //}}}
    /**
    * select
    */
    public function test_select() { // {{{
      $testdata = array(  //{{{
          array('table'=>'user',
                'column'=>'*',
                'where'=>array('usn'=>1),
                'result'=>'select * from user where usn = 1'), // 通常ケース
          array('table'=>'user',
                'column'=>'usn,nickname',
                'where'=>array(),
                'result'=>'select usn,nickname from user'), // whereなし
          array('table'=>'memo',
                'column'=>'srl',
                'where'=>array(),
                'result'=>'select srl from memo'),  // 別テーブル
          array('table'=>'NOT_EXIST_TABLE',
                'column'=>'srl',
                'where'=>array(),
                'result'=>null,
                'exception'=>true),  // 存在しないtable
          array('table'=>'memo',
                'column'=>'NO_EXIST_COLUMN',
                'where'=>array(),
                'result'=>null,
                'exception'=>true),  // 存在しないcolumn
          ); //}}}
      foreach( $testdata as $test )
      {
        try
        {
          $result = phpdao_dao_querybuilder::select($test['table'],$test['column'],$test['where'],$test['join']);
          if( $test['result'] != $result )
            throw new PHPUnit2_Framework_IncompleteTestError("$result != {$test['result']}");
        } catch(exception $e)
        {
          if( true != $test['exception'] )
            throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
        }
      }
    } // }}}
    /**
    * update
    */
    public function test_update() { //{{{
      $testdata = array(  //{{{
          array('table'=>'user',
                'values'=>array('nickname'=>'testname'),
                'where' =>array(),
                'result'=>"update user set nickname='testname'", 
                'exception'=>false),  // 通常ケース(string)
          array('table'=>'user',
                'values'=>array('usn'=>1),
                'where' =>array(),
                'result'=>"update user set usn=1", 
                'exception'=>false),  // 通常ケース(int)
          array('table'=>'user',
                'values'=>array('usn'=>1),
                'where' =>array('nickname'=>'nick'),
                'result'=>"update user set usn=1 where nickname = 'nick'", 
                'exception'=>false),  // 通常ケース(where string)
          array('table'=>'user',
                'values'=>array('usn'=>1),
                'where' =>array('usn'=>1),
                'result'=>"update user set usn=1 where usn = 1", 
                'exception'=>false),  // 通常ケース(where int)
          array('table'=>'memo',
                'values'=>array('srl'=>1),
                'where' =>array('usn'=>1),
                'result'=>"update memo set srl=1 where usn = 1", 
                'exception'=>false),  // 別テーブル
          array('table'=>'NOT_EXIST_TABLE',
                'values'=>array('srl'=>1),
                'where' =>array('usn'=>1),
                'result'=>null,
                'exception'=>true),  // 存在しないテーブル
          array('table'=>'memo',
                'values'=>array('NOT_EXIST_COLUMN'=>1),
                'result'=>null, 
                'exception'=>true),  // 存在しないcolumn
          array('table'=>'memo',
                'values'=>array('srl'=>1),
                'where' =>array('NOT_EXIST_COLUMN'=>1),
                'result'=>null,
                'exception'=>true),  // 存在しないcolumn (where)
          ); //}}}
      foreach( $testdata as $test )
      {
        try
        {
          $result = phpdao_dao_querybuilder::update($test['table'],$test['values'],$test['where']);
          if( $test['result'] != $result )
            throw new PHPUnit2_Framework_IncompleteTestError("$result != {$test['result']}");
        } catch(exception $e)
        {
          if( true != $test['exception'] )
            throw new PHPUnit2_Framework_IncompleteTestError($e->getMessage());
        }
      }
    } //}}}
}

if (PHPUnit2_MAIN_METHOD == "test_phpdao_dao_querybuilder::main") {
    test_phpdao_dao_querybuilder::main();
}
