/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  12 16 2011 12:06:38 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x18,0x00,0x6a,0x55,0x5e,0x2a,0x26,0x4f,0x26,0x2d, /* MPFS....jU^.&O&- */ \
	0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff, /* ....j....r..J... */ \
	0x6a,0xe3,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff, /* j........O..&... */ \
	0x8a,0xb6,0xff,0xff,0xca,0xb4,0xff,0xff,0x48,0x02,0x00,0x00,0x35,0x03,0x00,0x00, /* ........H...5... */ \
	0x9e,0x03,0x00,0x00,0xd0,0xee,0xca,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x53,0x02, /* .......N......S. */ \
	0x00,0x00,0xd3,0x06,0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* .............N.. */ \
	0x00,0x00,0x01,0x00,0x5d,0x02,0x00,0x00,0x95,0x0c,0x00,0x00,0xa0,0x00,0x00,0x00, /* ....]........... */ \
	0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x68,0x02,0x00,0x00,0x35,0x0d, /* .B.N......h...5. */ \
	0x00,0x00,0xe2,0x03,0x00,0x00,0x44,0x0c,0xea,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ......D..N...... */ \
	0x73,0x02,0x00,0x00,0x17,0x11,0x00,0x00,0x1b,0x04,0x00,0x00,0x27,0x7c,0xab,0x4e, /* s...........'|.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x7d,0x02,0x00,0x00,0x32,0x15,0x00,0x00,0x68,0x00, /* ......}...2...h. */ \
	0x00,0x00,0x27,0x7c,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x00,0x00, /* ..'|.N......~... */ \
	0x9a,0x15,0x00,0x00,0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00, /* ........J..N.... */ \
	0x02,0x00,0x89,0x02,0x00,0x00,0x69,0x18,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7, /* ......i...H...J. */ \
	0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x8a,0x02,0x00,0x00,0xb1,0x18,0x00,0x00, /* .N.............. */ \
	0xf8,0x08,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xa1,0x02, /* .....8.N........ */ \
	0x00,0x00,0xa9,0x21,0x00,0x00,0x80,0x00,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00, /* ...!.......8.N.. */ \
	0x00,0x00,0x00,0x00,0xa2,0x02,0x00,0x00,0x29,0x22,0x00,0x00,0x03,0x02,0x00,0x00, /* ........)"...... */ \
	0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xba,0x02,0x00,0x00,0x2c,0x24, /* .".N..........,$ */ \
	0x00,0x00,0x20,0x00,0x00,0x00,0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .. ....".N...... */ \
	0xbb,0x02,0x00,0x00,0x4c,0x24,0x00,0x00,0x9f,0x0a,0x00,0x00,0xd7,0x33,0xb5,0x4e, /* ....L$.......3.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xd3,0x02,0x00,0x00,0xeb,0x2e,0x00,0x00,0xb0,0x00, /* ................ */ \
	0x00,0x00,0xd7,0x33,0xb5,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xd4,0x02,0x00,0x00, /* ...3.N.......... */ \
	0x9b,0x2f,0x00,0x00,0xf8,0x0b,0x00,0x00,0xd1,0xeb,0xca,0x4e,0x00,0x00,0x00,0x00, /* ./.........N.... */ \
	0x02,0x00,0xe7,0x02,0x00,0x00,0x93,0x3b,0x00,0x00,0xa0,0x00,0x00,0x00,0xd1,0xeb, /* .......;........ */ \
	0xca,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xe8,0x02,0x00,0x00,0x33,0x3c,0x00,0x00, /* .N..........3<.. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xfa,0x02, /* .......N........ */ \
	0x00,0x00,0xf9,0x3f,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...?.........N.. */ \
	0x00,0x00,0x00,0x00,0xfb,0x02,0x00,0x00,0x11,0x40,0x00,0x00,0x08,0x00,0x00,0x00, /* .........@...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x0e,0x03,0x00,0x00,0x19,0x40, /* ...N...........@ */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x0f,0x03,0x00,0x00,0x21,0x40,0x00,0x00,0x06,0x02,0x00,0x00,0xcb,0x00,0xb7,0x4e, /* ....!@.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x22,0x03,0x00,0x00,0x27,0x42,0x00,0x00,0x20,0x00, /* ......"...'B.. . */ \
	0x00,0x00,0xcb,0x00,0xb7,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x03,0x00,0x00, /* .....N......#... */ \
	0x47,0x42,0x00,0x00,0x6c,0x03,0x00,0x00,0xc3,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00, /* GB..l......N.... */ \
	0x02,0x00,0x34,0x03,0x00,0x00,0xb3,0x45,0x00,0x00,0x30,0x00,0x00,0x00,0xc3,0xf2, /* ..4....E..0..... */ \
	0xad,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x66,0x6f,0x6f, /* ss.7m3tjz.js.foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ter.inc.header.i */ \
	0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74, /* nc.index.htm..st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64, /* atus.htm..nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* apter/config.htm */ \
	0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f, /* ..nodeadapter/co */ \
	0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61, /* nfig2.htm..nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66, /* tm..protect/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ig.htm..protect/ */ \
	0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* index.htm..prote */ \
	0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70, /* ct/reboot.cgi..p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74, /* rotect/reboot.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* m..protect/user. */ \
	0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad, /* htm............. */ \
	0x56,0x4d,0x6f,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe,0x03,0x52,0xaf,0x01,0x41,0x08, /* VMo.0.=7R..R..A. */ \
	0x69,0x4b,0x4f,0xab,0xbd,0xef,0x71,0xef,0x06,0x8f,0x83,0x55,0x07,0x23,0x63,0x9a, /* iKO...q....U.#c. */ \
	0x74,0xab,0xfe,0xf7,0xb5,0x8d,0x01,0x03,0x4e,0xaa,0x95,0xb6,0x48,0x6d,0x31,0x9e, /* t.......N...Hm1. */ \
	0xf7,0xc6,0xf3,0xe6,0xc3,0x05,0xc7,0x1f,0xc1,0xe7,0x76,0xf3,0x40,0x78,0x2d,0x43, /* ..........v.@x-C */ \
	0x82,0xce,0x94,0x7d,0xe4,0xc1,0x6f,0x10,0x18,0xd5,0x68,0x17,0xfc,0x10,0x14,0xb1, /* ...}..o...h..... */ \
	0x5d,0xd0,0xa2,0xba,0x0d,0x5b,0x10,0x94,0xbc,0xaa,0xad,0x05,0x2a,0xdf,0x4e,0x82, /* ]....[........N. */ \
	0x77,0x35,0xce,0x83,0xc7,0xac,0xd0,0x8f,0x5e,0x3e,0x23,0x71,0xa2,0x75,0x1e,0xc4, /* w5......^>#q.u.. */ \
	0xcd,0x35,0x40,0x9d,0xe4,0x7a,0xad,0x41,0x18,0xd3,0xfa,0xa4,0x16,0xd5,0xb3,0xd7, /* .5@..z.A........ */ \
	0x5f,0x62,0xb5,0xfc,0xb5,0xdd,0x6c,0x37,0x8f,0x6d,0x85,0x30,0xbf,0x84,0xbc,0x06, /* _b....l7.m.0.... */ \
	0xe3,0xc0,0x85,0x62,0x59,0xe5,0xc1,0xd3,0x51,0xed,0x32,0x2c,0x5c,0x60,0x10,0x79, /* ...bY...Q.2,\`.y */ \
	0x90,0x28,0xa3,0x96,0x33,0x8a,0x15,0x57,0x96,0x4d,0x5f,0x42,0xc9,0x9b,0xdc,0xc0, /* .(..3..W.M_B.... */ \
	0xf9,0x98,0xbf,0x26,0x02,0x79,0xe1,0x86,0xc0,0x03,0x78,0x28,0xf4,0xe3,0xc3,0x74  /* ...&.y....x(...t */
#define DATACHUNK000001 \
	0xed,0x2b,0x01,0x70,0x13,0xe1,0x70,0xf8,0xc6,0x9c,0xf0,0x4e,0xdc,0xb2,0x4e,0x91, /* .+.p..p....N..N. */ \
	0x7e,0x6e,0x00,0x28,0x88,0x06,0x9d,0x6e,0x32,0xa7,0x69,0xba,0x12,0x83,0x10,0xe2, /* ~n.(...n2.i..... */ \
	0x0d,0xd0,0x28,0xc3,0xde,0x06,0xd7,0xa8,0xdd,0xd2,0x3f,0xa0,0x20,0xe3,0x46,0xce, /* ..(.......?. .F. */ \
	0x09,0x25,0x9e,0x32,0xc2,0xb3,0x47,0x52,0xc9,0xac,0x57,0x2e,0x77,0xac,0x7e,0x7a, /* .%.2..GR..W.w.~z */ \
	0xfa,0x91,0xed,0xe0,0x90,0x5d,0x80,0x9e,0x2a,0x99,0x07,0x05,0x67,0x58,0x2f,0x96, /* .....]......gX/. */ \
	0x9c,0x71,0x31,0xb9,0xdc,0x4b,0x18,0x16,0x5c,0x4a,0x7e,0x56,0x84,0x59,0x6f,0x5a, /* .q1..K..\J~V.YoZ */ \
	0x59,0xab,0xe4,0x68,0xde,0x5d,0x07,0x22,0xa1,0x3f,0xf5,0x9e,0x32,0x8e,0xd4,0x26, /* Y..h.].".?..2..& */ \
	0xb3,0xf0,0x3a,0xa5,0x52,0x1a,0xdb,0xd3,0x4a,0xb8,0xca,0x10,0x31,0x7a,0xaa,0xa7, /* ..:.R...J...1z.. */ \
	0x4d,0x3d,0xd4,0x19,0xea,0xce,0x85,0x60,0x40,0x5c,0x84,0x24,0xb3,0x08,0xf6,0x48, /* M=.....`@\.$...H */ \
	0xa1,0xe8,0xdd,0xb1,0x61,0x74,0x30,0x90,0x9b,0xc3,0xc9,0xc1,0x9a,0x61,0xda,0x36, /* ....at0......a.6 */ \
	0x0c,0xa9,0x82,0x2a,0x18,0x2f,0xdf,0x56,0x72,0x4d,0x21,0xb3,0xd1,0xb8,0x54,0x54, /* ...../.VrM!...TT */ \
	0xc2,0x2c,0x84,0xcf,0x77,0x42,0x68,0x65,0x1e,0x63,0x36,0xe5,0x86,0x0d,0xaa,0x39, /* .,..wBhe.c6....9 */ \
	0x37,0x86,0x92,0x0b,0x24,0x29,0x57,0x87,0xaf,0x55,0xb1,0x2d,0xfc,0xce,0x2b,0xfe, /* 7...$)W..U.-..+. */ \
	0x0e,0x62,0x2d,0x27,0x36,0xe9,0xd5,0xef,0x2c,0x15,0x3b,0xd4,0xd2,0x3d,0x62,0xb6, /* .b-'6...,.;..=b. */ \
	0xb7,0x0a,0x2d,0x63,0xbf,0x88,0x54,0xe2,0x46,0x6a,0xc0,0xe9,0x83,0x35,0x64,0x40, /* ..-c..T.Fj...5d@ */ \
	0x19,0xc7,0xdf,0x3b,0x3b,0x9a,0x3a,0xfe,0x0e,0x00,0xbd,0xab,0x6b,0x00,0x75,0x10, /* ...;;.:.....k.u. */ \
	0x10,0x8c,0x7a,0x50,0xaa,0xc4,0x00,0xd8,0xa4,0xeb,0xeb,0x64,0xf2,0x33,0x6a,0x1b, /* ..zP.......d.3j. */ \
	0x54,0x0e,0x1c,0x0c,0x90,0xd0,0x21,0x97,0xd5,0x88,0x42,0x38,0x97,0xf6,0xb3,0x53, /* T.....!...B8...S */ \
	0x23,0x71,0xf4,0x0c,0x67,0x37,0xb3,0x8f,0xc7,0xe3,0x32,0xf9,0x4a,0x45,0x0e,0xc2, /* #q..g7....2.JE.. */ \
	0x6d,0x59,0x3a,0x3e,0x41,0x66,0x1a,0x63,0xb0,0x4c,0x36,0xe3,0x57,0x32,0x6b,0x87, /* mY:>Af.c.L6.W2k. */ \
	0x76,0x4d,0x6d,0xc7,0x4a,0x75,0xc0,0x03,0x8b,0xed,0xa8,0x12,0xc9,0xae,0x9d,0x65, /* vMm.Ju.........e */ \
	0xe2,0xd3,0x7d,0x99,0x26,0x7c,0xd7,0xa1,0x65,0xfb,0x9d,0x73,0x79,0x93,0x71,0xe6, /* ..}.&|..e..sy.q. */ \
	0x40,0x63,0x5c,0x18,0x29,0xb2,0xfe,0x74,0xea,0x77,0xe2,0x16,0x24,0x55,0xf2,0xd4, /* @c\.)..t.w..$U.. */ \
	0x0a,0x21,0x5c,0xba,0x30,0xf6,0xbf,0x08,0xae,0xe8,0xdc,0x30,0x28,0xf8,0xd5,0xd1, /* .!\.0......0(... */ \
	0x2b,0x37,0x31,0xd3,0x25,0x16,0x8c,0xff,0xf9,0x6a,0xc6,0x77,0x82,0xd4,0x49,0x95, /* +71.%....j.w..I. */ \
	0x5e,0x93,0x49,0x12,0x27,0xfd,0x1f,0x31,0x1e,0x0f,0x15,0x95,0x1c,0xc3,0x7a,0x44, /* ^.I.'..1......zD */ \
	0xfe,0x54,0x6d,0x9d,0xaa,0x2c,0xf8,0x05,0x97,0xdd,0xf0,0xb2,0x0b,0x08,0xbd,0x02, /* .Tm..,.......... */ \
	0x0e,0x4d,0xf0,0xed,0x8b,0x73,0x16,0x10,0x25,0x6d,0x3d,0x9d,0x93,0xc0,0xcb,0xeb, /* .M...s..%m=..... */ \
	0x22,0x5e,0x4e,0x4b,0xd4,0x2d,0x69,0x95,0x06,0xfd,0xe2,0x7e,0xaa,0x78,0x28,0xd2, /* "^NK.-i....~.x(. */ \
	0x89,0x49,0x08,0x2e,0xdc,0x04,0x9f,0x43,0xac,0xa4,0x9f,0x3b,0x83,0xf1,0x3d,0x9e, /* .I.....C...;..=. */ \
	0x97,0x78,0x9a,0x4e,0x63,0x35,0x1d,0x9d,0x19,0xe5,0x64,0x28,0x6a,0x2b,0x27,0xe6, /* .x.Nc5....d(j+'. */ \
	0x63,0x82,0x65,0x0b,0x37,0xe2,0x45,0xab,0x77,0x0a,0xd1,0xd1,0xdf,0x0e,0x25,0x47, /* c.e.7.E.w.....%G */ \
	0xb9,0xa1,0x57,0x2f,0x3b,0x4e,0x36,0x01,0x10,0x0a,0x0c,0xb7,0x20,0xff,0x6f,0xf6, /* ..W/;N6..... .o. */ \
	0xdc,0x48,0x94,0x91,0x0c,0xd3,0xf7,0x79,0x01,0xe8,0xf8,0x69,0x2e,0xfd,0x77,0x18, /* .H.....y...i..w. */ \
	0x29,0x6b,0x13,0x86,0x0a,0x60,0x6b,0xd9,0xc2,0xe4,0xe0,0xeb,0x0b,0xfb,0x7e,0x6d, /* )k...`k.......~m */ \
	0xa8,0xf3,0x63,0x7c,0x67,0x50,0x34,0xbc,0xa5,0x7d,0x4b,0x44,0x85,0xd2,0xb1,0x93, /* ..c|gP4..}KD.... */ \
	0xb0,0x72,0x80,0xd6,0x4d,0x27,0xd7,0xe4,0x43,0x4b,0x1a,0x68,0xf6,0x3e,0xe7,0x8d, /* .r..M'..CK.h.>.. */ \
	0x6d,0xd4,0x9e,0xdd,0xc6,0x33,0x5d,0xc3,0x56,0x1b,0x11,0x4e,0x3c,0x3b,0x67,0x7d, /* m....3].V..N<;g} */ \
	0xd2,0x4a,0x3b,0xb7,0x2e,0x3a,0x35,0xe7,0x6a,0x6d,0x5e,0x7c,0x67,0x3f,0x1b,0xf2, /* .J;..:5.jm^|g?.. */ \
	0x23,0x80,0xde,0x81,0x04,0xcc,0x46,0xf5,0xde,0x2b,0xc7,0xe0,0x68,0xea,0x23,0x72, /* #.....F..+..h.#r */ \
	0x6e,0x9b,0x77,0x79,0x23,0x01,0x6d,0xc7,0xe4,0x76,0xf3,0xb9,0x5d,0xf4,0xfb,0x7f, /* n.wy#.m..v..]... */ \
	0xcb,0xbe,0xf9,0x7d,0xcf,0x3f,0x4e,0xfc,0xf7,0x03,0xb7,0xae,0x01,0x46,0xd1,0x1f, /* ...}.?N......F.. */ \
	0x22,0xfe,0x66,0x0e,0x36,0x94,0xec,0x38,0xb1,0x0a,0xd3,0xdf,0x17,0x86,0xc4,0xdc, /* ".f.6..8........ */ \
	0x48,0x94,0xe5,0x83,0x36,0x25,0x88,0x32,0xaf,0x71,0x71,0xf4,0x18,0x13,0x98,0x19, /* H...6%.2.qq..... */ \
	0x77,0xb5,0x9f,0xb8,0x2c,0x7d,0xb6,0x04,0x5b,0xdb,0xbf,0xbc,0xb1,0x55,0x26,0xa5, /* w...,}..[....U&. */ \
	0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d, /* ..............W] */ \
	0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e, /* o.6.}V...;?,2.8N */ \
	0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb, /* ....;.I.fH. q... */ \
	0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72, /* .h.....JRv."?h.r */ \
	0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0, /* ...,.iQ.}Y.X.... */ \
	0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f, /* ..O......F....CO */ \
	0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68, /* F.'.OF.#z.2....h */ \
	0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79, /* ".y..}...2.....y */ \
	0x05,0x4b,0x46,0x5a,0x69,0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d, /* .KFZi.2........] */ \
	0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96, /* .....k.u"..\g.B. */ \
	0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b, /* N8.K.iC..di%..O. */ \
	0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65, /* ..(...s..Y.RZZ.e */ \
	0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6, /* I.;...u.,e....F. */ \
	0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed, /* .sj...]o.o)...U. */ \
	0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a, /* ^.....F..::Z..=. */ \
	0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49, /* .:.....Z....o.oI */ \
	0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97, /* .a.%.......%.... */ \
	0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2, /* .{...+:5F...I4.. */ \
	0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49  /* TN....2#ez..e..I */
#define DATACHUNK000002 \
	0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c, /* m.g...p.."..X... */ \
	0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28, /* ..L.h...s......( */ \
	0x12,0x34,0xab,0xcb,0xcc,0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a, /* .4...3.....+...z */ \
	0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac, /* ...../)..K...... */ \
	0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9, /* .p.58 ..3.a..A.. */ \
	0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37, /* .)./...r..xF..77 */ \
	0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5, /* .$.L. .:..;..J.. */ \
	0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda, /* t...ka...vB..... */ \
	0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b, /* .V....I.....|.-. */ \
	0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e, /* x..}..K|.9.+x... */ \
	0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b, /* ....kv......W~.; */ \
	0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90, /* .....<o..9...... */ \
	0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6, /* }0fOt_..`....D.. */ \
	0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f, /* .......|....G... */ \
	0x19,0x08,0x4a,0x70,0x08,0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9, /* ..Jp..$~..1v!.f. */ \
	0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7, /* ....!\....&,.... */ \
	0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65, /* ....8...?.g....e */ \
	0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f, /* .2..1[......I.Y. */ \
	0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23, /* ...P...../..)<V# */ \
	0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44, /* ..?..<0.m..q..gD */ \
	0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56, /* .......Q.t..S.BV */ \
	0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84, /* O..C....$.....S. */ \
	0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf, /* .R...........6V. */ \
	0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee, /* ..s2..u..mvP.v.. */ \
	0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d, /* .}.}...F...F.... */ \
	0x21,0x51,0x91,0x62,0xe3,0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15, /* !Q.b.6..w..M.... */ \
	0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6, /* ..!.}...Qa.)^... */ \
	0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9, /* ....~...R...^".. */ \
	0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35, /* ,..9.r. .M!....5 */ \
	0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18, /* ...me}T+..N.W.(. */ \
	0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2, /*  ..IL..6.%qyQ... */ \
	0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a, /* 2.$...(......<.: */ \
	0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a, /* ....../.FSI.P[.. */ \
	0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70, /* Y....)zNh....1.p */ \
	0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08, /* .I6&..v.f.LN.... */ \
	0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39, /* .$.|...~5......9 */ \
	0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc, /* ~..^+..%M...fR.. */ \
	0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7, /* ...Qj..5%_...... */ \
	0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98, /* ....#..X......}. */ \
	0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71, /* '..r4...:.we..bq */ \
	0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91, /* .u..8vv.J....F.. */ \
	0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc, /* ..G...~...#..^.. */ \
	0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87, /* .6}.e!...M65.... */ \
	0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2, /* >t..-i.....b}.?. */ \
	0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f, /* >T%..&...O.k.... */ \
	0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67, /* .1.............g */ \
	0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b, /* ...\.h)........K */ \
	0x76,0x91,0xc5,0x54,0x9b,0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac, /* v..T..C..oZ..... */ \
	0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75, /* .v......y..Y%.bu */ \
	0xe3,0xac,0x06,0x30,0x48,0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b, /* ...0H.c........K */ \
	0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49, /* ..U.8.4.......KI */ \
	0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc, /* +.x........y4... */ \
	0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d, /* Ne1...y....!Z..} */ \
	0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd, /* .....f.....[.U.. */ \
	0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84, /* b.......0....... */ \
	0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34, /* .....H)..B.....4 */ \
	0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90, /* ....rT.BW~..jar. */ \
	0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe, /* d...&.f7..o..X:. */ \
	0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76, /* ..r.$....(..RV>v */ \
	0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13, /* .L,....".0...... */ \
	0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d, /* .......;X...x..} */ \
	0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38, /* bC.E...M....G..8 */ \
	0x1e,0x22,0x67,0x80,0xba,0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46, /* ."g...@......M3F */ \
	0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed  /* ..jS">.=0..Q"NZ. */
#define DATACHUNK000003 \
	0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30, /* ....J.~D....j..0 */ \
	0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e, /* .."....#.Ja.9..N */ \
	0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70, /* .D..F.p.I#. ...p */ \
	0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77, /* f.......Jg_.'..w */ \
	0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e, /* ...t...=.).&3WE> */ \
	0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76, /* ,1.{...`#}.N.uVv */ \
	0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d, /* ...|......4H...] */ \
	0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a, /* .!'......M..s... */ \
	0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b, /* ..g....O..../... */ \
	0x2d,0xa8,0x0e,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* -....<div class= */ \
	0x22,0x73,0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* "spacer">&nbsp;< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* /div>..<div id=" */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68, /* footer">Copyrigh */ \
	0x74,0x20,0x26,0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61, /* t &copy; 2011 Sa */ \
	0x74,0x6f,0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33, /* toshi Yasuda 7m3 */ \
	0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* tjz/ad6gz</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* ...</div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f, /* >....</body>..</ */ \
	0x68,0x74,0x6d,0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68, /* html><!DOCTYPE h */ \
	0x74,0x6d,0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57, /* tml PUBLIC "-//W */ \
	0x33,0x43,0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e, /* 3C//DTD XHTML 1. */ \
	0x30,0x20,0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20, /* 0 Strict//EN"..  */ \
	0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e, /*  "http://www.w3. */ \
	0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54, /* org/TR/xhtml1/DT */ \
	0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e, /* D/xhtml1-strict. */ \
	0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c, /* dtd">..<html xml */ \
	0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77, /* ns="http://www.w */ \
	0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c, /* 3.org/1999/xhtml */ \
	0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20, /* " xml:lang="en"  */ \
	0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61, /* lang="en">..<hea */ \
	0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x64,0x53,0x71,0x75,0x72, /* d>..<title>dSqur */ \
	0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61,0x6d, /* e Client Program */ \
	0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20, /* </title>..<link  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73, /* href="/7m3tjz.cs */ \
	0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65, /* s" rel="styleshe */ \
	0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63, /* et" type="text/c */ \
	0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* ss" />..<script  */ \
	0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22, /* src="/7m3tjz.js" */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* script"></script */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62, /* >..</head>....<b */ \
	0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73, /* ody>..<div id="s */ \
	0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20, /* hadow-one"><div  */ \
	0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e, /* id="shadow-two"> */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d, /* <div id="shadow- */ \
	0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* three"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c, /* shadow-four">..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a, /* div id="page">.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c,0x65, /* ..<div id="title */ \
	0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x69, /* "><div class="ri */ \
	0x67,0x68,0x74,0x22,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65, /* ght">dSqure Clie */ \
	0x6e,0x74,0x20,0x56,0x30,0x30,0x2e,0x32,0x32,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* nt V00.22</div>< */ \
	0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e, /* span id="hello"> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64, /* &nbsp;</span></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* iv>....<div id=" */ \
	0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d, /* menu">..<a href= */ \
	0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65, /* "/index.htm">Ove */ \
	0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72, /* rview</a>..<a hr */ \
	0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e, /* ef="/protect/con */ \
	0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b, /* fig.htm">Network */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f, /* a>..<a href="/no */ \
	0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67  /* deadapter/config */
#define DATACHUNK000004 \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74, /* .htm">Node Adapt */ \
	0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* er Configuration */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66, /* nodeadapter/conf */ \
	0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20, /* ig2.htm">Beacon  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61, /* Configuration</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* >..<a href="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33, /* eadapter/config3 */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20, /* .htm">TX Header  */ \
	0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Replace Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72, /* ation</a>..<a hr */ \
	0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65, /* ef="/protect/use */ \
	0x72,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26, /* r.htm">User ID & */ \
	0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e, /*  Password settin */ \
	0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* g</a>..<a href=" */ \
	0x2f,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72, /* /status.htm">Cur */ \
	0x72,0x65,0x6e,0x74,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d, /* rent Status</a>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .</div>~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65, /* h1>D-STAR dSqure */ \
	0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /*  Client</h1>.... */ \
	0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61, /* <table style="pa */ \
	0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78, /* dding-left: 10px */ \
	0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* ;">..<tr><td><b> */ \
	0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f, /* dSqure Server Do */ \
	0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* main Name :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e, /* td><td>~server_n */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62, /* <tr><td><b>Out b */ \
	0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* ound Port :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74, /* td><td>~out_port */ \
	0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ~</td></tr>..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64, /* ><td><b>In bound */ \
	0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Port :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64, /* td>~in_port~</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* ></tr>..<tr><td> */ \
	0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f, /* <b>Conference Ro */ \
	0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* om Name :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c, /* ><td>~RoomName~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73, /* td><b>Node Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ign :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* >~NodeName~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c, /* b>Access Control */ \
	0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /*  File Name :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c, /* /td><td>~AccCtrl */ \
	0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ~</td></tr>..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76, /* ><td><b>NTP Serv */ \
	0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a, /* er Domain Name : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70, /* sp;</td><td>~Ntp */ \
	0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* Name~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65, /* .<tr><td><b>Time */ \
	0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Zone :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e  /* td>~TimeZone~ &n */
#define DATACHUNK000005 \
	0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e, /* bsp;hours&nbsp;~ */ \
	0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e, /* TimeZoneMinutes~ */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74, /* &nbsp;minutes</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65, /* ><b>Jitter Buffe */ \
	0x72,0x20,0x57,0x61,0x69,0x74,0x20,0x50,0x61,0x63,0x6b,0x65,0x74,0x73,0x3a,0x3c, /* r Wait Packets:< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74, /* p;</td><td>~Jitt */ \
	0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* erSize~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >..</table>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* script">..<!--.. */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d, /* document.getElem */ \
	0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29, /* entById('hello') */ \
	0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68, /* .innerHTML = "~h */ \
	0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* ellomsg~";..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a, /* >..</script>.... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xb0,0x00,0x00,0x00,0x4a,0x00, /* ......3.......J. */ \
	0x00,0x00,0x00,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x4c,0x01,0x00,0x00,0x4c,0x00, /* ......K...L...L. */ \
	0x00,0x00,0x9e,0x01,0x00,0x00,0x4d,0x00,0x00,0x00,0xea,0x01,0x00,0x00,0x4e,0x00, /* ......M.......N. */ \
	0x00,0x00,0x41,0x02,0x00,0x00,0x5f,0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x60,0x00, /* ..A..._.......`. */ \
	0x00,0x00,0xdc,0x02,0x00,0x00,0x61,0x00,0x00,0x00,0xf8,0x02,0x00,0x00,0x6d,0x00, /* ......a.......m. */ \
	0x00,0x00,0x64,0x03,0x00,0x00,0x6e,0x00,0x00,0x00,0xe7,0x03,0x00,0x00,0x01,0x00, /* ..d...n......... */ \
	0x00,0x00,0x09,0x04,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..........~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71, /* ..<h1>D-STAR dSq */ \
	0x75,0x72,0x65,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* ure Status</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* ...<table style= */ \
	0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31, /* "padding-left: 1 */ \
	0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* 0px;">..<tr><td> */ \
	0x3c,0x62,0x3e,0x44,0x61,0x74,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* <b>Date :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f, /* ><td>~CurDate~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* d><b>Time :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e, /* td><td>~CurTime~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* <td><b>PTT :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x50,0x54,0x54,0x7e, /* /td><td>~CurPTT~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x4f,0x53,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* <td><b>COS :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e, /* /td><td>~CurCOS~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72, /* <td><b>Node User */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43, /* nbsp;</td><td>~C */ \
	0x75,0x72,0x55,0x73,0x65,0x72,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* urUser~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53, /* >..<tr><td><b>SS */ \
	0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* N :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x43,0x75,0x72,0x53,0x53,0x4e,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* CurSSN~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >..</table>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a, /* /div>..</body>.. */ \
	0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76, /* <meta http-equiv */ \
	0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65, /* ="refresh" conte */ \
	0x6e,0x74,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e, /* nt="10">..<body> */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22  /* text/javascript" */
#define DATACHUNK000006 \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* er.inc~......3.. */ \
	0x00,0x9b,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0xdd,0x00,0x00,0x00,0x64,0x00,0x00, /* .....c.......d.. */ \
	0x00,0x1e,0x01,0x00,0x00,0x66,0x00,0x00,0x00,0x5e,0x01,0x00,0x00,0x67,0x00,0x00, /* .....f...^...g.. */ \
	0x00,0xa4,0x01,0x00,0x00,0x69,0x00,0x00,0x00,0xe5,0x01,0x00,0x00,0x68,0x00,0x00, /* .....i.......h.. */ \
	0x00,0x9d,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x02,0x00,0x00, /* ................ */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64, /* ent">....<h1>Nod */ \
	0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* e Adapter Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* uration</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* st" action="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e, /* eadapter/config. */ \
	0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63, /* htm" name="nodec */ \
	0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* fg">..<fieldset> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58, /* ..<div><label>TX */ \
	0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /*  Delay Time:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* e="text" name="d */ \
	0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c, /* ely" value="~del */ \
	0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ay_time~" size=" */ \
	0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f, /* 4" class="ad1" / */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69, /* >&nbsp;mSec.</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61, /* TX Time out:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74, /* e="text" name="t */ \
	0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d, /* out" value="~tim */ \
	0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* e_out~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* bsp;Sec.</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b, /* <div><label>RX K */ \
	0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* eep Alive:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65, /* "text" name="kee */ \
	0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f, /* p" value="~keep_ */ \
	0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* alive~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* bsp;mSec.</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74, /* .<div><label>Jit */ \
	0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a, /* ter Buffer size: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="jitt" value=" */ \
	0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20, /* ~jittter_size~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="3" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e, /* ad1"/>&nbsp;0: n */ \
	0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ot effect</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20, /* .<div><label>RX  */ \
	0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f, /* Auto Polarity:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="rxpl" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61, /* ="" ~RX_AutoPola */ \
	0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* rity~ class="ad1 */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* "/></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69, /* <label>RX Polari */ \
	0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e  /* ty:</label>..<in */
#define DATACHUNK000007 \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20, /* ox" name="rxpo"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c, /* value="" ~RX_Pol */ \
	0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* arity~  class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* d1"/></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61, /* v><label>TX Pola */ \
	0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* rity:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* txpo" value="" ~ */ \
	0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61, /* TX_Polarity~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ss="ad1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43, /* >..<div><label>C */ \
	0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* OS Check:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="cos" value=" */ \
	0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c, /* " ~COS_Check~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ass="ad1" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75, /* S/N Squelch Valu */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* e:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c, /* t" name="sn" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e, /* ue="~SN_Squelch~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="5" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a, /* ="ad1"/>&nbsp;0: */ \
	0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76, /*  not effect</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43, /* >..<div><label>C */ \
	0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* RC Check:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="crc" value=" */ \
	0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c, /* " ~CRC_Check~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ass="ad1"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c, /* >..<div><label>L */ \
	0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c, /* ast Frame Send:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20, /* ox" name="last"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72, /* value="" ~LastFr */ \
	0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ame~ class="ad1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65, /* <label>Header Ge */ \
	0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* neration:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="hdrg" value= */ \
	0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63, /* "" ~HeaderGen~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* lass="ad1" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70, /* >Header Gen. Typ */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* e:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72, /* ckbox" name="hdr */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61, /* t" value="" ~Hea */ \
	0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61, /* derGenType~  cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ss="ad1"/>&nbsp; */ \
	0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f, /* Checked: Space</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70, /* div>..<div>&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e  /* ;&nbsp;.&nbsp;&n */
#define DATACHUNK000008 \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65, /* bsp;&nbsp;.Unche */ \
	0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65, /* cked: Last RF He */ \
	0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* ader</div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c, /* ><label>Half/Ful */ \
	0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* l Duplex:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="h_f" value=" */ \
	0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c, /* " ~HalfFull~  cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70, /* ass="ad1"/>&nbsp */ \
	0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48, /* ;Checked:&nbsp;H */ \
	0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* alf</div>..<div> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62, /* &nbsp;&nbsp;.&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a, /* sp;&nbsp;&nbsp;. */ \
	0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20, /* Unchecked: Full  */ \
	0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* Duplex</div>.... */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ..<div><input ty */ \
	0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73, /* pe="submit" clas */ \
	0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53, /* s="ap1" value="S */ \
	0x61,0x76,0x65,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22, /* ave Basic Info." */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65, /*  /></div>..</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* ldset>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* .</div>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0xeb,0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00, /* .....Q...k...R.. */ \
	0x00,0xe9,0x01,0x00,0x00,0x53,0x00,0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00, /* .....S...o...T.. */ \
	0x00,0x03,0x03,0x00,0x00,0x55,0x00,0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00, /* .....U...x...^.. */ \
	0x00,0xee,0x03,0x00,0x00,0x56,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00, /* .....V...a...W.. */ \
	0x00,0xd3,0x04,0x00,0x00,0x58,0x00,0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00, /* .....X...a...Y.. */ \
	0x00,0xd8,0x05,0x00,0x00,0x5a,0x00,0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00, /* .....Z...R...[.. */ \
	0x00,0xcb,0x06,0x00,0x00,0x5c,0x00,0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00, /* .....\.......].. */ \
	0x00,0xe8,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .........~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e,0x66, /* .<h1>Beacon Conf */ \
	0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* iguration</h1>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e, /* post" action="/n */ \
	0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69, /* odeadapter/confi */ \
	0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65, /* g2.htm" name="be */ \
	0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* acon">..<fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* t>..<div><label> */ \
	0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x3a,0x3c, /* Beacon Message:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x62,0x65,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="beac" value="~ */ \
	0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* BeaconM~" size=" */ \
	0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x2f,0x3e, /* 20" class="sm"/> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65,0x72,0x76,0x61,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* bel>Inerval:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69, /* e="text" name="i */ \
	0x6e,0x74,0x76,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61, /* ntv" value="~Bea */ \
	0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* conIntv~" size=" */ \
	0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* 3" class="ad1"/> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* &nbsp;Sec.</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* ....<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ass="ap1" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66, /* "Save Beacon Inf */ \
	0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f  /* o." /></div>..</ */
#define DATACHUNK000009 \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* fieldset>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63, /* m>..</div>..~inc */ \
	0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00, /* :footer.inc~.... */ \
	0x33,0x00,0x00,0x00,0xe6,0x00,0x00,0x00,0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00, /* 3.......q...S... */ \
	0x72,0x00,0x00,0x00,0xf3,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* r...........~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65, /* ....<h1>TX Heade */ \
	0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* r Replace Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* uration</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* st" action="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33, /* eadapter/config3 */ \
	0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x65,0x61,0x64, /* .htm" name="head */ \
	0x65,0x72,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73, /* ercfg">..<fields */ \
	0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* et>..<div><label */ \
	0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61, /* >TX Header Repla */ \
	0x63,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ce:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x68,0x72,0x22,0x20, /* ox" name="txhr"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72, /* value="" ~Header */ \
	0x52,0x65,0x70,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* Rep~ class="ad1" */ \
	0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67, /*  onclick="config */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* Header()"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* >..<br>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c, /* abel>Alter MyCal */ \
	0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* l:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="myc" value= */ \
	0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73, /* "~alt_mycall~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="8" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* d1"/>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="amyc" value= */ \
	0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c, /* "" ~a_mycall~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f, /* ass="ad3" />..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x32,0x3a, /* l>Alter MyCall2: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6d,0x79,0x63,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="myc2" value=" */ \
	0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x22,0x20,0x73, /* ~alt_mycall2~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="4" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* d1"/>&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c, /* ;&nbsp;&nbsp;..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x32, /* kbox" name="amy2 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79, /* " value="" ~a_my */ \
	0x63,0x61,0x6c,0x6c,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* call2~ class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* 3" />..</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72, /* div><label>Alter */ \
	0x20,0x59,0x6f,0x75,0x72,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /*  YourCall:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x79,0x72,0x63, /* "text" name="yrc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x79,0x6f, /* " value="~alt_yo */ \
	0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38, /* urcall~" size="8 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d, /* " class="ad1"/>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x79, /* eckbox" name="ay */ \
	0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f, /* rc" value="" ~a_ */ \
	0x79,0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* yourcall~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* "ad3" />..</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c, /* ..<div><label>Al */ \
	0x74,0x65,0x72,0x20,0x52,0x50,0x54,0x31,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f  /* ter RPT1 Call:</ */
#define DATACHUNK00000a \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x72,0x70,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61, /* "rpt1" value="~a */ \
	0x6c,0x74,0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69, /* lt_rpt1call~" si */ \
	0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="8" class="ad */ \
	0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* 1"/>..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x61,0x72,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="art1" value=" */ \
	0x22,0x20,0x7e,0x61,0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63, /* " ~a_rpt1call~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x52,0x50,0x54,0x32,0x20,0x43,0x61, /* el>Alter RPT2 Ca */ \
	0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ll:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x70,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="rpt2" valu */ \
	0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c, /* e="~alt_rpt2call */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="8" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* s="ad1"/>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x72,0x74,0x32,0x22,0x20,0x76,0x61, /* " name="art2" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x72,0x70,0x74,0x32,0x63,0x61, /* lue="" ~a_rpt2ca */ \
	0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20, /* ll~ class="ad3"  */ \
	0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* />..</div>....<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x2e,0x20,0x54, /* iv><label>Alt. T */ \
	0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x46,0x6c,0x61,0x67,0x73,0x3a,0x3c, /* X Header Flags:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x37,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="flg7" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x37,0x7e,0x20,0x63,0x6c,0x61, /* e="" ~flag7~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ss="ad1" disable */ \
	0x64,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* d/>..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x66,0x6c,0x67,0x36,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="flg6" value="" */ \
	0x20,0x7e,0x66,0x6c,0x61,0x67,0x36,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /*  ~flag6~ class=" */ \
	0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* ad3" />..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x35,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="flg5" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x35,0x7e,0x20,0x63,0x6c,0x61, /* e="" ~flag5~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ss="ad3" />..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x34,0x22,0x20, /* ox" name="flg4"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x34,0x7e, /* value="" ~flag4~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d, /*  class="ad3" />. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c, /* eckbox" name="fl */ \
	0x67,0x33,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c, /* g3" value="" ~fl */ \
	0x61,0x67,0x33,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22, /* ag3~ class="ad3" */ \
	0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /*  />..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x66,0x6c,0x67,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22, /* ="flg2" value="" */ \
	0x20,0x7e,0x66,0x6c,0x61,0x67,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /*  ~flag2~ class=" */ \
	0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* ad3" />..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x31,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="flg1" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x31,0x7e,0x20,0x63,0x6c,0x61, /* e="" ~flag1~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ss="ad3" />..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x30,0x22,0x20, /* ox" name="flg0"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x30,0x7e, /* value="" ~flag0~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x26, /*  class="ad3" />& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e, /* nbsp;&nbsp;..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x66,0x6c,0x67,0x22,0x20, /* ox" name="aflg"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x41,0x66,0x6c,0x61,0x67,0x7e  /* value="" ~Aflag~ */
#define DATACHUNK00000b \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d, /*  class="ad3" />. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c, /* .</div>........< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* "submit" class=" */ \
	0x61,0x70,0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x73,0x22, /* ap1" name="hdrs" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x48,0x65,0x61, /*  value="Save Hea */ \
	0x64,0x65,0x72,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* der Info." /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* iv>..</fieldset> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ..</form>..</div */ \
	0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75, /* >..<script langu */ \
	0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* age="javascript" */ \
	0x3e,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66, /* >..function conf */ \
	0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65, /* igHeader() {...e */ \
	0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d, /*  = document.form */ \
	0x73,0x2e,0x68,0x65,0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x3b,0x0d,0x0a,0x09,0x73, /* s.headercfg;...s */ \
	0x74,0x20,0x3d,0x20,0x21,0x28,0x65,0x2e,0x74,0x78,0x68,0x72,0x2e,0x63,0x68,0x65, /* t = !(e.txhr.che */ \
	0x63,0x6b,0x65,0x64,0x29,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x2e,0x64, /* cked);...e.myc.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x6d,0x79,0x63,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.myc2.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x79,0x72,0x63,0x2e,0x64,0x69, /* = st;...e.yrc.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x72,0x70,0x74,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .rpt1.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x72,0x70,0x74,0x32,0x2e,0x64,0x69, /*  st;...e.rpt2.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x66,0x6c,0x67,0x36,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .flg6.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x35,0x2e,0x64,0x69, /*  st;...e.flg5.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x66,0x6c,0x67,0x34,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .flg4.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x33,0x2e,0x64,0x69, /*  st;...e.flg3.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x66,0x6c,0x67,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .flg2.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x31,0x2e,0x64,0x69, /*  st;...e.flg1.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x66,0x6c,0x67,0x30,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .flg0.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x66,0x6c,0x67,0x2e,0x64,0x69, /*  st;...e.aflg.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x61,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .amyc.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x6d,0x79,0x32,0x2e,0x64,0x69, /*  st;...e.amy2.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x61,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .ayrc.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x72,0x74,0x31,0x2e,0x64,0x69, /*  st;...e.art1.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x61,0x72,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .art2.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69, /*  st;..}....confi */ \
	0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f, /* gHeader();....</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* script>....~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0xfd,0x00,0x00,0x00,0x73,0x00,0x00,0x00,0x85,0x01,0x00,0x00,0x74, /* .......s.......t */ \
	0x00,0x00,0x00,0xd7,0x01,0x00,0x00,0x81,0x00,0x00,0x00,0x44,0x02,0x00,0x00,0x75, /* ...........D...u */ \
	0x00,0x00,0x00,0xaf,0x02,0x00,0x00,0x82,0x00,0x00,0x00,0x1d,0x03,0x00,0x00,0x76, /* ...............v */ \
	0x00,0x00,0x00,0x71,0x03,0x00,0x00,0x83,0x00,0x00,0x00,0xe2,0x03,0x00,0x00,0x77, /* ...q...........w */ \
	0x00,0x00,0x00,0x36,0x04,0x00,0x00,0x84,0x00,0x00,0x00,0xa7,0x04,0x00,0x00,0x78, /* ...6...........x */ \
	0x00,0x00,0x00,0xfb,0x04,0x00,0x00,0x85,0x00,0x00,0x00,0x79,0x05,0x00,0x00,0x79, /* ...........y...y */ \
	0x00,0x00,0x00,0xc5,0x05,0x00,0x00,0x7a,0x00,0x00,0x00,0x09,0x06,0x00,0x00,0x7b, /* .......z.......{ */ \
	0x00,0x00,0x00,0x4d,0x06,0x00,0x00,0x7c,0x00,0x00,0x00,0x91,0x06,0x00,0x00,0x7d, /* ...M...|.......} */ \
	0x00,0x00,0x00,0xd5,0x06,0x00,0x00,0x7e,0x00,0x00,0x00,0x19,0x07,0x00,0x00,0x7f, /* .......~........ */ \
	0x00,0x00,0x00,0x5d,0x07,0x00,0x00,0x80,0x00,0x00,0x00,0xad,0x07,0x00,0x00,0x88, /* ...]............ */ \
	0x00,0x00,0x00,0x8f,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ...........~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43, /* ...<h1>Network C */ \
	0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31, /* onfiguration</h1 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f, /* >....<form metho */ \
	0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d  /* d="post" action= */
#define DATACHUNK00000c \
	0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67, /* "/protect/config */ \
	0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66, /* .htm" name="conf */ \
	0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* ig">..<fieldset> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41, /* ..<div><label>MA */ \
	0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* C Address:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63, /* "text" name="mac */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* " value="~config */ \
	0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* _mac~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72, /* .<div><label>Ser */ \
	0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ver Name:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74, /* text" name="host */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72, /* " value="~server */ \
	0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* _name~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75, /* ..<div><label>Ou */ \
	0x74,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c, /* t Bound Port:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x6f,0x70,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75, /* oprt" value="~ou */ \
	0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* t_port~" class=" */ \
	0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c, /* ad1" size="5"/>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74, /* el>In Bound Port */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="iprt" value= */ \
	0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73, /* "~in_port~" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22, /* s="ad1" size="5" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* label>Room Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="RmNm" value=" */ \
	0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~RoomName~" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22, /* s="ad1" size="8" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c, /* <label>Node Call */ \
	0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* sign:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61, /* " name="NdNm" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22, /* lue="~NodeName~" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a, /*  class="ad1" siz */ \
	0x65,0x3d,0x22,0x38,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* e="8" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74, /* <div><label>Jitt */ \
	0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x3a,0x3c, /* er Buffer Wait:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="jitt" value="~ */ \
	0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a, /* JitterSize~" siz */ \
	0x65,0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="2" class="ad1 */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* "/></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65, /* <label>NTP Serve */ \
	0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26, /* r Name:</label>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e, /* nbsp;..<select n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ame="ntp">..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e, /* ion value="pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ntp.org">pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f, /* alue="europe.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70  /* l.ntp.org">europ */
#define DATACHUNK00000d \
	0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* e.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61, /* <option value="a */ \
	0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* sia.pool.ntp.org */ \
	0x22,0x3e,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* ">asia.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c, /* ue="oceania.pool */ \
	0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69, /* .ntp.org">oceani */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e, /* <option value="n */ \
	0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* orth-america.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68, /* l.ntp.org">north */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72, /* alue="south-amer */ \
	0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ica.pool.ntp.org */ \
	0x22,0x3e,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e, /* ">south-america. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72, /* ption value="afr */ \
	0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ica.pool.ntp.org */ \
	0x22,0x3e,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ">africa.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e, /* p.org..</select> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ..</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a, /* label>Time Zone: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="zone" value=" */ \
	0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~TimeZone~" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22, /* s="ad1" size="3" */ \
	0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62, /* />&nbsp;hours&nb */ \
	0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* sp;..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6e, /* ="text" name="zn */ \
	0x65,0x4d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65, /* eM" value="~Time */ \
	0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x22,0x20,0x63,0x6c, /* ZoneMinutes~" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ass="ad3" size=" */ \
	0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65, /* 2"/>&nbsp;minute */ \
	0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* s</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x52,0x46,0x20,0x52,0x65,0x70,0x65,0x74,0x65,0x72,0x20, /* abel>RF Repeter  */ \
	0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Connect:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x61,0x64,0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x70,0x74,0x22, /* ad1" name="rept" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x20,0x7e,0x72,0x65,0x70, /*  value="1"  ~rep */ \
	0x65,0x61,0x74,0x65,0x72,0x5f,0x6f,0x6e,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* eater_on~ /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46, /* Access Control F */ \
	0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ile Name:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x74,0x6c, /* text" name="actl */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x41,0x63,0x63,0x43,0x74,0x72, /* " value="~AccCtr */ \
	0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* l~" /></div>..<d */ \
	0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* iv>&nbsp;&nbsp;< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69, /* /div>..<div>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20, /* box" class="sm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="dhcp" valu */ \
	0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63, /* e="1" onclick="c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20, /* onfigIPBoxes()"  */ \
	0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63, /* ~config_dhcpchec */ \
	0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44, /* ked~ /> Enable D */ \
	0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* HCP</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73, /* <label>IP Addres */ \
	0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* s:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c  /* t" name="ip" val */
#define DATACHUNK00000e \
	0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22, /* ue="~config_ip~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c, /* <label>Gateway:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* name="gw" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e, /* "~config_gw~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a, /* bel>Subnet Mask: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="sub" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65, /* e="~config_subne */ \
	0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* t~" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72, /* iv><label>Primar */ \
	0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* y DNS:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73, /* "text" name="dns */ \
	0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69, /* 1" value="~confi */ \
	0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* g_dns1~" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53, /* >..<div><label>S */ \
	0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c, /* econdary DNS:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f, /* dns2" value="~co */ \
	0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* nfig_dns2~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* div>..<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* class="sm" value */ \
	0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f, /* ="Save Config" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64, /* ></div>..</field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c, /* set>..</form>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73, /*  language="javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66, /* cript">..<!--..f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50, /* unction configIP */ \
	0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20, /* Boxes() {...e =  */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63, /* document.forms.c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e, /* onfig;...st = e. */ \
	0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09, /* dhcp.checked;... */ \
	0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* e.ip.disabled =  */ \
	0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62, /* st;...e.gw.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75, /* led = st;...e.su */ \
	0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b, /* b.disabled = st; */ \
	0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c, /* ...e.dns1.disabl */ \
	0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73, /* ed = st;...e.dns */ \
	0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b, /* 2.disabled = st; */ \
	0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f, /* ..}..document.fo */ \
	0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64, /* rms.config.mac.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d, /* isabled = true;. */ \
	0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73, /* ...configIPBoxes */ \
	0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* ();..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x25, /* nc~....3.......% */ \
	0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2,0x01,0x00,0x00,0x4b, /* ...>...J.......K */ \
	0x00,0x00,0x00,0x16,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x85,0x02,0x00,0x00,0x4d, /* .......L.......M */ \
	0x00,0x00,0x00,0xfa,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x74,0x03,0x00,0x00,0x6e, /* .......N...t...n */ \
	0x00,0x00,0x00,0x05,0x06,0x00,0x00,0x61,0x00,0x00,0x00,0x60,0x06,0x00,0x00,0x6d, /* .......a...`...m */ \
	0x00,0x00,0x00,0x01,0x07,0x00,0x00,0x87,0x00,0x00,0x00,0x6e,0x07,0x00,0x00,0x5f, /* ...........n..._ */ \
	0x00,0x00,0x00,0xf5,0x07,0x00,0x00,0x27,0x00,0x00,0x00,0x69,0x08,0x00,0x00,0x28  /* .......'...i...( */
#define DATACHUNK00000f \
	0x00,0x00,0x00,0xc6,0x08,0x00,0x00,0x29,0x00,0x00,0x00,0x28,0x09,0x00,0x00,0x2a, /* .......)...(.... */ \
	0x00,0x00,0x00,0x8f,0x09,0x00,0x00,0x2b,0x00,0x00,0x00,0xf2,0x09,0x00,0x00,0x2c, /* .......+......., */ \
	0x00,0x00,0x00,0xc8,0x0b,0x00,0x00,0x01,0x00,0x00,0x00,0xe8,0x0b,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c, /* ntent">....<h1>L */ \
	0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c, /* ogin Successful< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68, /* /h1>....<p>You h */ \
	0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79, /* ave successfully */ \
	0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68, /*  logged in to th */ \
	0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54, /* e web server.  T */ \
	0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69, /* his authenticati */ \
	0x6f,0x6e,0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e, /* on ..is valid un */ \
	0x74,0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f, /* til you close yo */ \
	0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* ur browser.</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c, /* ...<p>Credential */ \
	0x73,0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69, /* s are verified i */ \
	0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f, /* n your own custo */ \
	0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74, /* m callback funct */ \
	0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f, /* ion called ..<co */ \
	0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63, /* de>HTTPAuthentic */ \
	0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20, /* ate</code>.  In  */ \
	0x68,0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65, /* here, you can de */ \
	0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73, /* termine if the s */ \
	0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61, /* upplied..user na */ \
	0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* me and password  */ \
	0x61,0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63, /* are valid for ac */ \
	0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75, /* cess to the requ */ \
	0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75, /* ested page.  You */ \
	0x20,0x63,0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69, /*  can ..add multi */ \
	0x70,0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65, /* ple users and re */ \
	0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74, /* strict different */ \
	0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72, /*  users to differ */ \
	0x65,0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* ent pages.</p>.. */ \
	0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72, /* ..<p class="exer */ \
	0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73, /* cise"><b>Exercis */ \
	0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68, /* e:</b> Change th */ \
	0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20, /* e user name and  */ \
	0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f, /* password in..<co */ \
	0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63, /* de>HTTPAuthentic */ \
	0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e, /* ate</code> to on */ \
	0x65,0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69, /* e of your choosi */ \
	0x6e,0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61, /* ng.  (The callba */ \
	0x63,0x6b,0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20, /* ck is ..located  */ \
	0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48, /* in <code>CustomH */ \
	0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e, /* TTPApp.c</code>. */ \
	0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* )</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22, /* ass="examplebox" */ \
	0x3e,0x0d,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69, /* >..When you fini */ \
	0x73,0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73, /* sh, refresh this */ \
	0x20,0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f, /*  page to test yo */ \
	0x75,0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65, /* ur new user name */ \
	0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a, /*  and password .. */ \
	0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f, /* combination...</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* div>....</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* ript>....~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00  /* oter.inc~....3.. */
#define DATACHUNK000010 \
	0x00,0x94,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00, /* ................ */ \
	0x00,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00, /* .~reboot~....-.. */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62, /* ent">....<h1>Reb */ \
	0x6f,0x6f,0x74,0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e, /* oot In Progress. */ \
	0x2e,0x2e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f, /* ..</h1>....<p>Yo */ \
	0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65, /* ur settings were */ \
	0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61, /*  successfully sa */ \
	0x76,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61, /* ved, and the boa */ \
	0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74, /* rd is now reboot */ \
	0x69,0x6e,0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75, /* ing ..to configu */ \
	0x72,0x65,0x20,0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74, /* re itself with t */ \
	0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e, /* he new settings. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e, /* </p>....<p align */ \
	0x3d,0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75, /* ="center"><b>You */ \
	0x72,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c, /* r board is now l */ \
	0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20, /* ocated at: ..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65, /* href="http://~re */ \
	0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70, /* bootaddr~/">http */ \
	0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f, /* ://~rebootaddr~/ */ \
	0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* </a></b></p>.... */ \
	0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64, /* <h6></h6>....</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c, /* iv>....<script l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* anguage="javascr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e, /* ipt">..<!--..fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d, /* ction rebootDumm */ \
	0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f, /* y(x){}..setTimeo */ \
	0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61, /* ut("newAJAXComma */ \
	0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62, /* nd('/protect/reb */ \
	0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44, /* oot.cgi',rebootD */ \
	0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30, /* ummy,false);",50 */ \
	0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* 0);..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c, /* er.inc~....3.... */ \
	0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0xf6, /* ......."........ */ \
	0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50, /* h1>User ID and P */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c, /* assword Setting< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65, /* /h1>....<form me */ \
	0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69, /* thod="post" acti */ \
	0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65, /* on="/protect/use */ \
	0x72,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65, /* r.htm" name="use */ \
	0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* r">..<fieldset>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65, /* .<div><label>Use */ \
	0x72,0x20,0x49,0x44,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* r ID:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61, /* " name="user" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20, /* lue="~user_id~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c, /* label>Password:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20, /* type="password"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="pwd" value */ \
	0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f, /* ="~user_pass~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f, /* abel>Password:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e, /* ype="password" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x43,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="pwdC" value */ \
	0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x43,0x7e,0x22,0x20, /* ="~user_passC~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c  /* /></div>..<div>< */
#define DATACHUNK000011 \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74, /* input type="butt */ \
	0x6f,0x6e,0x22,0x20,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x70,0x61, /* on"  onClick="pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20,0x63, /* sswordCheck()" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x62,0x22,0x20,0x76,0x61,0x6c,0x75, /* lass="ad1b" valu */ \
	0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73, /* e="Save ID & Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* sword"/></div>.. */ \
	0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* </fieldset>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* orm>..</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f, /* .<!--..//-->..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69, /* tById('hello').i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c, /* nnerHTML = "~hel */ \
	0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69, /* lomsg~";..functi */ \
	0x6f,0x6e,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b, /* on passwordCheck */ \
	0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75, /* ()..{...if (docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x2e,0x76,0x61, /* ment.user.pwd.va */ \
	0x6c,0x75,0x65,0x20,0x21,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* lue != document. */ \
	0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x43,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29, /* user.pwdC.value) */ \
	0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x09,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22, /* ...{....alert (" */ \
	0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x6d,0x69,0x73,0x73,0x6d,0x61,0x74, /* Password missmat */ \
	0x63,0x68,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72,0x6e, /* ch!");....return */ \
	0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ;...}...document */ \
	0x2e,0x75,0x73,0x65,0x72,0x2e,0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d, /* .user.submit();. */ \
	0x0a,0x0d,0x0a,0x7d,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* ...}..</script>. */ \
	0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* ...~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x6a, /* nc~....3.......j */ \
	0x00,0x00,0x00,0x3b,0x01,0x00,0x00,0x6b,0x00,0x00,0x00,0x9b,0x01,0x00,0x00,0x6c, /* ...;...k.......l */ \
	0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0x5c,0x03,0x00,0x00,0x02, /* ...........\.... */ \
	0x00,0x00,0x00                                                                   /* ...              */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
