#include "stdafx.h"
#include "StaticData.h"

#include "HPLNetLibConsts.h"
#include "Enum.h"

using namespace Enum;
using namespace System::Windows;
using namespace System::Windows::Forms;
using namespace System::IO;


void StaticData::setup() {
}


void StaticData::load( String^ strBaseFolderPath ) {
	strBaseFolderPath += _T("/");
	// encoding
	String^ ENCODING = gcnew String( HPLNetLibConsts::ENCODING_SHIFT_JIS );

	// load general for tile size
	List<String^>^ aryResult = gcnew List<String^>();
	String^ strGeneralPath = strBaseFolderPath + gcnew String( _T("data/General.txt" ));
	HPLNetLibTool::loadLinesFromFile( aryResult, strGeneralPath, ENCODING, true );
	for each( String^ str in aryResult ) {
		cli::array<String^>^ aryItems = str->Split(_T('='));
		if( aryItems[0]->Equals(_T("TILE_SIZE"))) {
			try {
				this->m_nTileSize = Convert::ToInt32( aryItems[1] );
			} catch( Exception^ e ) {
				MessageBox::Show( e->Message );
				throw;
			}
			break;
		}
	}

	// tile image
	String ^strSpriteListPath = strBaseFolderPath + gcnew String( _T("data/image/ImageSetFileList.dat") );
	aryResult = gcnew List<String^>();
	HPLNetLibTool::loadLinesFromFile( aryResult, strSpriteListPath, ENCODING, true );
	// ŏ̗Lȍs=Common擾ďI
	List<String^>^ arySequences = gcnew List<String^>();
	String^ strCommonSpritePath = aryResult[0];
	int nSeqIndex = strCommonSpritePath->IndexOf(_T(";") );
	if( nSeqIndex >= 0  ) {
		strCommonSpritePath = strCommonSpritePath->Substring( 0, nSeqIndex );
	}
	if( strCommonSpritePath->StartsWith( _T("*")) ){
		strCommonSpritePath = strCommonSpritePath->Substring(1);
	}
	HPLNetLibTool::loadLinesFromFile( arySequences,strBaseFolderPath +strCommonSpritePath , ENCODING, true );
	// ŏ̗Lȍs=Tile擾ă[h
	List<String^>^ arySequenceItemList = gcnew List<String^>();
	HPLNetLibTool::loadLinesFromFile( arySequenceItemList, strBaseFolderPath + arySequences[0], ENCODING, true );
	String^ strPath = gcnew String(_T(""));
	String^ strExt = gcnew String(_T("png"));
	for each( String^ str in arySequenceItemList ) {
		cli::array<String^>^ ary = str->Split(_T('='));
		if( ary[0]->Equals(_T("BASE"))){
			strPath = ary[1];
		} else if( ary[0]->Equals( _T("EXT"))){
			strExt = ary[1];
		}
	}
	strPath = strPath + _T("1.") + strExt;
	this->m_imgTile = Image::FromFile( strBaseFolderPath + strPath );
	this->m_nColumnPerRow = this->m_imgTile->Width / this->m_nTileSize;

	// load palette image
	String^ strPaletteImagePath = gcnew String(_T("data/image/Common/Palette/TileType.png"));
	this->m_imgPalette = Image::FromFile( strPaletteImagePath );

	// load select frame image
	String^ strSelectFrameImagePath = gcnew String(_T("data/image/Common/MainFrame/SelectFrame1.png"));
	this->m_imgSelectFrame = Image::FromFile( strSelectFrameImagePath );

	// block data
	String^ strBlockPath = strBaseFolderPath + gcnew String( _T("data/maps/Block000.txt"));
	aryResult = gcnew List<String^>();
	HPLNetLibTool::loadLinesFromFile( aryResult, strBlockPath,
		ENCODING, true );
	int nMode = -1;	// -1 is general mode
	

	List<List<int>^>^ vecIDs = gcnew List<List<int>^>();
	for( int i = 0; i < TileType::MAX_NUM; i ++ ) {
		vecIDs->Add( gcnew List<int>() );
	}

	for each ( String^ str in aryResult ) {
		cli::array<String^>^ aryItems = str->Split(_T('='));
		for( int i = 0; i < TileType::MAX_NUM; i ++ ) {
			if( str->Equals( gcnew String(TILE_TYPE_LABELS[i]) ) ) {
				nMode = i;
				break;
			}
		}

		if( aryItems[0]->Equals( gcnew String(CMD_NUMBER_OF_BLOCKS_PER_LINE))) {
			this->m_nColumnPerRow = Convert::ToInt32( aryItems[1] );
		} else if( aryItems[0]->Equals(gcnew String(CMD_ID))){
			if( nMode < 0 ) {
				throw;
			}
			cli::array<String^>^ aryIDs = aryItems[1]->Split(_T(','));
			for each( String^ strID in aryIDs ) {
				vecIDs[nMode]->Add( Convert::ToInt32(strID->Trim() ) );
			}
		} else {
		}
	}
	// calculate size
	this->m_matIDs = gcnew HPLNetMatrix( this->m_nColumnPerRow, this->m_imgTile->Height / this->m_nTileSize );
	this->m_matIDs->fill(TileType::BLOCK);
	for( int nTileType = 0; nTileType < vecIDs->Count; nTileType ++ ) {
		for( int nIndex = 0; nIndex < vecIDs[nTileType]->Count; nIndex ++ ) {
			int nID = vecIDs[nTileType][nIndex];
			int nCol = nID % this->m_nColumnPerRow;
			int nRow = nID / this->m_nColumnPerRow;
			this->m_matIDs->set(nCol, nRow, nTileType );
		}
	}
}

int StaticData::getIDFromColRow( int nCol, int nRow) {
	return nCol + nRow * this->m_nColumnPerRow;
}

void StaticData::getColRowFromID( int nID, int& nCol, int& nRow ) {
	nCol = nID % this->m_nColumnPerRow;
	nRow = nID / this->m_nColumnPerRow;
}
/*
int StaticData::getBlockTypeByBlockID(int nID) {
	// col/rowɕϊ
	int nCol = 0,nRow = 0;
	this->getColRowFromID( nID, nCol, nRow );
	return this->m_matIDs->get(nCol,nRow);
}*/
/** w肵^C^CvɎw肵ubNIDǉ
  *
int StaticData::addBlockIDToBlockType( int nTileType, int nID ) {
	if( this->m_vecIDList[nTileType]->Contains( nID ) ){
		return 1;
	}
	this->m_vecIDList[nTileType]->Add( nID );
	return 0;
}*/

void StaticData::save( String^ strPath ) {
	String^ ENCODING = gcnew String( HPLNetLibConsts::ENCODING_SHIFT_JIS );
	IO::StreamWriter^ sw = gcnew IO::StreamWriter(strPath, false,
		System::Text::Encoding::GetEncoding(ENCODING));
	
	sw->WriteLine(_T("[GENERAL]"));

	sw->WriteLine(String::Format(_T("{0}={1}"),gcnew String(CMD_NUMBER_OF_BLOCKS_PER_LINE),
		Convert::ToString(this->m_nColumnPerRow)));

	sw->WriteLine(_T("LEFT_TOP_MERGIN=0,0"));
	sw->WriteLine(_T("INTERVAL_MERGIN=0,0"));

	sw->WriteLine();
	// vecXgɕϊ
	List<List<int>^>^ vecIDs = gcnew List<List<int>^>();
	for( int i = 0; i < TileType::MAX_NUM; i ++ ) {
		vecIDs->Add( gcnew List<int>());
	}
	for( int nRow = 0; nRow < this->m_matIDs->getRowNum(); nRow ++ ) {
		for( int nCol = 0; nCol < this->m_matIDs->getColumnNum(); nCol ++ ) {
			int nBlockType = this->m_matIDs->get( nCol,nRow);
			int nID = this->getIDFromColRow( nCol,nRow);
			vecIDs[nBlockType]->Add( nID );
		}
	}
	for( int i = 0; i < TileType::MAX_NUM; i ++ ) {
		sw->WriteLine(gcnew String(TILE_TYPE_LABELS[i]));
		if( vecIDs[i]->Count > 0 ) {
			// ID܂܂iꍇIDꗗo͂Ȃj
			sw->Write(String::Format(_T("{0}="),gcnew String(CMD_ID)));
			for( int nIndex = 0; nIndex < vecIDs[i]->Count; nIndex ++ ) {
				sw->Write(String::Format(_T("{0}"),
					Convert::ToString(vecIDs[i][nIndex])));
				if( nIndex < vecIDs[i]->Count - 1 ) {
					sw->Write(_T(","));
				}
			}
			sw->WriteLine();
		}
		sw->WriteLine();
	}
	sw->Close();
}


