#pragma once

#include "MessageWindow.h"
#include "StaticData.h"
#include "hpllib/Object/HPLState.h"
#include "Palette.h"
#include "Enum.h"

using namespace Enum;

namespace Evicot {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	/// <summary>
	/// Form1 ̊Tv
	///
	/// x: ̃NX̖OύXꍇÃNXˑ邷ׂĂ .resx t@CɊ֘Atꂽ
	///          }l[W \[X RpC c[ɑ΂ 'Resource File Name' vpeB
	///          ύXKv܂B̕ύXsȂƁA
	///          fUCiƁÃtH[Ɋ֘Atꂽ[JCYς݃\[XƂA
	///          ݂ɗpłȂȂ܂B
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		void setShowMessageWindow(bool bIsShow) {
			if(bIsShow) {
				this->m_MessageWindow->Show();
			} else {
				this->m_MessageWindow->Hide();
			}
			this->messageWindowToolStripMenuItem->Checked = bIsShow;
		}
		void setShowPalette(bool bIsShow) {
			if(bIsShow) {
				this->m_Palette->Show();
			} else {
				this->m_Palette->Hide();
			}
			this->toolPaletteToolStripMenuItem->Checked = bIsShow;
		}
		void moveMessageWindowInitialPosition( ) {
			this->m_MessageWindow->Left = this->Left;
			this->m_MessageWindow->Top = this->Bottom;
		}
		void movePaletteInitialPosition() {
			
			this->m_Palette->Left = this->Left + this->Width;
			this->m_Palette->Top = this->Top;
		}
		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//
			// message window
			this->m_MessageWindow = gcnew MessageWindow();
			this->AddOwnedForm( this->m_MessageWindow );
			this->setShowMessageWindow( true );
			

			this->m_Palette = gcnew Palette();
			this->AddOwnedForm( this->m_Palette );
			this->setShowPalette( true );

			StaticData::staticData = gcnew StaticData();
			StaticData::staticData->setup();
			StaticData::staticData->m_MainForm = this;

			StaticData::staticData->m_MessageWindow = this->m_MessageWindow;
			this->moveMessageWindowInitialPosition();
			this->movePaletteInitialPosition();

			this->m_MessageWindow->addMessage(
				StaticData::staticData->m_mapMessageSets[0]);

			this->m_MessageWindow->addMessage(
				StaticData::staticData->m_mapMessageSets[1]);
			StaticData::staticData->loadSprites();
			this->m_MessageWindow->addMessage(
				StaticData::staticData->m_mapMessageSets[2]);
			this->m_nSpriteID = 0;
			this->m_nSequenceID = 0;

			Color col = Color::White;
			this->BackColor = col;
			this->TransparencyKey = col;

			const int MILLISECONDS_PER_SECOND = 1000;
			const int FPS = 32;
			this->timer1->Interval = MILLISECONDS_PER_SECOND / FPS;

			this->timer1->Enabled = true;

			this->m_nStateType = StateType::STAND;
			this->changeState( StateType::STAND );

			this->m_nLocalX = 0;
			this->m_nLocalY = 0;
		}


	public:
		//HPLState m_State;
		void changeState( int nState ) {
			bool bIsNewState = m_nStateType != nState;
			if( bIsNewState ) {
				// ݂̃Xe[gɑΉSeqID
				HPLNetSequence^ seq = StaticData::staticData->m_SpriteContainer->getSequence(
					this->m_nSpriteID, this->getSequenceIDFromState(m_nStateType ) );
				seq->reset();
			}
			this->m_nStateType = nState;
			//this->m_State.setState( nState );

			if( bIsNewState ) {
				HPLNetSequence^ seq = StaticData::staticData->m_SpriteContainer->getSequence(
					this->m_nSpriteID, this->getSequenceIDFromState(m_nStateType ) );
				seq->reset();
			}
			
		}
		int m_nStateType;	//! \L̃Xe[g
		MessageWindow^ m_MessageWindow;
		Palette^ m_Palette;
		int m_nSpriteID;
		int m_nLocalX;	//! 񂾍WiEBhEW
		int m_nLocalY;
	private: System::Windows::Forms::Timer^  timer1;
	private: System::Windows::Forms::ContextMenuStrip^  contextMenuStrip1;
	private: System::Windows::Forms::ToolStripMenuItem^  systemToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  exitToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  showToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  messageWindowToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  toolPaletteToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  settingToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  topMostToolStripMenuItem1;


	protected: 
		int m_nSequenceID;
		int getSequenceIDFromState( int nState ) {
			int nID = 0;
			switch( nState ) {
			case StateType::DAMAGE:
				nID = Sequence::Player::DAMAGE;
				switch( StaticData::staticData->getWearType() ) {
				case WearType::NAKED:
					nID = Sequence::Player::DAMAGE_NAKED;
					break;
				}
				break;
			case StateType::HOLD:
				nID = Sequence::Player::ROPER;
				break;
			case StateType::HOLD_AIR:
				nID = Sequence::Player::ROPER_2;
				break;
			case StateType::DAMAGE_FLAME:
				nID = Sequence::Player::DAMAGE_FIRE;
				break;
			case StateType::DAMAGE_ELEC:
				nID = Sequence::Player::DAMAGE_ELEC;
				break;
			case StateType::BIND:
				nID = Sequence::Player::BIND;
				break;
			default:
				switch( StaticData::staticData->getWearType() ) {
				case WearType::NAKED:
					nID = Sequence::Player::STAND_NAKED;
					break;
				}
			}
			return nID;
		}
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::ComponentModel::IContainer^  components;
	protected: 

	private:
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>


#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = (gcnew System::ComponentModel::Container());
			this->timer1 = (gcnew System::Windows::Forms::Timer(this->components));
			this->contextMenuStrip1 = (gcnew System::Windows::Forms::ContextMenuStrip(this->components));
			this->systemToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->exitToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->showToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->messageWindowToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->toolPaletteToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->settingToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->topMostToolStripMenuItem1 = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->contextMenuStrip1->SuspendLayout();
			this->SuspendLayout();
			// 
			// timer1
			// 
			this->timer1->Tick += gcnew System::EventHandler(this, &Form1::timer1_Tick);
			// 
			// contextMenuStrip1
			// 
			this->contextMenuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(3) {this->systemToolStripMenuItem, 
				this->showToolStripMenuItem, this->settingToolStripMenuItem});
			this->contextMenuStrip1->Name = L"contextMenuStrip1";
			this->contextMenuStrip1->Size = System::Drawing::Size(122, 70);
			// 
			// systemToolStripMenuItem
			// 
			this->systemToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->exitToolStripMenuItem});
			this->systemToolStripMenuItem->Name = L"systemToolStripMenuItem";
			this->systemToolStripMenuItem->Size = System::Drawing::Size(121, 22);
			this->systemToolStripMenuItem->Text = L"System";
			// 
			// exitToolStripMenuItem
			// 
			this->exitToolStripMenuItem->Name = L"exitToolStripMenuItem";
			this->exitToolStripMenuItem->Size = System::Drawing::Size(98, 22);
			this->exitToolStripMenuItem->Text = L"Exit";
			this->exitToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::exitToolStripMenuItem_Click);
			// 
			// showToolStripMenuItem
			// 
			this->showToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(2) {this->messageWindowToolStripMenuItem, 
				this->toolPaletteToolStripMenuItem});
			this->showToolStripMenuItem->Name = L"showToolStripMenuItem";
			this->showToolStripMenuItem->Size = System::Drawing::Size(121, 22);
			this->showToolStripMenuItem->Text = L"Show";
			// 
			// messageWindowToolStripMenuItem
			// 
			this->messageWindowToolStripMenuItem->Name = L"messageWindowToolStripMenuItem";
			this->messageWindowToolStripMenuItem->Size = System::Drawing::Size(176, 22);
			this->messageWindowToolStripMenuItem->Text = L"Message Window";
			this->messageWindowToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::messageWindowToolStripMenuItem_Click);
			// 
			// toolPaletteToolStripMenuItem
			// 
			this->toolPaletteToolStripMenuItem->Name = L"toolPaletteToolStripMenuItem";
			this->toolPaletteToolStripMenuItem->Size = System::Drawing::Size(176, 22);
			this->toolPaletteToolStripMenuItem->Text = L"Tool Palette";
			this->toolPaletteToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::toolPaletteToolStripMenuItem_Click);
			// 
			// settingToolStripMenuItem
			// 
			this->settingToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->topMostToolStripMenuItem1});
			this->settingToolStripMenuItem->Name = L"settingToolStripMenuItem";
			this->settingToolStripMenuItem->Size = System::Drawing::Size(121, 22);
			this->settingToolStripMenuItem->Text = L"Setting";
			// 
			// topMostToolStripMenuItem1
			// 
			this->topMostToolStripMenuItem1->Name = L"topMostToolStripMenuItem1";
			this->topMostToolStripMenuItem1->Size = System::Drawing::Size(129, 22);
			this->topMostToolStripMenuItem1->Text = L"Top Most";
			this->topMostToolStripMenuItem1->Click += gcnew System::EventHandler(this, &Form1::topMostToolStripMenuItem1_Click);
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(284, 262);
			this->DoubleBuffered = true;
			this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::None;
			this->Name = L"Form1";
			this->Text = L"Form1";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->MouseUp += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::Form1_MouseUp);
			this->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Form1::Form1_Paint);
			this->MouseClick += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::Form1_MouseClick);
			this->Activated += gcnew System::EventHandler(this, &Form1::Form1_Activated);
			this->MouseDown += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::Form1_MouseDown);
			this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &Form1::Form1_FormClosing);
			this->MouseMove += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::Form1_MouseMove);
			this->contextMenuStrip1->ResumeLayout(false);
			this->ResumeLayout(false);

		}
#pragma endregion
	private: System::Void Form1_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) {
				 this->m_nSequenceID = this->getSequenceIDFromState( m_nStateType );

				 HPLNetSequence^ lpSeq = StaticData::staticData->m_SpriteContainer->getSequence(
					 this->m_nSpriteID, this->m_nSequenceID );

				 HPLNetRect^ rect = lpSeq->getFrame()->m_SrcRect;

				 Image^ img = StaticData::staticData->m_ImageManager->get( 
					 lpSeq->getFrame()->m_nImageHandle );
				 

				// this->TransparencyKey = img->TransparencyKey;

				 bool bIsEndLoop = false;
				 bool bIsFinishAnimation = false;
				 lpSeq->step( bIsEndLoop, bIsFinishAnimation );
				 if( bIsFinishAnimation ) {	// Aj[VI
					 if( HPLState::isDamageState(m_nStateType) ) {
						 // damage state
						 // standɖ߂
						 this->changeState( StateType::STAND );

					 } else {
						 // _[WXe[gȊO
						 switch( this->m_nStateType ) {
						 case StateType::HOLD:	// hold air
							 this->changeState( StateType::HOLD_AIR );
							 break;
						 case StateType::HOLD_AIR:
							 StaticData::staticData->m_nAheCount ++;
							 this->m_MessageWindow->addMessage( String::Format( _T("[т]͐ⒸɒBcI({0})"),
								 StaticData::staticData->m_nAheCount ));
							 this->changeState( StateType::HOLD );
						 default:
							 // loop
							 lpSeq->reset();
						 }
					 }
				 }

				 e->Graphics->DrawImage(
					 img, 0,0,(int)rect->width, (int)rect->height );

			 }
	private: System::Void timer1_Tick(System::Object^  sender, System::EventArgs^  e) {

				 // ړ

				 this->Refresh();
			 }
	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {
			 }
private: System::Void Form1_MouseClick(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {
			 // 
			 switch( e->Button ) {
			 case Windows::Forms::MouseButtons::Right:
				 // show context menu
				 this->contextMenuStrip1->Show(this, e->X,e->Y);
				 break;
			 }
		 }
private: System::Void Form1_MouseDown(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {
			 
			 switch( StaticData::staticData->getSelectedItemIndex() ) {
			 case ItemType::MOVE:
				 StaticData::staticData->m_nHoldMouseX = e->X;
				 StaticData::staticData->m_nHoldMouseY = e->Y;
				 break;
			 case ItemType::TOUCH:
				 switch( e->Button ) {
				 case Windows::Forms::MouseButtons::Left:
					 this->changeState( StateType::DAMAGE );
					 break;
				 }
				 break;
			 }
		 }
private: System::Void Form1_MouseMove(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {
			 switch( StaticData::staticData->getSelectedItemIndex() ) {
			 case ItemType::MOVE:

				 switch( e->Button ) {
				 case Windows::Forms::MouseButtons::Left:
					 if( StaticData::staticData->m_nHoldMouseX >= 0 && StaticData::staticData->m_nHoldMouseY >= 0 ) {
						 this->Left += e->X - StaticData::staticData->m_nHoldMouseX;
						 this->Top += e->Y - StaticData::staticData->m_nHoldMouseY;
					 }
					 break;
				 }
			 }
		 }
private: System::Void Form1_MouseUp(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {
			 StaticData::staticData->m_nHoldMouseX = -1;
			 StaticData::staticData->m_nHoldMouseY = -1;
		 }
private: System::Void exitToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 this->Close();
		 }
private: System::Void topMostToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {

		 }
private: System::Void topMostToolStripMenuItem1_Click(System::Object^  sender, System::EventArgs^  e) {
			 bool bIsTopMost = !this->TopMost;
			 this->TopMost = bIsTopMost;
			 this->topMostToolStripMenuItem1->Checked = bIsTopMost;
		 }
private: System::Void Form1_Activated(System::Object^  sender, System::EventArgs^  e) {
			 //this->m_MessageWindow->Activate();
		/*	 if( this->messageWindowToolStripMenuItem->Checked ) {
				 this->m_MessageWindow->Activate();
			 }*/
		 }
private: System::Void Form1_FormClosing(System::Object^  sender, System::Windows::Forms::FormClosingEventArgs^  e) {
		//	 this->setShowMessageWindow( false );
		 }
private: System::Void messageWindowToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 this->setShowMessageWindow( !this->messageWindowToolStripMenuItem->Checked );
		 }
private: System::Void toolPaletteToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 this->setShowPalette( !this->toolPaletteToolStripMenuItem->Checked );
		 }
};
}

