#include "stdafx.h"
#include "HPLNetLibConsts.h"
#include "StaticData.h"
#include "MessageWindow.h"
#include "Form1.h"

using namespace Evicot;

void StaticData::setup() {
	// bZ[WXgǂݍ
	m_mapMessageSets->Clear();

	List<String^>^ aryResultList = gcnew List<String^>();
	HPLNetLibTool::loadLinesFromFile( aryResultList, 
		_T("data/messages.txt"), gcnew String( HPLNetLibConsts::ENCODING_SHIFT_JIS ),
		true );
	List<String^>^ lst = nullptr;
	int nIndex = -1;
	for each ( String^ str in aryResultList ) {
		if( str->StartsWith(gcnew String(_T("["))) ){
			if( nIndex >= 0 ) {
				m_mapMessageSets[nIndex] = createMessageSet(lst);
			}
			lst = gcnew List<String^>();
			nIndex = Convert::ToInt32( str->Substring(1,str->Length - 2 ) );

		} else {
			lst->Add( str );
		}
	}
	if( nIndex >= 0 ) {
		m_mapMessageSets[nIndex] = createMessageSet(lst);
	}

	m_vecItemInfos->Clear();
	// pbgACeꗗ
	List<String^>^ aryPaletteItems = gcnew List<String^>();
	HPLNetLibTool::loadLinesFromFile(
		aryPaletteItems, _T("data/image/Common/Palette/PaletteList.txt"),
		gcnew String( HPLNetLibConsts::ENCODING_SHIFT_JIS ), true );

	for each ( String^ str in aryPaletteItems ) {
		// pbgACeo^
		String^ strPath = String::Format( _T("data/image/Common/Palette/{0}"),
			str );
		ItemInfo^ info = ItemInfo::LoadItemInfo( strPath );
		m_vecItemInfos->Add( info );
	}

}
void StaticData::setSelectedItemIndex( int nIndex ) {
	this->m_nSelectedItemIndex = nIndex;

	ItemInfo^ info = this->m_vecItemInfos[nIndex];
	if( info->m_Cursor != nullptr ) {
		System::Windows::Forms::Cursor::Current = info->m_Cursor;
	} else {
		System::Windows::Forms::Cursor::Current = Windows::Forms::Cursors::Arrow;
	}
	
	MessageWindow^ window = (MessageWindow^)this->m_MessageWindow;
	String^ strMessage = String::Format( _T("c[[{0}]ɐ؂ւ܂I"), info->m_strName );
	window->addMessage( strMessage);
}


void StaticData::changeState( int nState ) {
	Form1^ form = (Form1^)this->m_MainForm;
	form->changeState( nState );
}
int StaticData::getState() {
	Form1^ form = (Form1^)this->m_MainForm;
	return form->m_nStateType;
}

void StaticData::setWearType( int nType ) {
	this->m_nWearType = nType;
}

