#pragma once

#include "MessageSet.h"
#include "Enum.h"
#include "ItemInfo.h"

using namespace Enum;
using namespace System;
using namespace System::Collections;
using namespace System::Collections::Generic;


public ref class StaticData {
private:
	int m_nSelectedItemIndex;	//! Ic[
	int m_nWearType;
public:
	int getWearType() {
		return this->m_nWearType;
	}
	void setWearType( int nType ) ;
public:
	HPLNetImageManager^		m_ImageManager;
	HPLNetSpriteContainer^	m_SpriteContainer;
	//List<MessageSet^>^ m_vecMessageSets;
	Generic::Dictionary<int,MessageSet^>^ m_mapMessageSets;
	List<ItemInfo^>^ m_vecItemInfos;
	int m_nHoldMouseX;
	int m_nHoldMouseY;
	Windows::Forms::Form^ m_MessageWindow;
	Windows::Forms::Form^ m_MainForm;
	int m_nAheCount;
public:
	StaticData(){
		this->m_mapMessageSets = gcnew Dictionary<int,MessageSet^>();
		this->m_vecItemInfos = gcnew List<ItemInfo^>();
		this->m_nSelectedItemIndex = ItemType::MOVE;
		this->m_nWearType = WearType::NORMAL;
		this->m_nAheCount = 0;
	}
	~StaticData(){}

	static StaticData^ staticData;

	int getSelectedItemIndex() {
		return this->m_nSelectedItemIndex;
	}
	void setSelectedItemIndex( int nIndex );

	MessageSet^ createMessageSet( List<String^>^ lst ) {
		MessageSet^ set = gcnew MessageSet();
		for each ( String^ it in lst ) {
			MessageItem^ item = gcnew MessageItem();
			item->m_Message = it;
			set->add( item );
		}
		return set;
	}
	void setup();
	void loadSprites( ) {
		// C[WXgǂݍ
		this->m_ImageManager = gcnew HPLNetImageManager();
		this->m_SpriteContainer = gcnew HPLNetSpriteContainer( this->m_ImageManager);
		this->m_SpriteContainer->createSpriteList( "data/image/ImageSetFileList.dat" );

	}

	void changeState( int nState );
	int getState();
private:
};

