#include "BasicStaticData.h"

using namespace std;

namespace HPL {
using namespace DirectX;

namespace E3D {
using namespace BasicStaticDataConsts;

int BasicStaticData::get_CameraMode() {
	return this->m_nCameraMode;
}

/** J[hύX
  *
  */
VOID BasicStaticData::set_CameraMode( int nCameraMode,
									 int nPlayerSigID)
{
	if( this->m_nCameraMode == nCameraMode ) {
		return ;
	}
	int ret = 0;

	if( nPlayerSigID >= 0 ) {
		D3DXVECTOR3 vPlayerDirection;
		E3DGetCharaDir( nPlayerSigID, 0,0, &vPlayerDirection );
		// vC[ԍ
		// ݂Ȃ͏Ȃ

		// vC[̈ʒu
		D3DXVECTOR3 vPlayerPosition;
		ret = E3DGetPos( nPlayerSigID, &vPlayerPosition );

		// AtTargetJ̈ʒu
		D3DXVECTOR3 vAtTargetCameraPosition;
		this->m_cameraAtTarget->get_SatellitePosition(
			vPlayerPosition, &vAtTargetCameraPosition );

		// 
		D3DXVECTOR3 vDiff = vPlayerPosition - vAtTargetCameraPosition;
		// K
		D3DXVec3Normalize( &vDiff, &vDiff );

		if( nCameraMode == CameraMode::SNIPER_MODE  &&
			this->get_CameraMode() != CameraMode::SNIPER_MODE)
		{
			// Ȃۂɕς

			// JiTeCgj̏AT_TARGETJvC[̕ɂ
			this->m_cameraSniper->set_NormalizedQuatanionDirection( vDiff );

		} else if(nCameraMode == CameraMode::SHOT_BEHIND_MODE  &&
			this->get_CameraMode() != CameraMode::SHOT_BEHIND_MODE )
		{
			// TPSˌ[hɕς

			// TeCgƏ̏ʒuAtTargetJvC[̕ɂ
			this->m_cameraShotBehind->set_NormalizedQuatanionDirection( vDiff );



		}
	 }

	// J[hύX
	this->m_nCameraMode = nCameraMode;

}


DirectX::DCameraManager* BasicStaticData::get_Camera() {
	if( this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) {
		return this->m_cameraShotBehind;
	} else if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {
		return this->m_cameraSniper;
	}
	return this->m_cameraAtTarget;
}


/** TeCgJʒuAݒ
  * @param[in]	nPlayerSigID	vC[SIGID
  * @param[in]	vPlayerPosition	vC[̍W
  * @retval		0				ُȂ
  *	@retval		1				ُ킠
  */
int BasicStaticData::updateCameraPosition( int nPlayerSigID, D3DXVECTOR3& vPlayerPosition, float fHeight) {

	int ret = 0;

	// iڂ̍j
	D3DXVECTOR3 vEyeHeightVector(0, fHeight,0);

	// TeCg̈ʒu
	// AtTarget		FTeCgvC[i{ڐ̍j
	// ShotBehind	FTeCgvC[̕{i}EXړŃvC[̈ʒuړKvj
	// Sniper		FvC[TeCg
	if( this->get_CameraMode() == CameraMode::AT_TARGET_MODE) {
		D3DXVECTOR3 vCameraPosition;

		// TeCg̈ʒu擾
		this->get_Camera()->get_SatellitePosition( vPlayerPosition + vEyeHeightVector, &vCameraPosition );

		//vCameraPosition += vEyeHeightVector;

		// Jʒuݒ
		E3DSetCameraPos( vCameraPosition );

	}else if(this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE) {

		/*
		// p̍W擾
		D3DXVECTOR3 vCameraPosition;
		ret = get_ShotBehindCameraPosition( nPlayerSigID, &vCameraPosition );
		*/

		D3DXVECTOR3 vPlayerDirection;
		E3DGetCharaDir( nPlayerSigID, 0,0,&vPlayerDirection );

		// ɃvC[̌菭둤̈ʒuɃJu
		D3DXVECTOR3 vCameraPosition = vPlayerDirection * -1;


		// YSɁi]jNx
		D3DXMATRIX matrixY;
		D3DXMatrixRotationY( &matrixY, D3DXToRadian( - 25 ) );

		// sϊ
		D3DXVec3TransformCoord( &vCameraPosition, &vCameraPosition, &(matrixY) );

		// 
		D3DXVec3Scale( &vCameraPosition, &vCameraPosition, CAMERA_SHOT_BEHIND_MODE_CAMERA_DISTANCE );

		// ɏ炷
		D3DXVec3Add( &vCameraPosition, &vCameraPosition, &D3DXVECTOR3(0,CAMERA_SHOT_BEHIND_DELTA_HEIGHT,0 ) );

		// Jʒuݒ
		E3DSetCameraPos( vCameraPosition + vPlayerPosition + vEyeHeightVector);

	} else if(this->get_CameraMode() == CameraMode::SNIPER_MODE ) {
		// RA			vC[̖ڂ̈ʒu
		// TeCg	Ə

		// Jʒuݒ
		E3DSetCameraPos( vPlayerPosition + vEyeHeightVector);
	}

	return 0;
}

/**
  *
  * @param[in]	lQuatanionHorizontal	NH[^jII]
  * @param[in]	fQuatanionVertical	NH[^jIIc]
  */
int BasicStaticData::moveCameraPosition(
	long lQuatanionHorizontal,
	long lQuatanionVertical,
	float *fRateHorizontal,
	float *fRateVertical)
{
	*fRateHorizontal = MOUSE_LOOK_AT_TARGET_MODE_DEGREE_HORIZONTAL;
	*fRateVertical = MOUSE_LOOK_AT_TARGET_MODE_DEGREE_VERTICAL;

	if( this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) {
		*fRateHorizontal = MOUSE_LOOK_SHOT_BEHIND_MODE_DEGREE_HORIZONTAL;
		*fRateVertical = - MOUSE_LOOK_SHOT_BEHIND_MODE_DEGREE_VERTICAL;

	} else if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {

		*fRateHorizontal = MOUSE_LOOK_SNIPER_MODE_DEGREE_HORIZONTAL;
		*fRateVertical = -MOUSE_LOOK_SNIPER_MODE_DEGREE_VERTICAL;
	}

	// ܓx]iE]j
	if( lQuatanionHorizontal != 0 ){

		float fRotateY = (*fRateHorizontal) * lQuatanionHorizontal;

		this->get_Camera()->rotateHorizontalDegree( fRotateY );

		//E3DRotateQY(this->get_Camera()->m_nQuatanionID, fRotateY );
	}

	// ox]ipj
	if( lQuatanionVertical != 0 ){

		float fRotateXZ = (*fRateVertical) * lQuatanionVertical;

		this->get_Camera()->rotateVerticalDegree( fRotateXZ );

		//E3DRotateQLocalX(this->get_Camera()->m_nQuatanionID, fRotateXZ );
	}
	return 0;
}

/** J^[QbgݒiE3D̂܂Ŏ{j
  * @param[in]	
  */
int BasicStaticData::set_CameraLookAt(
	int nPlayerSigID, int nPlayerQuatanionID , float fHeight)
{
	D3DXVECTOR3 vDiff;

	/*float fHeight = PLAYER_EYE_HEIGHT_FROM_CENTER;
	if( bLow ) {
		fHeight = PLAYER_EYE_HEIGHT_FROM_CENTER_LOW;
	}*/
	D3DXVECTOR3 vEyeHeightVector(0, fHeight,0);
	D3DXVECTOR3 vCameraPosition;

	int ret = 0;
	ret = E3DGetCameraPos( &vCameraPosition );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	// vC[̈ʒu
	D3DXVECTOR3 vPlayerPosition;
	ret = E3DGetPos( nPlayerSigID, &vPlayerPosition );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	// tO
	int nUpFlag = CameraUpFlag::ALWAYS_Y_AXIS;


	if( this->get_CameraMode() == CameraMode::AT_TARGET_MODE ) {
		// vC[ւ̕
		vDiff = (vPlayerPosition + vEyeHeightVector) - vCameraPosition;

	} else if( this->get_CameraMode() == CameraMode::SHOT_BEHIND_MODE ) {
		// RA				vC[̖ڂ̈ʒu
		// TuTeCg	Ə
		// CTeCg	Jʒu

		// āALookAt̓TuTeCg

		// ڕWTeCg̈ʒu
		D3DXVECTOR3 vSatellitePosition =
			( this->get_Camera()->get_NormalizedQuatanionDirection() * this->get_Camera()->get_Distance() ) +
			(vPlayerPosition + vEyeHeightVector);


		vDiff = vSatellitePosition - vCameraPosition;
		D3DXVec3Normalize( &vDiff, &vDiff );

		// vC[LN^[
		D3DXVECTOR3 vPlayerNewDirection = -vDiff;
		vPlayerNewDirection.y = 0;
		this->face( vPlayerNewDirection, 1, nPlayerSigID, nPlayerQuatanionID );

	} else if( this->get_CameraMode() == CameraMode::SNIPER_MODE ) {

		// ڕWTeCg̈ʒu
		//D3DXVECTOR3 vSatellitePosition =
		//	( this->get_Camera()->get_NormalizedQuatanionDirection() * this->get_Camera()->get_Distance() );
		//+			vPlayerPosition + vEyeHeightVector;

		vDiff = this->get_Camera()->get_NormalizedQuatanionDirection();// - (vPlayerPosition + vEyeHeightVector);
		D3DXVECTOR3 vPlayerNewDirection = -vDiff;
		vPlayerNewDirection.y = 0;
		
		// vC[LN^[
		this->face( vPlayerNewDirection, 1, nPlayerSigID, nPlayerQuatanionID );
	}

	ret = E3DCameraLookAt( vDiff, 0, CAMERA_ROTATE_DIV);// );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}



} // E3D
} // HPL	
