#include "E3DObjectGameInformation.h"
namespace HPL {
namespace E3D {

static int nIDMaster = 0;
E3DObjectGameInformation::E3DObjectGameInformation() {
	this->m_fHPMax = 100.f;
	this->m_fHP = this->m_fHPMax;
	this->m_nID = nIDMaster;
	nIDMaster ++;
	this->m_nType = 0;

	this->m_Counter = NULL;

	this->m_fDamage = 0;
	this->m_fDamageError = 0;

	this->m_DeathCounter = NULL;

	this->m_nObjectType = ObjectType::ENEMY;

	this->m_nWeaponType = 0;

	reset();
}

E3DObjectGameInformation::~E3DObjectGameInformation() {
	if( this->m_Counter != NULL ) {
		delete m_Counter;
		this->m_Counter = NULL;
	}
	if( this->m_DeathCounter != NULL ) {
		delete m_DeathCounter;
		this->m_DeathCounter = NULL;
	}
}
float E3DObjectGameInformation::set_HP( float fNewHP ) {
	this->m_fHP = fNewHP;
	if( this->m_fHP < 0 ) {
		this->m_fHP = 0;
	}
	if( this->m_fHP > this->m_fHPMax ) {
		this->m_fHP = this->m_fHPMax;
	}
	return this->m_fHP;
}
void E3DObjectGameInformation::reset() {

	this->m_bRecognized = FALSE;
	//this->m_bIsHeld = FALSE;
	this->m_nHolderSigID = -1;
	//this->m_bIsHold = FALSE;
	this->m_nHoldTargetSigID = -1;
	
	this->m_nMoveType = -1;

	this->m_nScenarioIndex = -1;

	if( this->m_Counter != NULL ) {
		this->m_Counter->reset();
	}
	if( this->m_DeathCounter != NULL ) {
		this->m_DeathCounter->reset();
	}
}

}
}
