#ifndef _E3D_SIG_MANAGER_
#define _E3D_SIG_MANAGER_

#include <easy3d.h>

#include <map>
#include <vector>

namespace HPL {
namespace E3D {
class QuaData {
public:
	//! ꂽID
	int m_nQuaID;

	//! őt[
	int m_nMaxFrame;

	/** }bvp
	  */
	QuaData();
	/**
	  * @param nQuaID		ꂽID
	  * @param nMaxFrame	Ɏ擾t[
	  *
	  */
	QuaData( int nQuaID, int nMaxFrame );
	~QuaData();

};
/**
  *
  */
class SigData {
private:
	//! ǂݍ񂾍ۂɕtID
	int m_nSigID;

	//! [UIDE3DŕtꂽID̑Ή\
	std::map<int, QuaData> m_mapQuaIDMap;

public:
	SigData(int nSigID);
	~SigData();

	/** 
	  * @param[in]	nUserID			[UǗpɎw肵ID
	  * @param[in]	szQuaFilePath	Quat@CpX
	  * @param[in]	mvmult			̈ړʔ{
	  * @retval		0				
	  *				-1				Ɏs
	  * @exception	HPLException		݂ID
	  */
	int add_Motion( int nUserID, const char* szQuaFilePath, float mvmult);

	/** 
	  * @retval ꂽID
	  */
	int get_SigID();

	/** 
	  * @retval						QUAf[^
	  * @exception HPLException		݂ID
	  */
	QuaData* get_Motion( int nUserID);

};

/** SIGnh̃}l[WNX
  * SIGt@C̃[hs
  */
class E3DSigManager {
private:
	std::map<int, SigData*> m_mapSigDataMap;

public:
	E3DSigManager();
	~E3DSigManager();

public:
	/**
	  * @param[in]	szSigFilePath	Sigt@CpX
	  * @param[in]	nUserID			[UłID
	  * @param[in]	mult			g嗦
	  * @retval		0				
	  *				-1				Ɏs
	  * @exception	HPLException	ɓo^ĂUserID
	  */
	int load( char* szSigFilePath, int nUserID,
		float mult);

	/** 
	  * @retval					Ŏ擾ID
	  * @exception				݂ȂID
	  */
	SigData* get( int nUserID );
};
}
}

#endif
