#include "E3DSpriteIndexManager.h"
#include "HPLException.h"

namespace HPL {
namespace E3D {
using namespace General ;

E3DSpriteIndexManager::E3DSpriteIndexManager() {
}
E3DSpriteIndexManager::~E3DSpriteIndexManager() {
	this->m_mapSpriteIndexMap.clear();
}

void E3DSpriteIndexManager::set(int nUserIndex, int nSpriteIndex ) {
	this->m_mapSpriteIndexMap[nUserIndex] = nSpriteIndex;
}
int E3DSpriteIndexManager::get(int nUserIndex ) {
	if( this->m_mapSpriteIndexMap.find( nUserIndex ) == this->m_mapSpriteIndexMap.end() ) {
		throw new HPLException(-1, "nUserIndex=%d could not found.", nUserIndex);
	}
	return this->m_mapSpriteIndexMap[nUserIndex];
}

}
}
