#ifndef _HPL_EXCEPTION_
#define _HPL_EXCEPTION_

#include <windows.h>
#include <exception>
#include <string>

namespace HPL {
namespace General {
namespace HPLExceptionConsts {
	static const int BUFFER_MAX = 1024;
}

class HPLException : public std::exception {
private:
	//! G[bZ[W
	std::string m_strErrorMessage;
	
	//! G[R[h
	DWORD m_dwErrorCode;
public:
	/**
	  *
	  */
	HPLException( int dwErrorCode, const char* format, ... );

	/**
	  *
	  */
	~HPLException();

	/**
	  * @retval G[bZ[W
	  */
	const std::string& get_ErrorMessage();

	/**
	  * @retval G[R[h
	  */
	DWORD get_ErrorCode();

};

}// namespace General
}// namespace HPL
#endif
