#include "ScenarioList.h"

namespace HPL {
namespace E3D {
using namespace std;

ScenarioList::ScenarioList() {
}
ScenarioList::~ScenarioList() {
	for( vector<ScenarioItem*>::iterator it = this->m_vecScenarioItemList.begin();
		it != this->m_vecScenarioItemList.end();
		it++ )
	{
		delete *it;
	}
	this->m_vecScenarioItemList.clear();
}
int ScenarioList::get_Index() {
	return this->m_nIndex;
}
int ScenarioList::reset() {
	this->m_nIndex = 0;
	return 0;
}
int ScenarioList::add( ScenarioItem* item ) {
	this->m_vecScenarioItemList.push_back(item);
	return this->m_vecScenarioItemList.size();
}
ScenarioItem* ScenarioList::next() {
	if( this->m_nIndex >= static_cast<int>(this->m_vecScenarioItemList.size()) ) {
		return NULL;
	}

	ScenarioItem* item = this->m_vecScenarioItemList[ this->m_nIndex ];

	this->m_nIndex ++;
	return item;
}
ScenarioItem* ScenarioList::get_Last() {
	if( this->m_vecScenarioItemList.size() == 0 ) {
		return NULL;
	}
	return this->m_vecScenarioItemList[ this->m_vecScenarioItemList.size() - 1];
}

}
}
