#include "BriefingScene.h"
#include "StaticData.h"

namespace MotionTest {
using namespace HPL;
using namespace E3D;

using namespace General;
using namespace MotionTestConsts;
BriefingScene::BriefingScene() : AbstractScene(){

	int ret = 0;
	// ViIACeǂݍ
	ret = m_ScenarioManager.load_ScenariosFromOneText( "Media\\Scenario\\Briefing.txt");

}
BriefingScene::~BriefingScene() {
}

void BriefingScene::init() {
	int ret = 0;
	ret = staticData->initUISceneCommon();

	// wi
	ret = E3DCreateBG( staticData->get_SwapChainID(), "Media\\sea03.png", "hoge", 0, 0, 0, 20000 );

	// _jX[
	staticData->set_GroundType( GroundType::DANIMOTH_ROOM );
	// vC[

	BOOL bHPMax = TRUE;
	bool bIsMoveToCenter = true;
	staticData->reset_Player( bHPMax, bIsMoveToCenter );


	// }EXLb`
	staticData->set_Grab( TRUE );

	// _vC[𐳖ʂ猩ʒuɕς
	staticData->set_CameraInFrontOfObject( staticData->get_Player()->m_nSigID, 0 );

	staticData->m_EnemyManager.reset();
	staticData->m_ShotManager.reset();
	staticData->m_NeutralManager.reset();

	// _jXǉ
	E3DObject* obj = staticData->m_NeutralManager.search( NeutralType::DANIMOTH );
	if( obj != NULL ) {
		// zu
		
		ret = E3DSetPosOnGround( obj->m_nSigID, staticData->get_GroundSigID(), MAP_HEIGHT, MAP_MIN, 70000.f, 70000.f);
		
		ret = E3DGetPos( obj->m_nSigID, &obj->m_Move.m_vPosition );

		// Əɂ
		obj->m_Move.m_vPosition.y = 25000.f;
		ret = E3DSetPos( obj->m_nSigID, obj->m_Move.m_vPosition );

	}


	
	//////////////////////////
	// ViIZbg
	m_ScenarioManager.reset();

	int id = staticData->m_nScenarioIndex;
	if( staticData->m_nScenarioIndex == MissionType::TEST_HOVER ) {
		// tH{Ro
		int nMAX = 5;
		staticData->m_EnemyManager.createObjects( EnemyType::PHOBOKO, nMAX );
		float RADIUS = 10000;
		for(int i = 0; i < nMAX; i ++ ) {
			E3DObject* obj = staticData->m_EnemyManager.search( EnemyType::PHOBOKO );
			E3DSetPosOnGround( obj->m_nSigID, staticData->get_GroundSigID(),
				MAP_HEIGHT, MAP_MIN,
				MathTool::nextRandom<float>(-RADIUS, RADIUS ),
				MathTool::nextRandom<float>(-RADIUS, RADIUS ) );
			E3DGetPos( obj->m_nSigID, &obj->m_Move.m_vPosition );
		}
	}
	if( id >= 0 ) {
		// ViIX^[g
		m_ScenarioItem = m_ScenarioManager.get(id )->next();
	} else {
		m_ScenarioItem = NULL;
	}
}
void BriefingScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void BriefingScene::quit() {
}

//! `
int BriefingScene::drawText() {
	return 0;
}

//! _O
int BriefingScene::render() {
	int ret = 0;

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// vC[f`FbNC
	int status;
	if( E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}

	// nʂƂ̐ڐG
	ret = staticData->checkPlayerOnGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}

		////////////////
		// ̂̓ƕ`
		ret = staticData->m_EnemyManager.process();
		ret = staticData->m_NeutralManager.process();

		if( staticData->m_nScenarioIndex == MissionType::TEST_HOVER &&
			staticData->isEvigenizePlayer())
		{
			int state = 0;

			E3DObject* lpTanya = &staticData->m_aryPlayerList[ PlayerType::TANYA ];

			E3DSetPosOnGround( lpTanya->m_nSigID, staticData->get_GroundSigID(),
				MAP_HEIGHT, MAP_MIN, -5000,5000 );

			// ^[j\
			E3DChkInView( staticData->get_SwapChainID(), 
				lpTanya->m_nSigID, &state );
			E3DRender( staticData->get_SwapChainID(), 
				lpTanya->m_nSigID,
				0,1,0,0 );
			E3DRender( staticData->get_SwapChainID(), 
				lpTanya->m_nSigID,
				1,1,0,0 );

			// Aj[V
			E3DSetNewPoseByMOA( lpTanya->m_nSigID, 0 );

			// vC[̕
			D3DXVECTOR3 vPlayerPosition;
			E3DGetPos( staticData->get_Player()->m_nSigID, &vPlayerPosition );

			D3DXVECTOR3 vTanyaPosition;
			E3DGetPos( lpTanya->m_nSigID, &vTanyaPosition );

			D3DXVECTOR3 vDiff = vPlayerPosition - vTanyaPosition;
			staticData->face( -vDiff, 1, lpTanya->m_nSigID, lpTanya->m_Move.m_nQuoatanion );

		}

		//////////
		// XvCg\
		ret = E3DBeginSprite();

			// NCAg̈̃TCY擾
			RECT rClientRect;
			staticData->get_ClientRect( &rClientRect );
			int nClientHeight = rClientRect.bottom - rClientRect.top;
			int nClientWidth = rClientRect.right - rClientRect.left;


			// ViI\
			staticData->draw_Scenario( this->m_ScenarioItem );

			// \
			ret = E3DTool::drawText(
				500, 10,			//pos XY
				255, 255, 255, 255,	//col RGBA
				1,				// zoom
				"Briefing");

		ret = E3DEndSprite();

		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}

//! t[Ƃ̈ړ
int BriefingScene::frameMove() {
	int ret = 0;

	////////////////////////
	// vC[
	// vC[WASDړ
	staticData->movePlayer();

	// vC[̒e̔
	staticData->shotPlayer();

	// [Vω
	ret = staticData->updatePlayerMotion();

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePreious = staticData->get_DIMouse()->get_PreviousState();
	if( mouse->rgbButtons[0] && mousePreious->rgbButtons[0] == FALSE) {
		if(m_ScenarioItem == NULL || staticData->m_nScenarioIndex < 0) {
			// Q[֐i
			staticData->m_SceneManager.set_Scene( SceneType::GAME );
		} else {
			// ܂ACe邩H
			this->m_ScenarioItem = this->m_ScenarioManager.get(staticData->m_nScenarioIndex)->next();
			if( this->m_ScenarioItem == NULL ) {
				// Q[֐i
				staticData->m_SceneManager.set_Scene( SceneType::GAME );
			}

		}
	}
	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}
}
