#include "EnemyManager.h"
#include "StaticData.h"
#include <cstdlib>

namespace MotionTest {
using namespace HPL;
using namespace E3D;
using namespace General;
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

EnemyManager::EnemyManager() {
}
EnemyManager::~EnemyManager() {
}

///////////////////
// I[o[Ch
BOOL EnemyManager::is_Skip( E3DObject* obj ) {
	return obj->get_Valid() == FALSE ? TRUE: FALSE;

}
int EnemyManager::checkInView( E3DObject* obj ) {
	int status;
	// `FbNC
	if( E3DChkInView( staticData->get_SwapChainID(), obj->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}
/** ^[Qbg̕
  *
  */
void EnemyManager::rotate_AgainstTarget( E3DObject* obj, int nTargetSigID ) {
	if( staticData->is_SkipPlayer(obj) ) {
		// vC[̏ɂG̓vC[̕Ȃ


		if( obj->m_Game.m_Counter->step() & CounterStateType::ALL_LOOP_END ) {
			// 

			// _ɂ
			D3DXVECTOR3 vRndDir = D3DXVECTOR3(MathTool::nextRandom<float>(-1,1), 0, MathTool::nextRandom<float>(-1,1));

			// K
			D3DXVec3Normalize( &vRndDir, &vRndDir);

			// 
			staticData->face( vRndDir, 1, obj->m_nSigID, obj->m_Move.m_nQuoatanion );

			// JE^Zbg
			obj->m_Game.m_Counter->reset();
		}
	} else {
		// vC[̕
		int ret = 0;

		// vC[̈ʒu擾
		D3DXVECTOR3 vPlayerPosition;
		ret = E3DGetPos( nTargetSigID, &vPlayerPosition );

		D3DXVECTOR3 vPosition;
		ret = E3DGetPos( obj->m_nSigID, &vPosition );
		// vC[ւ̕擾
		D3DXVECTOR3 vDiff = vPlayerPosition - vPosition;

		
		// Y͕ςȂiWvƂ̂ŕύXȂƁj

		// ړʂݒiĂɂj
		obj->m_Move.m_vVelocity.x = vDiff.x;
		obj->m_Move.m_vVelocity.z = vDiff.z;

		D3DXVECTOR3 vDirection = -obj->m_Move.m_vVelocity;
		vDirection.y = 0;
		staticData->face( vDirection,
			1, obj->m_nSigID, obj->m_Move.m_nQuoatanion );
	}
}

void EnemyManager::changeMosukoFace( E3DObject* obj, int nMaterial ) {
	staticData->set_Texture( obj->m_nSigID, "me", nMaterial , FALSE);
	staticData->set_Texture( obj->m_nSigID, "mayu", nMaterial , FALSE );
	staticData->set_Texture( obj->m_nSigID, "kuchi", nMaterial , FALSE );
}

int EnemyManager::checkHitToGround( E3DObject* obj ) {
	int ret = 0;

	ret = staticData->checkObjectOnGround( obj, FALSE);
	if( ret ) {
		_ASSERT(0);
		return ret;
	}

	bool bIsOnTheGround = obj->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == TRUE;

	if( obj->m_Game.m_nType == EnemyType::MOSUKO ||
		obj->m_Game.m_nType == EnemyType::MOSUKO_LONG )
	{
		if( obj->m_nEventNumber == Motion::Mosuko::DAMAGE_A ) {
			// n猳ʂ
			if( bIsOnTheGround ) {
				// \߂
				this->changeMosukoFace( obj, Material::MOSUKO_KAO_1 );

				// [V𗧂ԁi{jɖ߂
				obj->m_nEventNumber = 0;
			}
		} else if( obj->m_nEventNumber == Motion::Mosuko::DAMAGE_CRASH ) {
			// downɐ؂ւ
			if( bIsOnTheGround ) {
				obj->m_nEventNumber = Motion::Mosuko::DOWN;
			}

		}
	}

	return 0;
}
/*
int EnemyManager::checkHitToBillBoard( E3DObject* obj ) {

	// VbgSigIDXg
	int nShotID[MotionTestConsts::SHOT_MAX];

	// Vbg̐
	int nConfNum;

	// ǂ̌
	int confptr = 0;

	int ret = 0;

	// Sr{[hƂ̓蔻`FbN
	ret = E3DChkConfBillboard( obj->m_nSigID,
		1.f, &confptr, nShotID, MotionTestConsts::SHOT_MAX, &nConfNum );

	if( confptr != 0 ) {
		// ɓ

		for(int i = 0; i < nConfNum; i ++ ) {
			// e

			ret = E3DSetValidFlag( -1, nShotID[i] , FALSE);

			// tŃr{[h擾
			E3DBillBoard* billBoard = staticData->m_ShotBillBoardManager.m_mapSigIDToBillBoardMap[ nShotID[i] ];
			billBoard->set_Alive( FALSE );

			// G̗̑͂炷
			float fNextHP = obj->m_Game.m_fHP - MotionTestConsts::SHOT_POWER;
			if( fNextHP <= 0) {
				fNextHP = 0;
				// S
				obj->set_Valid( FALSE );
				E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
			}
			obj->m_Game.m_fHP = fNextHP;
		}



		if( static_cast<int>(staticData->m_lstEnemyLifeBarList.size() ) < MotionTestConsts::ENEMY_LIFE_BAR_STACK_NUM_MAX ) {
			// G̗͕̑\XgɃL[LB

			// 
			BOOL bFound = FALSE;

			for(std::list<EnemyLifeBar*>::iterator it = staticData->m_lstEnemyLifeBarList.begin();
				it != staticData->m_lstEnemyLifeBarList.end();
				it ++ )
			{
				EnemyLifeBar* lifeBar = *it;
				if( lifeBar->m_nSigID == obj->m_nSigID ) {
					// ɓo^ς
					// XV
					lifeBar->m_fHP = obj->m_Game.m_fHP;
					lifeBar->m_Counter.reset();
					bFound = TRUE;
					break;
				}
			}
			if( bFound == FALSE ) {
				// VKǉ
				EnemyLifeBar* lifeBar = new EnemyLifeBar();
				lifeBar->m_fHP = obj->m_Game.m_fHP;
				lifeBar->m_fHPMax = obj->m_Game.m_fHPMax;
				lifeBar->m_strName = std::string( "Cyclops");
				lifeBar->m_Counter.set_FrameCounterMax( MotionTestConsts::ENEMY_LIFE_BAR_REMAIN_COUNT );
				lifeBar->m_Counter.set_LoopNumMax( 1 );
				lifeBar->m_nSigID = obj->m_nSigID;
				lifeBar->m_Counter.reset();
				staticData->m_lstEnemyLifeBarList.push_back(lifeBar );
			}

		}
	}
	return 0;
}*/
int EnemyManager::checkHitToPlayer( E3DObject* obj ) {

	int ret = 0;

	bool bIsDamageToPlayer = true;
	/////////
	// XLbv`FbN
	if( staticData->is_SkipPlayer( obj ) ) {
		return 0;
	} else if( obj->m_Game.m_nHoldTargetSigID == staticData->get_Player()->m_nSigID ) {
		// ߂܂Ă
		// `FbN͂Ȃ
		return 0;
	} else if( 
		staticData->isPlayerControllable() == false )
	{
		// _[W͐HȂ
		return 0;
	} else if( obj->m_Game.m_nType == EnemyType::WORM_BIG &&
		(obj->m_nEventNumber == Motion::Worm::VOMIT ||
		obj->m_nEventNumber == Motion::Worm::SWALLOW ||
		obj->m_nEventNumber == Motion::Worm::DEAD) )
	{
		// U[VȊOȂHȂ

		// Gւ̍U͓
		bIsDamageToPlayer = false;

	} else if( obj->m_Game.m_nType == EnemyType::WORM_SMALL &&
		(obj->m_nEventNumber != Motion::Worm::APPEAR &&
		obj->m_nEventNumber != Motion::Worm::ATTACK_A &&
		obj->m_nEventNumber != Motion::Worm::ATTACK_B &&
		obj->m_nEventNumber != Motion::Worm::BRITS &&
		obj->m_nEventNumber != Motion::Worm::VOMIT) ) 
	{
		// U[VȊOȂHȂ
		// Gւ̍U͓
		bIsDamageToPlayer = false;

	} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE &&
		(obj->m_nEventNumber != Motion::Zombie::ATTACK_A &&
		obj->m_nEventNumber != Motion::Zombie::ATTACK_B &&
		obj->m_nEventNumber != Motion::Zombie::ATTACK_C
		) ) 
	{
		// U߈ȊOȂqbgȂ
		// Gւ̍U͓
		bIsDamageToPlayer = false;

	} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE_B) {
		if( obj->m_nEventNumber != Motion::Zombie_B::ATTACK_A ||
			obj->m_nEventNumber != Motion::Zombie_B::JUMP_ATTACK )
		{
			// Gւ̍U͓
			bIsDamageToPlayer = false;
		}
	} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE_A ||
		obj->m_Game.m_nType == EnemyType::ROPER )
	{
		// Ϗܗp̓G͍UȂ
		return 0;
	} else if( obj->m_Game.m_nType == EnemyType::PHOBOKO ) {
		// tH{q́îƂj
		return 0;
	} else if( obj->m_Game.m_nType == EnemyType::ARACHNE ) {
		if( obj->m_nEventNumber != Motion::Arachne::ATTACK_A ) {
			// UȊO͓Ȃ
			// Gւ̍U͓
			bIsDamageToPlayer = false;
		}
	}

	//
	/////////

	// ݂̃t[ԍ擾
	int motid;
	int frameno;
	ret = E3DGetMotionFrameNo( obj->m_nSigID, &motid, &frameno );
	// HȂǂŁAxߖo
	BOOL bOnceDeathVoice = FALSE;

	// HŁAɏ㔼g
	BOOL bIsJohanshin = FALSE;

	int confptr = 0;		

	int inviewptr;

	ret = E3DChkConflictOBB( staticData->get_Player()->m_nSigID, -1,
		obj->m_nSigID, -1, &confptr , &inviewptr);
	if( ret ) {
		_ASSERT( 0 );
		return 1;
	}
	if( confptr ) {
		// ʏ_[Wiсj
		BOOL bNormalDamage = FALSE;

		// ̂ݔj
		BOOL bTearHuku = FALSE;

		// _[W[V^Cv
		// 0 : _[WA,B̃_
		// 1 : ΂
		int nBlowType = 0;

		int nNextEventNo = -1;

		if( staticData->isMeleeAttackMotion() ) 
		{
			// GɃ_[W
			float fBlowRate = 5.f;
			float fDamageRate = 100.f;	// test
			staticData->m_EnemyManager.damage( staticData->get_Player(), obj , fBlowRate, fDamageRate);
			return 0;
		}
		if( bIsDamageToPlayer == false ) {
			// vC[Ƀ_[WȂsȂXLbv
			return 0;
		}

		float fDamage = (obj->m_Game.m_fDamage + 
			MathTool::nextRandom<float>( -obj->m_Game.m_fDamageError,
			obj->m_Game.m_fDamageError ) );

		if( //
			obj->m_Game.m_nType == EnemyType::WORM_BIG &&
			obj->m_nEventNumber == Motion::Worm::ATTACK_A ) 
		{
			// ݕt

			// 
			fDamage = staticData->get_Player()->m_Game.m_fHPMax;

			if( staticData->isEvigenizePlayer() ) {
				// Ƀ[V
				nNextEventNo = Motion::Evigen::DEATH ;
				if( staticData->m_aryOptionList[TitleSceneConsts::CheckType::KUBI] ) {
					// 㔼g
					char MATS[][100] = {
						"atama",
						"kami",
						"karada",
						"huku",
						"apron",
						"katyu",
						"shitagi",
						"danmen",	//̒fʂ
					};
					for(int i = 0; i < 8; i ++ ) {
						int mat = 0;
						ret = E3DGetMaterialNoByName( staticData->get_Player()->m_nSigID, MATS[i], &mat );
						if( ret ) {
							_ASSERT( 0 );
							return 1;
						}
						ret = E3DSetMaterialAlpha( staticData->get_Player()->m_nSigID, mat, 0.f );
						if( ret ) {
							_ASSERT( 0 );
							return 1;
						}
					}
					// ̂̒fʂ\
					int mat = 0;
					ret = E3DGetMaterialNoByName( staticData->get_Player()->m_nSigID, "danmen_body", &mat );
					if( ret ) {
						_ASSERT( 0 );
						return 1;
					}
					ret = E3DSetMaterialAlpha( staticData->get_Player()->m_nSigID, mat, 1.f );
					if( ret ) {
						_ASSERT( 0 );
						return 1;
					}
					// xo
					bOnceDeathVoice = TRUE;
					bIsJohanshin = TRUE;
				}
			}

		} else if( (staticData->isEvigenizePlayer()) &&
			obj->m_Game.m_nType == EnemyType::WORM_BIG &&
			obj->m_nEventNumber == Motion::Worm::ATTACK_B )
		{

			// 
			//fDamage = staticData->get_Player()->m_Game.m_fHPMax;
			//fDamage = 0.01f;

			// TODO ۓۂݏ
			if( staticData->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
				// ۓۂ݂ցB
				obj->m_Game.m_nHoldTargetSigID = staticData->get_Player()->m_nSigID;
				staticData->get_Player()->m_Game.m_nHolderSigID = obj->m_nSigID;
				nNextEventNo = Motion::Evigen::SWALLOW ;

				obj->m_nEventNumber = Motion::Worm::SWALLOW;
				
			}


		} else if(
			obj->m_Game.m_nType == EnemyType::WORM_BIG
			)
		{
			// ̑̃[BIGU


			bNormalDamage = TRUE;

			if( staticData->isEvigenizePlayer()  ) {
				// ΂_[W[V
				nBlowType = 1;
			}



		} else if( 
			obj->m_Game.m_nType == EnemyType::ZOMBIE &&
			obj->m_nOldEventNumber == obj->m_nEventNumber &&
			((obj->m_nEventNumber == Motion::Zombie::ATTACK_A && frameno > 35) ||
			(obj->m_nEventNumber == Motion::Zombie::ATTACK_B && frameno > 48))
			)
		{
			// PU
			bNormalDamage = TRUE;

			// j
			bTearHuku = TRUE;

			// ΂
			nBlowType = 1;
			
		} else if(
			obj->m_Game.m_nType == EnemyType::ZOMBIE_B &&
			obj->m_nOldEventNumber == obj->m_nEventNumber &&
			obj->m_nEventNumber == Motion::Zombie_B::ATTACK_A )//&& frameno > 25 )
		{
			// PU
			bNormalDamage = TRUE;

			// j
			bTearHuku = TRUE;

			// ΂
			nBlowType = 1;
			
		} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE_B &&
			obj->m_nOldEventNumber == obj->m_nEventNumber &&
			obj->m_nEventNumber == Motion::Zombie_B::JUMP_ATTACK )
		{
			// т
			// 
			staticData->remove_Head();

			if( staticData->isEvigenizePlayer()  ) {
				// ʏ펀
				nNextEventNo = Motion::Evigen::DEATH ;
			}

			// o
			bOnceDeathVoice = TRUE;

			// HP=0
			fDamage = staticData->get_Player()->m_Game.m_fHPMax;

		} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE &&
			obj->m_nOldEventNumber == obj->m_nEventNumber &&
			(obj->m_nEventNumber == Motion::Zombie::ATTACK_C && frameno > 38))
		{
			// ߂܂
			if( staticData->isEvigenizePlayer()  ) {
				nNextEventNo = Motion::Evigen::DAMAGE_A;
			}
			obj->m_Game.m_nHoldTargetSigID = staticData->get_Player()->m_nSigID;
			staticData->get_Player()->m_Game.m_nHolderSigID = obj->m_nSigID;
			obj->m_nEventNumber = Motion::Zombie::HOLD;

		} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE ) {
			// ȊȌԂł̃]rɂ͓蔻肪
			bNormalDamage = FALSE;
		} else {
			bNormalDamage = TRUE;
		}
		if( bNormalDamage ) {
			// vC[𐁂΂

			staticData->blow_Out( obj, staticData->get_Player() , 1);



		}

		// ̃[V_[W
		if( nNextEventNo == -1 ) {
			if( staticData->isEvigenizePlayer()  ) {
				// [Vς

				if( nBlowType == 0 ) {
					// _A,B
					int rnd = MathTool::nextRandom<int>(0,2 );

					nNextEventNo = Motion::Evigen::DAMAGE_A;
					if( rnd == 0 ) {
						nNextEventNo = Motion::Evigen::DAMAGE_B;
					}
				} else if( nBlowType == 1 ){
					nNextEventNo = Motion::Evigen::DAMAGE_CRASH_UP;
				} else {
					_ASSERT(0);
				}
			} else {
				nNextEventNo = 0;
			}
		}
		// ꕔттɂ
		if( staticData->get_Player()->m_Game.m_nType == PlayerType::EVIGEN&&
			bTearHuku && staticData->m_nClothBreak == 0 )
		{
			staticData->m_nClothBreak = 1;
			staticData->set_Texture( staticData->get_Player()->m_nSigID, "huku", Material::CLOTH_NORMAL + staticData->m_nClothBreak, FALSE );
			staticData->set_Texture( staticData->get_Player()->m_nSigID, "huku_under", Material::CLOTH_NORMAL + staticData->m_nClothBreak, FALSE );
		}

		////////////
		// vC[̈ʒu{vC[̕~苗猌o
		// ڂ̍
		D3DXVECTOR3 vEyeHeight( 0, PLAYER_EYE_HEIGHT_FROM_CENTER , 0 );
		D3DXVECTOR3 vBloodPosition = staticData->get_Player()->m_Move.m_vPosition;

		// ڂ̍ɂ
		vBloodPosition += vEyeHeight;

		// vC[̕
		D3DXVECTOR3 vDirection;
		E3DGetCharaDir( staticData->get_Player()->m_nSigID, 0,0, &vDirection );
		vDirection *= -1;
		vDirection.y = 0;
		// normalize
		D3DXVec3Normalize( &vDirection, &vDirection );

		D3DXVECTOR3 vBloodDistance = vDirection;
		//scale
		D3DXVec3Scale( &vBloodDistance, &vBloodDistance, SHOT_FROM_DISTANCE );

		vBloodPosition += vBloodDistance;

		// 萔o
		for(int i = 0; i < PLAYER_DAMAGE_BLOOD_NUM; i ++ ) {
			staticData->create_Blood( vBloodPosition, vDirection );
		}

		float fOldHP = staticData->get_Player()->m_Game.m_fHP;

		// _[W
		staticData->get_Player()->m_Game.m_fHP -= fDamage;

		if( staticData->get_Player()->m_Game.m_fHP <= 0 ) {
			// S

			staticData->get_Player()->m_Game.m_fHP = 0;
			// Q[I[o[

			// mœ
			if( staticData->m_aryOptionList[TitleSceneConsts::CheckType::KUBI] && bIsJohanshin == FALSE) {
				if( MathTool::nextRandom<float>(0, 100 ) < 10.f ) {
					// 
					staticData->remove_Head();
				}
			}

			if( bOnceDeathVoice && fOldHP > 0 ) {
				// 傤Ǎ񂾂ƂBxo
				ret = E3DPlaySound( staticData->m_arySoundList[ Sound::VOICE_CRASH ], 0, 0, 0 );
			}
		}

		staticData->get_Player()->m_nUnderEventNumber = -1;
		staticData->get_Player()->m_nEventNumber = nNextEventNo;

		// eNX`؂ւ
		float fAlpha = 0;
		if( staticData->isEvigenizePlayer()) {
			int nMaterial = Material::DAMAGE;
			if( MathTool::nextRandom<int>(0,2) == 1 ) {
				nMaterial = Material::DAMAGE_CRASH;
			}
			ret = staticData->setFace( staticData->get_Player()->m_nSigID, nMaterial, TRUE );

			//}eAݒ
			int mat;
			ret = E3DGetMaterialNoByName( staticData->get_Player()->m_nSigID, "atama", &mat );
			if(ret){
				_ASSERT(0);
			}

			if( staticData->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
				int nTex = staticData->m_nUnderColor == 0 ? Material::KARADA_DAMAGE : Material::KARADA_DAMAGE_BLACK;
				ret = staticData->set_Texture( staticData->get_Player()->m_nSigID, "karada", nTex, FALSE );
				ret = staticData->set_Texture( staticData->get_Player()->m_nSigID, "karada_under", nTex, FALSE );
			}

			// At@l擾
			ret = E3DGetMaterialAlpha( staticData->get_Player()->m_nSigID, mat, &fAlpha );
			if(ret){
				_ASSERT(0);
			}

		}

		// _vC[𐳖ʂ猩ʒuɕς
		if( staticData->m_nCameraTargetSigID == staticData->get_Player()->m_nSigID ) {
			staticData->set_CameraInFrontOfObject( //staticData->m_nCameraTargetSigID,
				staticData->get_Player()->m_nSigID,
				0 );
		}


		
		if( bOnceDeathVoice == FALSE && fAlpha > 0.5f ){
			if( staticData->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
				// SE
				int nVoiceID = MathTool::nextRandom<int>(0,7 ) + Sound::VOICE_HIT_1;
				if( nNextEventNo == Motion::Evigen::DAMAGE_CRASH_UP ||
					nNextEventNo == Motion::Evigen::SWALLOW)
				{
					// у{CX
					nVoiceID = Sound::VOICE_CRASH;
				}
				ret = E3DPlaySound( staticData->m_arySoundList[ nVoiceID ], 0, 0, 0 );
			}

		}

	} else {
		// GĂȂ

	}


	// GmłԂȂ悤ɂ
	//ret = checkHitToEnemy( obj );

	return 0;
}
int EnemyManager::render( E3DObject* obj ) {

	// sig id擾
	int hsid = obj->m_nSigID;

	// ʏ`
	if( E3DRender( staticData->get_SwapChainID(), hsid, 0, 1, 0, 0 ) ){
		_ASSERT( 0 );
		return 1;
	}

	// uh`
	if( E3DRender( staticData->get_SwapChainID(), hsid, 1, 1, 0, 0 ) ){
		_ASSERT( 0 );
		return 1;
	}
	int ret = E3DSetBeforePos( obj->m_nSigID) ;
	return 0;
}

int EnemyManager::checkHitToEnemy( E3DObject* obj ) {
	int ret = 0;

	//std::list<E3DObject*> lstDone;

	for(std::map<int, std::list<E3DObject*> >::iterator mit = this->m_mapObjectListMap.begin();
		mit != this->m_mapObjectListMap.end();
		mit ++ ) 
	{
		if( this->m_mapEnableMap[ mit->first ] == FALSE ) {
			// ȂIuWFNg
			continue;
		}

		/*if( mit->first != EnemyType::MOSUKO &&
			mit->first != EnemyType::MOSUKO_LONG )
		{
			continue;
		}*/

		if( obj->m_Game.m_nType == mit->first ) {
			// Gm͓蔻Ȃ
			continue;
		}

		
		// ݂̃t[ԍ擾
		int motid;
		int frameno;
		ret = E3DGetMotionFrameNo( obj->m_nSigID, &motid, &frameno );

		if( obj->m_Game.m_nType == EnemyType::TROL ) {
			if( obj->m_nEventNumber != Motion::Trol::ATTACK &&
				obj->m_nEventNumber != Motion::Trol::JUMP_DOWN &&
				obj->m_nEventNumber != Motion::Trol::JUMP_UP)
			{
				// XLbv
				continue;
			}
		} else if( obj->m_Game.m_nType == EnemyType::MOSUKO ) {
			continue;
		}
			
		//for(std::list<E3DObject*>::iterator it = mit->second.begin();
		//	it != mit->second.end(); it ++ )
		for(std::list<E3DObject*>::iterator it = this->m_mapValidObjectListMap[mit->first].begin();
			it != this->m_mapValidObjectListMap[mit->first].end(); it ++ )
		{
			E3DObject* other = *it;

			if( other == obj ) {
				continue;
			}

			if( other->get_Valid() == FALSE ) {
				continue;
			}

			if( other->m_Game.m_nType == EnemyType::MOSUKO ||
				other->m_Game.m_nType == EnemyType::MOSUKO_LONG )
			{
				if( other->m_nEventNumber == Motion::Mosuko::DAMAGE_A ||
					other->m_nEventNumber == Motion::Mosuko::DAMAGE_CRASH )
				{
					// _[W̓_[W󂯂Ȃ
					continue;
				}
			}

			/*BOOL bContinue = FALSE;
			for(std::list<E3DObject*>::iterator done = lstDone.begin();
				done != lstDone.end(); done ++ )
			{
				E3DObject* doneObj = *done;
				if( doneObj == obj || doneObj == other) {
					bContinue = TRUE;
					break;
				}
			}
			if( bContinue == TRUE ) {
				continue;
			}*/

			
			//int confptr;
			/*
			int inviewptr;
			ret = E3DChkConflictAABB( obj->m_nSigID,// -1,
				other->m_nSigID, //-1,
				&confptr , &inviewptr);
			if( ret ) {
				_ASSERT( 0 );
				return 1;
			}*/
			D3DXVECTOR3 vPos1;
			E3DGetPos( obj->m_nSigID, &vPos1 );
			D3DXVECTOR3 vPos2;
			E3DGetPos( other->m_nSigID, &vPos2 );
			D3DXVECTOR3 vDiff = vPos1 - vPos2;

			// ȏ߂Â甽
			const float ENEMY_DISTANCE = 1500.f;

			// ۂ̋
			float fDistance = D3DXVec3Length( &vDiff);


			if( fDistance < ENEMY_DISTANCE ) {

				
/*				lstDone.push_back( obj );
				lstDone.push_back( other );*/



/*				D3DXVec3Normalize( &vDiff, &vDiff );
				vDiff *= ENEMY_DISTANCE;
				vDiff.y = 0;
				vPos1 = vPos2 + vDiff;
				obj->m_Move.m_vPosition = vPos1;
				E3DSetPos( obj->m_nSigID, vPos1 );*/

				// ԂɂčU݂ɓ蓖Ȃ
				staticData->blow_Out( obj, other , 5.f);
				if( other->m_Game.m_nType == EnemyType::MOSUKO ||
					other->m_Game.m_nType == EnemyType::MOSUKO_LONG )
				{
					// _[WɂȂ
					this->changeMosukoFace( other, Material::MOSUKO_KAO_5 );

					// _[W[VɂȂ
					other->m_nEventNumber = Motion::Mosuko::DAMAGE_A;

					float fRnd = MathTool::nextRandom<float>(0,100.f);
					
					if( fRnd < 60.f ) {
						other->m_nEventNumber = Motion::Mosuko::DAMAGE_CRASH;
					}
				}

			}
		}
	}
	return 0;
}

float EnemyManager::get_Zoom( int nType ) {
	

	float fZoom = 1.f;
	if( nType == EnemyType::CYCLOPS ) {
		fZoom = 1.f;
	} else if( nType == EnemyType::WORM_BIG ) {
		fZoom = 1.0f;
	} else if( nType == EnemyType::WORM_SMALL ) {
		fZoom = 0.1f;
	} else if( nType == EnemyType::ZOMBIE ) {
		fZoom = 0.4f;
	} else if( nType == EnemyType::ZOMBIE_A ) {
		fZoom = 1.f;
	} else if( nType == EnemyType::MOSUKO ||
		nType == EnemyType::MOSUKO_LONG )
	{
		fZoom = 1.f;
	} else if( nType == EnemyType::ZOMBIE_B ) {
		fZoom = 0.4f;
	} else if( nType == EnemyType::TROL ) {
		fZoom = 0.5f;
	} else if( nType == EnemyType::HOVER ) {
		fZoom = 1.f;
	} else if( nType == EnemyType::ROPER ) {
		fZoom = 1.f;
	} else if( nType == EnemyType::PHOBOKO ) {
		fZoom = 1.f;
	} else if( nType == EnemyType::ARACHNE ) {
		fZoom = 0.5f;
	} else if( nType == EnemyType::WALL ) {
		fZoom = 4.f;
	} else if( nType == EnemyType::SWITCH ) {
		fZoom = 1.f;
	}

	return fZoom;
}

bool EnemyManager::isFly( int nType , int nEventNumber ) {
	if( nType == EnemyType::HOVER ||
		nType == EnemyType::WALL ||
		nType == EnemyType::SWITCH)
	{
		return true;
	}

	return false;
}

void EnemyManager::die( E3DObject* obj ) {

	// GjJEgAbv
	staticData->nKilledEnemyNumber ++;

	// 

	// 
	obj->set_Valid( FALSE );
	E3DSetValidFlag( obj->m_nSigID, -1, FALSE );

	// ACe

	// mij
	float ITEM_RATE_LIST[] = {
		5,	// MINI_GUN
		8,	// HAND_GUN			
		3,	// MEDI_KIT	
		50,	// AMMO		
		1,	// MEAT		
	};

	int nNeutralType = -1;
	float fRnd = MathTool::nextRandom<float>(0,100);
	float fRate = 0;
	for( int i = 0; i < 5; i ++ ) {
		fRate += ITEM_RATE_LIST[i];
		if( fRnd <= fRate ) {
			nNeutralType = NeutralType::MINI_GUN + i;
			break;
		}
	}

	if( nNeutralType == -1 ||
		nNeutralType == NeutralType::MINI_GUN && staticData->m_aryWeaponList[ WeaponType::MINI_GUN].is_Valid() ||
		nNeutralType == NeutralType::HAND_GUN && staticData->m_aryWeaponList[ WeaponType::HAND_GUN].is_Valid() )
	{
		// Ȃ
	} else {
		E3DObject* neutral = staticData->m_NeutralManager.search( nNeutralType );
		if( neutral ) {
			neutral->m_Move.m_vPosition = obj->m_Move.m_vPosition;
			neutral->m_Move.m_vPosition.y = BasicStaticDataConsts::PLAYER_EYE_HEIGHT_FROM_CENTER;
			E3DSetPos( neutral->m_nSigID, neutral->m_Move.m_vPosition );

			const float ITEM_JUMP_SPEED = 100.f;
			neutral->m_Move.m_vVelocity = D3DXVECTOR3(0,ITEM_JUMP_SPEED, 0 );
		}

	}

	if( staticData->m_nScenarioIndex == MissionType::WORM ) {
		// [Xe[W
		if( obj->m_Game.m_nType == EnemyType::WORM_BIG ) {
			// [e

			if( staticData->m_ScenarioItem == NULL ) {
				// Zbg
				staticData->m_ScenarioManager.reset();
			}
			// NAZt
			staticData->m_nScenarioListID = 9;
			staticData->m_ScenarioItem = staticData->m_ScenarioManager.get( staticData->m_nScenarioListID )->next();
		}
	}
}

void EnemyManager::damage( HPL::E3D::E3DObject* obj, HPL::E3D::E3DObject* enemy, float fBlowRate, float fDamageRate ) {
	// eĂƋtɁB
	D3DXVECTOR3 vDirection;
	E3DGetCharaDir( obj->m_nSigID, 0,0, &vDirection);

	D3DXVec3Normalize( &vDirection, &vDirection );

	// 򖗂o(1)
	// Vbg̈ʒuo
	E3DBillBoard* billBoard = staticData->create_Blood( obj->m_Move.m_vPosition,
		vDirection);

	// GCÂ
	enemy->m_Game.m_bRecognized = TRUE;

	if( enemy->m_Game.m_nType == EnemyType::ZOMBIE_B && enemy->m_Move.get_Trigger( TriggerType::ON_THE_GROUND ) == FALSE &&
		enemy->m_nEventNumber != Motion::Zombie_B::AIR_DAMAGE)
	{
		// 󒆂ɂ

		// ꃂ[VɈڂ
		enemy->m_nEventNumber = Motion::Zombie_B::AIR_DAMAGE;
	}

	// G̗̑͂炷
	float fPower = MotionTestConsts::SHOT_POWER;

	if( obj->m_Game.m_nObjectType == ObjectType::SHOT ) {
		if( obj->m_Game.m_nType == ShotType::MISSILE ) {
			fPower = MotionTestConsts::SHOT_MISSILE_POWER;
		} else if( obj->m_Game.m_nType == ShotType::BAKUFU ) {
			fPower = MotionTestConsts::SHOT_BAKUFU_POWER;
		}
	}

	fPower *= fDamageRate;

	float fNextHP = enemy->m_Game.m_fHP - fPower;
	if( fNextHP <= 0) {
		fNextHP = 0;

		// 

		if( enemy->m_Game.m_nType == EnemyType::WORM_BIG)
		{ 
			// [ł
			// Ȃ

			// S[VɈڂ
			enemy->m_nEventNumber = Motion::Worm::DEAD;
		} else if( enemy->m_Game.m_nType == EnemyType::ZOMBIE)
		{ 
			// S[VɈڂ
			enemy->m_nEventNumber = Motion::Zombie::DEAD;
		} else if( enemy->m_Game.m_nType == EnemyType::ZOMBIE_B)
		{ 
			// S[VɈڂ
			enemy->m_nEventNumber = Motion::Zombie_B::DEAD;
		} else if( enemy->m_Game.m_nType == EnemyType::MOSUKO ||
			enemy->m_Game.m_nType == EnemyType::MOSUKO_LONG )
		{
			// S
			enemy->m_nEventNumber = Motion::Mosuko::DAMAGE_CRASH;
		} else if( enemy->m_Game.m_nType == EnemyType::SWITCH ) {
			// [VύX
			enemy->m_nEventNumber = Motion::Switch::ON;
		} else {
			// S
			staticData->m_EnemyManager.die( enemy );
		}

	}
	enemy->m_Game.m_fHP = fNextHP;

	////////////////////////////////////////
	// ΂

	if( enemy->m_Game.m_nType == EnemyType::WORM_BIG ) {
		// ΂Ȃ
	} else if( enemy->m_Game.m_nType == EnemyType::MOSUKO ||
		enemy->m_Game.m_nType == EnemyType::MOSUKO_LONG ) 
	{
		// _[WAɂ
		enemy->m_nEventNumber = Motion::Mosuko::DAMAGE_A;
		// ΂
		staticData->blow_Out( obj, enemy, 0.5f * fBlowRate );
	} else {
		// [ȊO

		if( obj->m_Game.m_nObjectType == ObjectType::SHOT &&
			obj->m_Game.m_nType == ShotType::BAKUFU )
		{
			// 

			// ΂
			staticData->blow_Out( obj, enemy, 3.f * fBlowRate );

		} else if( obj->m_Game.m_nObjectType == ObjectType::PLAYER ){
			// ڍU
			// ΂
			staticData->blow_Out( obj, enemy, 3.f * fBlowRate );

		}

	}

	if( static_cast<int>(staticData->m_lstEnemyLifeBarList.size() ) < MotionTestConsts::ENEMY_LIFE_BAR_STACK_NUM_MAX ) {
		// G̗͕̑\XgɃL[LB

		// 
		BOOL bFound = FALSE;

		for(std::list<EnemyLifeBar*>::iterator bit = staticData->m_lstEnemyLifeBarList.begin();
			bit != staticData->m_lstEnemyLifeBarList.end();
			bit ++ )
		{
			EnemyLifeBar* lifeBar = *bit;
			if( lifeBar->m_nSigID == enemy->m_nSigID ) {
				// ɓo^ς
				// XV
				lifeBar->m_fHP = enemy->m_Game.m_fHP;
				lifeBar->m_Counter.reset();
				bFound = TRUE;
				break;
			}
		}
		if( bFound == FALSE ) {
			// VKǉ
			EnemyLifeBar* lifeBar = new EnemyLifeBar();
			lifeBar->m_fHP = enemy->m_Game.m_fHP;
			lifeBar->m_fHPMax = enemy->m_Game.m_fHPMax;
			lifeBar->m_strName = std::string( EnemyConsts::ENEMY_NAME_LIST[ obj->m_Game.m_nType] );
			lifeBar->m_Counter.set_FrameCounterMax( MotionTestConsts::ENEMY_LIFE_BAR_REMAIN_COUNT );
			lifeBar->m_Counter.set_LoopNumMax( 1 );
			lifeBar->m_nSigID = enemy->m_nSigID;
			lifeBar->m_Counter.reset();
			staticData->m_lstEnemyLifeBarList.push_back(lifeBar );
		}

	} //
}

void EnemyManager::destroyAllExceptSpecial() {
	// Gō폜ȂmXg
	int nExceptEnemyList[] = {
		EnemyType::TROL,
		EnemyType::ZOMBIE_A,
		EnemyType::ROPER,
	};
	int nExceptEnemyNum = sizeof(nExceptEnemyList) / sizeof(int);
	// IuWFNg̏
	this->destroyAll( nExceptEnemyList, nExceptEnemyNum );
}

}
