#include "Weapon.h"

namespace MotionTest {
using namespace HPL;
using namespace E3D;

Weapon::Weapon():E3DObject() {
	this->m_Game.m_nType = 0;
	this->m_nSigID = -1;
	this->set_Valid( FALSE );
//	this->set_Type(0);
//	this->set_SigID(-1);
	this->set_SpriteID(-1);
//	this->set_Enable( FALSE );
	this->set_Error( 0 );
}
Weapon::~Weapon() {
}

void Weapon::set_Type(int nType ) {
	this->m_Game.m_nType = nType;

	//this->m_nSigID = -1;
	//this->m_nSpriteID = -1;

	m_nShotAutomaticInterval = 20;
	this->set_Error( 10.f );
	this->m_nLoadedAmmoMax = 4;
	this->m_nChargedAmmoMax = 32;
	this->m_nItemAmmo = 4;

	if( nType == WeaponType::MINI_GUN ) {
		m_nShotAutomaticInterval = 2;
		this->set_Error( 10.f );
		this->m_nLoadedAmmoMax = 200;
		this->m_nChargedAmmoMax = 2400;
		this->m_nItemAmmo = 200;

	} else if( nType == WeaponType::MACHINE_GUN ) {
		m_nShotAutomaticInterval = 6;
		this->set_Error( 8.f );
		this->m_nLoadedAmmoMax = 80;
		this->m_nChargedAmmoMax = 2400;
		this->m_nItemAmmo = 120;

	} else if( nType == WeaponType::MISSILE_LAUNCHER ) {
		m_nShotAutomaticInterval = 20;
		this->set_Error( 2 );
		this->m_nLoadedAmmoMax = 2;
		this->m_nChargedAmmoMax = 10;
		this->m_nItemAmmo = 2;

	} else if( nType == WeaponType::HAND_GUN ) {
		m_nShotAutomaticInterval = 20;
		this->set_Error( 0 );
		this->m_nLoadedAmmoMax = 8;
		this->m_nChargedAmmoMax = 6000;
		this->m_nItemAmmo = 24;

	} else if( nType == WeaponType::GRANADE_LAUNCHER) {
		m_nShotAutomaticInterval = 20;
		this->set_Error( 10.f );
		this->m_nLoadedAmmoMax = 4;
		this->m_nChargedAmmoMax = 32;
		this->m_nItemAmmo = 4;

	} else if( nType == WeaponType::CROWBAR) {
		// unused

	} else if( nType == WeaponType::FIST ) {
		// unused
	} else if( nType == WeaponType::MOPPU ) {
		// unused
	} 
	this->resetFirst();


}
/*int Weapon::get_Type() {
	return this->m_nType;
}
void Weapon::set_SigID(int nSigID) {
	this->m_nSigID = nSigID;
}
int Weapon::get_SigID() {
	return this->m_nSigID;
}*/
int Weapon::get_SpriteID() {
	return this->m_nSpriteID;
}
void Weapon::set_SpriteID(int nSpriteID ) {
	this->m_nSpriteID = nSpriteID;
}
/*void Weapon::set_Enable( BOOL bEnable ) {
	this->m_bEnable = bEnable;
}
BOOL Weapon::is_Enable() {
	return this->m_bEnable;
}*/
void Weapon::set_Error( float fError ) {
	this->m_fError = fError;
}
float Weapon::get_Error( ) {
	return this->m_fError;
}
int Weapon::set_LoadedAmmo( int nNewAmmo ) {
	if( nNewAmmo > m_nLoadedAmmoMax ) {
		nNewAmmo = m_nLoadedAmmoMax;
	} else if( nNewAmmo < 0 ) {
		nNewAmmo = 0;
	}
	this->m_nLoadedAmmo = nNewAmmo;
	return nNewAmmo;

}
int Weapon::set_ChargedAmmo( int nNewAmmo ) {
	if( nNewAmmo > m_nChargedAmmoMax ) {
		nNewAmmo = m_nChargedAmmoMax;
	} else if( nNewAmmo < 0 ) {
		nNewAmmo = 0;
	}
	this->m_nChargedAmmo = nNewAmmo;
	return nNewAmmo;
}
int Weapon::get_LoadedAmmo() {
	return this->m_nLoadedAmmo;
}
int Weapon::get_ChargedAmmo() {
	return this->m_nChargedAmmo;
}
int Weapon::get_LoadedAmmoMax() {
	return this->m_nLoadedAmmoMax;
}
int Weapon::get_ChargedAmmoMax() {
	return this->m_nChargedAmmoMax;
}
int Weapon::get_ItemAmmo() {
	return this->m_nItemAmmo;
}
void Weapon::resetFirst() {
	this->m_nChargedAmmo = 0;
	this->m_nLoadedAmmo = this->m_nLoadedAmmoMax;
}

}


