////////////////////////////////////////////////////////////////////////////////
// CMQOData.cpp
// 2004N1019 12:59:46
///////////////////////////////////////////////////////////////////////////////

#include "../MQOLib/CMQOData.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

CMQOData::CMQOData()
{
	strcpy( mVersion, "" );
	memset( &mHeader, 0, sizeof(MQOHeaderData) );

	mMaterialData = NULL;
	mMaterialNum = 0;

	mObjectNum = 0;
}

CMQOData::~CMQOData()
{
	Release();
}

void CMQOData::Release()
{
	ReleaseMaterial();
	ReleaseObject();
}

void CMQOData::SetVersion( const char* version )
{
	strcpy( mVersion, version );
}

void CMQOData::SetHeader( const MQOHeaderData* pHeader )
{
	memcpy( &mHeader, pHeader, sizeof(MQOHeaderData) );
}

bool CMQOData::CreateMaterial( int num )
{
	ReleaseMaterial();

	mMaterialData = new MQOMaterialData [num];
	
	if( !mMaterialData ){
		return false;
	}
	memset( mMaterialData, 0, sizeof(MQOMaterialData)*num );

	mMaterialNum = num;
	return true;
}

bool CMQOData::SetMaterial( int index, const MQOMaterialData* pMaterial )
{
	if( index < 0 || index >= mMaterialNum )return false;
	memcpy( &mMaterialData[index], pMaterial, sizeof(MQOMaterialData) );
	return true;
}

bool CMQOData::SetObject( CMQOObjectData* pObjectData )
{
	
	CMQOObjectData tmpData;
	MQOObjectInfo  tmpInfo;
	memcpy( &tmpInfo, pObjectData->GetInfo(), sizeof(MQOObjectInfo) );
	tmpData.SetInfo( &tmpInfo );
	
	mObjectNum++;
	mObjectList.AddTail( &tmpData );
	mObjectList.SeekTop();
	while( 1 ){
		CMQOObjectData* pData = mObjectList.GetData();
		if( !pData )break;
		const MQOObjectInfo* pInfo = pData->GetInfo();
		if( strcmp( pInfo->ObjectName, tmpInfo.ObjectName) == 0 ){
			int VertexNum = pObjectData->GetVertexNum();
			const MQOObjectVertex* pVertex = pObjectData->GetVertex();

			pData->CreateVertex( VertexNum );
			for( int i = 0 ; i < VertexNum ; i++, pVertex++ ){
				pData->SetVertex( i, pVertex );
			}

			int FaceNum = pObjectData->GetFaceNum();
			const MQOObjectFace* pFace = pObjectData->GetFace();
			pData->CreateFace( FaceNum );
			for( int i = 0 ; i < FaceNum ; i++, pFace++ ){
				pData->SetFace( i, pFace );
			}

			return true;
		}

		if( !mObjectList.Next() )break;
	}

	return false;
}


int CMQOData::GetMaterialNum()
{
	return mMaterialNum;
}

const MQOMaterialData* CMQOData::GetMaterial( int idx )
{
	if( idx < 0 || idx >= mMaterialNum )return NULL;

	return &mMaterialData[idx];
}

int CMQOData::GetObjectNum()
{
	return mObjectNum;
}

CMQOObjectData* CMQOData::GetObject( int idx )
{
	if( idx < 0 || idx >= mObjectNum )return NULL;
	mObjectList.SeekTop();
	for( int i = 0 ; i < idx ; i++ ){
		if( !mObjectList.Next() )return NULL;
	}
	CMQOObjectData* pObject = mObjectList.GetData();
	return pObject;
}

void CMQOData::DebugPrint()
{
	//printf( "Version[%s]\n", mVersion);

	//printf( "Header\n");
	//printf( "\tPos[%.4f, %.4f, %.4f]\n", mHeader.Pos[0], mHeader.Pos[1], mHeader.Pos[2]);
	//printf( "\tLookat[%.4f, %.4f, %.4f]\n", mHeader.Lookat[0], mHeader.Lookat[1], mHeader.Lookat[2]);
	//printf( "\tHead[%.4f]\n", mHeader.Head );
	//printf( "\tPich[%.4f]\n", mHeader.Pich );
	//printf( "\tOrtho[%.4f]\n", mHeader.Ortho );
	//printf( "\tZoom2[%.4f]\n", mHeader.Zoom2 );
	//printf( "\tAmb[%.4f, %.4f, %.4f]\n", mHeader.Amb[0], mHeader.Amb[1], mHeader.Amb[2]);
	
	//printf( "Material %d\n", mMaterialNum );
	for( int i = 0 ; i < mMaterialNum ; i++ ){
		//printf( "\tMaterilaName[%s]\n", mMaterialData[i].MaterilaName );
		//printf( "\tColor[%.4f, %.4f, %.4f]Diffuse[%.4f]\n", mMaterialData[i].Color[0], mMaterialData[i].Color[1], mMaterialData[i].Color[2], mMaterialData[i].Diffuse );
	}

	//printf( "Object\n" );
	mObjectList.SeekTop();
	while( 1 ){
		CMQOObjectData* pData = mObjectList.GetData();
		if( !pData )break;
		const MQOObjectInfo* pInfo = pData->GetInfo();
		//printf( "\tObjectName[%s]\n", pInfo->ObjectName );
		//printf( "\tVisible[%d]\n", pInfo->Visible );
		//printf( "\tLocking[%d]\n", pInfo->Locking );
		//printf( "\tShading[%d]\n", pInfo->Shading );
		//printf( "\tFacet[%.4f]\n", pInfo->Facet );
		//printf( "\tColor[%.4f, %.4f, %.4f]\n", pInfo->Color[0], pInfo->Color[1], pInfo->Color[2] );
		//printf( "\tColorType[%d]\n", pInfo->ColorType );

		//printf( "\tVertexNum[%d]\n", pData->GetVertexNum() );
		//printf( "\tFaceNum[%d]\n", pData->GetFaceNum() );

		mObjectList.Next();
	}
}

void CMQOData::ReleaseMaterial()
{
	if( mMaterialData ){
		delete [] mMaterialData;
	}
	mMaterialData = NULL;
	mMaterialNum  = 0;
}

void CMQOData::ReleaseObject()
{
	mObjectList.SeekTop();
	while( 1 ){
		CMQOObjectData* pData = mObjectList.GetData();
		if( !pData )break;
		pData->Release();
		mObjectList.Delete();
		if( !mObjectList.Next() )break;
	}
	mObjectNum = 0;
}


CMQOObjectData::CMQOObjectData()
{
	memset( &mInfo, 0, sizeof(MQOObjectInfo) );
	mVertex = NULL;
	mFace = NULL;
	mVertexNum = 0;
	mFaceNum = 0;
}

CMQOObjectData::~CMQOObjectData()
{
	Release();
}

void CMQOObjectData::Release()
{
	if( mVertex )delete [] mVertex;
	if( mFace )delete [] mFace;
	memset( &mInfo, 0, sizeof(MQOObjectInfo) );
	mVertex = NULL;
	mFace = NULL;
	mVertexNum = 0;
	mFaceNum = 0;
}

void CMQOObjectData::SetInfo( const MQOObjectInfo* pInfo )
{
	memcpy( &mInfo, pInfo, sizeof(MQOObjectInfo) );
}

bool CMQOObjectData::CreateVertex( int num )
{
	mVertex = new MQOObjectVertex[num];
	
	if( !mVertex ){
		return false;
	}
	memset( mVertex, 0, sizeof(MQOObjectVertex)*num );

	mVertexNum = num;
	return true;
}

bool CMQOObjectData::CreateFace( int num )
{
	mFace = new MQOObjectFace[num];
	
	if( !mFace ){
		return false;
	}
	memset( mFace, 0, sizeof(MQOObjectFace)*num );

	mFaceNum = num;
	return true;
}

void CMQOObjectData::SetVertex( int n, const MQOObjectVertex* pVertex )
{
	if( !mVertex )return;
	if( n >= mVertexNum )return;
	memcpy( &mVertex[n], pVertex, sizeof(MQOObjectVertex) );
}

void CMQOObjectData::SetFace( int n, const MQOObjectFace* pFace )
{
	if( !mFace )return;
	if( n >= mFaceNum )return;
	memcpy( &mFace[n], pFace, sizeof(MQOObjectFace) );
}

float GetMaxSize( CMQOData* pMqoData )
{
	int n = pMqoData->GetObjectNum();
	float max_size = 0.0f;
	for( int i = 0 ; i < n ; i++ ){
		CMQOObjectData* pObject = pMqoData->GetObject( i );
		if( !pObject )continue;
		int v_num = pObject->GetVertexNum();
		const MQOObjectVertex* vertex = pObject->GetVertex();
		for( int j = 0 ; j < v_num ; j++ ){
			float v[3];
			v[0] = vertex[j].x;
			v[1] = vertex[j].y;
			v[2] = vertex[j].z;
			for( int k = 0 ; k < 3 ; k++ ){
				float f = (float)fabs( v[k] );
				if( f > max_size ){
					max_size = f;
				}
			}
		}
	}

	return max_size;
}

