////////////////////////////////////////////////////////////////////////////////
// CTextBuffer.cpp
// 2004N910 22:25:45
///////////////////////////////////////////////////////////////////////////////

#include "../MQOLib/CTextBuffer.h"
#include <stdio.h>

////////////////////////////////////////////////////////////////////////////////
// CTextBuffer::CTextBuffer
// RXgN^
////////////////////////////////////////////////////////////////////////////////
CTextBuffer::CTextBuffer()
{
	mBuffer = NULL;
	mCurrent = NULL;
}

////////////////////////////////////////////////////////////////////////////////
// CTextBuffer::~CTextBuffer
// fXgN^
////////////////////////////////////////////////////////////////////////////////
CTextBuffer::~CTextBuffer()
{
	Release();
}

////////////////////////////////////////////////////////////////////////////////
// CTextBuffer::Open
// t@C̑SĂ̓ẽobt@ɓǂݍ
// in : const char* path t@CpX
// out: true  t@C̓ǂݍ݂ɐ
//      false t@C̓ǂݍ݂Ɏs
////////////////////////////////////////////////////////////////////////////////
bool CTextBuffer::Open( const char* path )
{
	FILE* fp = fopen( path, "r" );
	bool bResult = true;
	try
	{
		unsigned long Size = 0;
		{
			while( fgetc(fp) != EOF )Size++;
			Size++;
			fseek( fp, 0, SEEK_SET );
		}		
		mBuffer = new char [Size];
		if( !mBuffer )throw;
		
		{
			char* ptr = mBuffer;
			while( (*ptr = fgetc(fp)) != EOF )ptr++;
			*ptr = '\0';
		}
		
		SeekTop();
	}
	catch( ... )
	{
		bResult = false;
	}
	fclose( fp );
	
	return bResult;
}

////////////////////////////////////////////////////////////////////////////////
// CTextBuffer::Release
// ej
////////////////////////////////////////////////////////////////////////////////
void CTextBuffer::Release()
{
	if( mBuffer )
	{
		delete [] mBuffer;
	}
	mBuffer = NULL;
	mCurrent = NULL;
}

////////////////////////////////////////////////////////////////////////////////
// CTextBuffer::SeekTop
////////////////////////////////////////////////////////////////////////////////
bool CTextBuffer::SeekTop()
{
	if( !mBuffer )return false;
	mCurrent = mBuffer;
	return true;
}

////////////////////////////////////////////////////////////////////////////////
// CTextBuffer::GetLine
// sobt@ɃRs[
// in  : char* pBuffer s̓eRs[obt@ւ̃|C^
// out :  0` s̕
//       -1   s
////////////////////////////////////////////////////////////////////////////////
int CTextBuffer::GetLine( char* pBuffer )
{
	if( !mCurrent )return -1;
	if( !mBuffer )return -1;

	char* ptr = pBuffer;
	int Length = 0;
	while( 1 )
	{
		if( *mCurrent == '\0' )
		{
			mCurrent = NULL;
			break;
		}
		if( *mCurrent == '\r' )
		{
			mCurrent++;
			continue;
		}
		if( *mCurrent == '\n' )
		{
			mCurrent++;
			break;
		}

		*ptr = *mCurrent;
		mCurrent++;
		ptr++;
		Length++;
	}

	*ptr = '\0';

	return Length;

}
