#include "game/GStaticData.h"
#include "scene/GTitleScene.h"

#ifdef _DEV_CPP_
#undef main
#endif
GStaticData* staticData = NULL;


int main(int argc, char** argv){

	staticData = new GStaticData();

	///////////
	// V[쐬
	staticData->setupWindow();
	Mix_Volume(-1,64);

	GPlayer* player = staticData->getObjectManager()->getPlayer();
	player->setCenter(100,400);
	player->groundY = player->getCenter().getY();

	// create enemies
	HPLVector cen(300,250);
	GEnemy* en = staticData->getObjectManager()->getEnemyManager()->create(EnemyType::Ramia,
		cen);
	en->changeState(StateType::ATTACK);

	cen.set(100,300);
	en = staticData->getObjectManager()->getEnemyManager()->create(EnemyType::Kikai,
		cen);
	en->changeState(StateType::ATTACK);

	cen.set(400,200);
	en = staticData->getObjectManager()->getEnemyManager()->create(EnemyType::Shokushu,
		cen);
	en->changeState(StateType::ATTACK);

	HPLSceneManager* sceneManager = staticData->getSceneManager();

	//^Cg
	sceneManager->putScene(GEnum::SceneType::Title, new GTitleScene());
	sceneManager->setScene(GEnum::SceneType::Title);
	
	//////
	// }bvǂݍ
	//staticData->setupMap(0);


	while(staticData->isRunning()){

		sceneManager->processScene();
		
		staticData->processFadeOut();

		// event
		staticData->doEvent();

		// common
		staticData->doCommonLoopProcess();
	}

	delete staticData;

	return 0;
}
