// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ArithmeticExpressionNode.cs,v 1.4 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// Zp̃m[h\NXłB
	/// </summary>
	public class ArithmeticExpressionNode : Node
	{
		/// <summary>
		/// m[h̃Xg
		/// </summary>
		private ArrayList nodeList = new ArrayList();
		/// <summary>
		/// Z̎ނ\LN^̃Xg
		/// </summary>
		private ArrayList opCharList = new ArrayList();

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			Node node = new ArithmeticTermNode();
			node.Parse(context);
			nodeList.Add(node);
			ContextToken ct = (ContextToken)context.Current;
			string token = ct.ToString();
			while(token == "+" || token == "-")
			{
				context.MoveNext();
				node = new ArithmeticTermNode();
				node.Parse(context);
				nodeList.Add(node);
				opCharList.Add(token[0]);
				ct = (ContextToken)context.Current;
				token = ct.ToString();
			}
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			if(nodeList.Count == 1)
				return ((Node)nodeList[0]).Simplify();
			else
			{
				for(int i = 0; i < nodeList.Count; i++)
				{
					Node node = (Node)nodeList[i];
					nodeList[i] = node.Simplify();
				}
				return this;
			}
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			try 
			{
				Node node = (Node)nodeList[0];
				Value val1 = node.Execute(resource, at);
				for(int i = 1; i < nodeList.Count; i++)
				{
					node = (Node)nodeList[i];
					Value val2 = node.Execute(resource, at);

					char op = (char)opCharList[i - 1];
					if(op == '+')
						val1 = val1 + val2;
					else
						val1 = val1 - val2;
				}

				return val1;
			}
			catch(RuntimeException exc)
			{
				if (exc.ContextToken == null)
					exc = new RuntimeException(exc.Message, this.ContextToken);
				throw exc;
			}
		}
	}
}
