﻿// Copyright (C) 2008, 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Token.cs 455 2013-06-08 11:52:33Z panacoran $

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 字句の型を表す列挙型。
    /// </summary>
    public enum TokenType
    {
        /// <summary>
        /// 整数
        /// </summary>
        Int,

        /// <summary>
        /// 浮動小数点
        /// </summary>
        Float,

        /// <summary>
        /// 文字列
        /// </summary>
        String,

        /// <summary>
        /// ローカル変数の名前
        /// </summary>
        LocalVariable,

        /// <summary>
        /// グローバル変数の名前
        /// </summary>
        GlobalVariable,

        /// <summary>
        /// 関数の名前
        /// </summary>
        FunctionName,

        /// <summary>
        /// 予約語
        /// </summary>
        Reserved,

        /// <summary>
        /// 型名
        /// </summary>
        Type,

        /// <summary>
        /// 演算子
        /// </summary>
        Operator,

        /// <summary>
        /// その他
        /// </summary>
        Unknown,

        /// <summary>
        /// ファイルの終端
        /// </summary>
        EOF,
    }

    /// <summary>
    /// 字句を表すクラス。
    /// </summary>
    public class Token
    {
        /// <summary>
        /// 字句の型を取得または設定する。
        /// </summary>
        public TokenType Type { get; set; }

        /// <summary>
        /// 行番号を取得または設定する。
        /// </summary>
        public int LineNo { get; set; }

        /// <summary>
        /// ファイル名を取得または設定する。
        /// </summary>
        public string Filename { get; set; }

        /// <summary>
        /// 字句を表す文字列を取得または設定する。
        /// </summary>
        public string Value { get; set; }

        /// <summary>
        /// 字句の表す整数を取得または設定する。
        /// </summary>
        public int IntValue { get; set; }

        /// <summary>
        /// 字句の表す浮動小数点を取得または設定する。
        /// </summary>
        public double FloatValue { get; set; }

        /// <summary>
        /// 次の字句を取得または設定する。
        /// </summary>
        public Token Next { get; set; }
    }
}