﻿// Copyright (C) 2003, 2004 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2005, 2007, 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MainForm.cs 405 2010-12-09 06:26:20Z panacoran $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Protra.Lib;
using Protra.Lib.Config;
using Protra.Lib.Data;

namespace PtSim
{
    /// <summary>
    /// メインフォーム
    /// </summary>
    public partial class MainForm : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MainForm()
        {
            InitializeComponent();

            // 設定ファイルをロードする。
            (GlobalEnv.PtSimConfig = new PtSimConfig()).Load();
            (GlobalEnv.UpdateConfig = new UpdateConfig()).Load();
            (GlobalEnv.BrandData = new Protra.Lib.Data.BrandData()).Load();
            (GlobalEnv.BrandListConfig = new BrandListConfig()).Load();

            BrandListInit();
            // 前回選択されていた銘柄リストを選択する。
            foreach (var bl in GlobalEnv.BrandListConfig.List)
                if (GlobalEnv.PtSimConfig.BrandListName == bl.Name)
                {
                    comboBoxBrandList.SelectedItem = bl;
                    break;
                }
            if (GlobalEnv.PtSimConfig.Mode == 1)
                radioButtonWeekly.PerformClick();

            dateTimePickerMin.Value = DateTime.Now.AddMonths(-1); //履歴の開始を1ヶ月前に設定する。
            ptFileTreeView.Root = Global.DirSystem; // システム一覧を更新する。
            ptFileTreeView.CheckedPaths = GlobalEnv.PtSimConfig.CheckedEntries; // チェックボックスの状態を復元する。

            // 実行できないボタンを無効にする。
            EnableButtons(comboBoxBrandList.SelectedItem != null && ptFileTreeView.CheckedFiles.Count > 0);
            deleteLogToolStripMenuItem.Enabled = ptFileTreeView.CheckedFiles.Count > 0;

            GlobalEnv.UpdateConfig.SetWatcher(null);
            GlobalEnv.BrandListConfig.SetWatcher(BrandListInit);

            // 先頭のカラムでソートされる状態にする。
            listViewProfitBrand.SetSortColumn(0);
            listViewTrade.SetSortColumn(0);
            listViewHistory.SetSortColumn(0);
        }

        /// <summary>
        /// メインエントリポイント
        /// </summary>
        [STAThread]
        public static void Main()
        {
            if (Win32API.ProcessAlreadyExists())
                return;
            Application.EnableVisualStyles();
            Application.Run(new MainForm());
        }

        private void BrandListInit()
        {
            var item = (Protra.Lib.Config.BrandList)comboBoxBrandList.SelectedItem;
            SuspendLayout();
            comboBoxBrandList.Items.Clear();
            foreach (var bl in GlobalEnv.BrandListConfig.List)
            {
                comboBoxBrandList.Items.Add(bl);
                if (item != null && item.Name == bl.Name)
                    comboBoxBrandList.SelectedItem = bl;
            }
            if (comboBoxBrandList.SelectedItem == null &&
                comboBoxBrandList.Items.Count > 0)
                comboBoxBrandList.SelectedIndex = 0;
            ResumeLayout();
        }

        private void EnableButtons(bool enable)
        {
            buttonExecute.Enabled = enable;
            buttonHistory.Enabled = enable;
            buttonCalc.Enabled = enable;
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            ConfigWrite();
        }

        /// <summary>
        /// 設定ファイルを書き込む。
        /// </summary>
        private void ConfigWrite()
        {
            var p = GlobalEnv.PtSimConfig;
            p.Mode = radioButtonDaily.Checked ? 0 : 1;
            var item = (BrandList)comboBoxBrandList.SelectedItem;
            p.BrandListName = item != null ? item.Name : null;
            p.CheckedEntries = ptFileTreeView.CheckedPaths;
            p.Save();
        }

        private void MainForm_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.F5 || (e.KeyCode == Keys.R && e.Control))
                ptFileTreeView.Root = Global.DirSystem;
        }

        private void buttonExecute_Click(object sender, EventArgs e)
        {
            textBoxExecute.AppendText("-- checked paths\n");
            foreach (var s in ptFileTreeView.CheckedPaths)
                textBoxExecute.AppendText(s + "\n");
            textBoxExecute.AppendText("-- checked files\n");
            foreach (var s in ptFileTreeView.CheckedFiles)
                textBoxExecute.AppendText(s + "\n");
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void ptFileTreeView_AfterCheck(object sender, TreeViewEventArgs e)
        {
            EnableButtons(ptFileTreeView.CheckedFiles.Count > 0 && comboBoxBrandList.SelectedItem != null);
            deleteLogToolStripMenuItem.Enabled = ptFileTreeView.CheckedFiles.Count > 0;
        }
    }
}
