// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ProfitList.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace PtSim
{
	/// <summary>
	/// ṽXg\NXłB
	/// DateTimeL[ƂProfiti[鐮ς݃XgƂȂ܂B
	/// </summary>
	public class ProfitList
	{
		/// <summary>
		/// tL[ƂṽXg
		/// </summary>
		private SortedList list = new SortedList();

		/// <summary>
		/// RXgN^
		/// </summary>
		public ProfitList() {}

		/// <summary>
		/// őh[_EvZ܂B
		/// </summary>
		/// <returns>
		/// Profit.BookProfitɂ͕뉿ɂvZʁA
		/// Profit.MarketProfitɂ͎ɂvZʂZbg܂B
		/// </returns>
		public Profit MaxDrawDown()
		{
			float ddBook = 0, pBook = 0;
			float ddMarket = 0, pMarket = 0;
			for(int i = 0; i < list.Count; i++)
			{
				Profit profit = (Profit)list.GetByIndex(i);
				if(profit.BookProfit > pBook)
					pBook = profit.BookProfit;
				else if(profit.BookProfit - pBook < ddBook)
					ddBook = profit.BookProfit - pBook;
				if(profit.MarketProfit > pMarket)
					pMarket = profit.MarketProfit;
				else if(profit.MarketProfit - pMarket < ddMarket)
					ddMarket = profit.MarketProfit - pMarket;
			}

			return new Profit(ddBook, ddMarket);
		}

		/// <summary>
		/// ProfitListݐϗvXgɕϊ܂B
		/// </summary>
		public void Accumulate()
		{
			for(int i = 1; i < list.Count; i++)
			{
				Profit p1 = (Profit)list.GetByIndex(i - 1);
				Profit p2 = (Profit)list.GetByIndex(i);
				p2.BookProfit += p1.BookProfit;
				p2.MarketProfit += p1.MarketProfit;
			}
		}

		/// <summary>
		/// t̃Xg擾܂B
		/// </summary>
		/// <returns>t̃XgłB</returns>
		public DateTime[] GetDateList()
		{
			ArrayList array = new ArrayList(list.GetKeyList());
			return (DateTime[])array.ToArray(typeof(DateTime));
		}

		/// <summary>
		/// w肳ꂽt̗v擾܂͐ݒ肵܂B
		/// </summary>
		public Profit this[DateTime date]
		{
			get
			{
				if(! list.ContainsKey(date))
					list.Add(date, new Profit());
				return (Profit)list[date];
			}
			set { list[date] = value; }
		}

		/// <summary>
		/// w肳ꂽCfbNX̗v擾܂B
		/// </summary>
		public Profit this[int index]
		{
			get { return (Profit)list.GetByIndex(index); }
		}

		/// <summary>
		/// vf̐擾܂B
		/// </summary>
		public int Count
		{
			get { return list.Count; }
		}

		/// <summary>
		/// ő̓t擾܂B
		/// </summary>
		public DateTime MaxDate
		{
			get
			{
				if(list.Count > 0)
					return (DateTime)list.GetKeyList()[list.Count - 1];
				else
					return new DateTime();
			}
		}

		/// <summary>
		/// ŏ̓t擾܂B
		/// </summary>
		public DateTime MinDate
		{
			get
			{
				if(list.Count > 0)
					return (DateTime)list.GetKeyList()[0];
				else
					return new DateTime();
			}
		}
	}

	/// <summary>
	/// v\NXłB
	/// </summary>
	public class Profit
	{
		/// <summary>
		/// 뉿ɂ闘v
		/// </summary>
		public float BookProfit;
		/// <summary>
		/// ɂ闘v
		/// </summary>
		public float MarketProfit;

		/// <summary>
		/// RXgN^
		/// </summary>
		public Profit() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="bookProfit">뉿ɂ闘v</param>
		/// <param name="marketProfit">ɂ闘v</param>
		public Profit(float bookProfit, float marketProfit)
		{
			BookProfit = bookProfit;
			MarketProfit = marketProfit;
		}
	}
}
