// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ProgramNode.cs,v 1.5 2008-03-30 16:06:42 panacoran Exp $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vÕm[h\NXB
	/// </summary>
	public class ProgramNode : Node
	{
		/// <summary>
		/// m[h̃Xg
		/// </summary>
		private List<Node> nodeList = new List<Node>();

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
            Token = Scanner.Token;
			while (Scanner.Scan())
			{
				if (Scanner.Token.Value == "def")
					nodeList.Add(new FunctionDefinitionNode().Parse());
				else
					nodeList.Add(new StatementNode().Parse());
			}
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
            resource.Stack.Push(new Value[Node.LvtStack.Peek().Count]);
			try
			{
				foreach(Node node in nodeList)
					node.Execute(resource, at);
			}
			catch(ReturnStatementExecutedException e)
			{
				resource.Stack.Pop();
				return e.Value;
			}
			catch(BreakStatementExecutedException)
			{
				throw new RuntimeException("unexpected break", Token);
			}
			catch(ContinueStatementExecutedException)
			{
				throw new RuntimeException("unexpected continue", Token);
			}
			resource.Stack.Pop();
			return null;
		}
	}
}
