// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FavoriteBrandItem.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using Protra.Lib.Db;

namespace Protra
{
	/// <summary>
	/// CɓListBox̃ACełB
	/// </summary>
	public class FavoriteBrandItem
	{
		/// <summary>
		/// 
		/// </summary>
		private Brand brand;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="brand"></param>
		public FavoriteBrandItem(Brand brand)
		{
			this.brand = brand;
		}

		/// <summary>
		/// 擾܂B
		/// </summary>
		public Brand Brand
		{
			get { return brand; }
		}

		/// <summary>
		/// rs܂B
		/// </summary>
		/// <param name="o">IuWFNg</param>
		/// <returns>rʂłB</returns>
		public override bool Equals(object o)
		{
			if(o is FavoriteBrandItem)
			{
				FavoriteBrandItem obj = (FavoriteBrandItem)o;
				return brand.Id == obj.brand.Id;
			}

			return false;
		}

		/// <summary>
		/// nbVlvZ܂B
		/// </summary>
		/// <returns>nbVlłB</returns>
		public override int GetHashCode()
		{
			return brand.GetHashCode();
		}

		/// <summary>
		/// \߂܂B
		/// </summary>
		/// <returns>\łB</returns>
		public override string ToString()
		{
			return brand.Code + " " + brand.Market.Name + " " + brand.Name;
		}
	}
}
