// Copyright (C) 2003, 2004 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2005, 2007, 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MainForm.cs 283 2010-03-05 22:15:12Z panacoran $

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using Protra.Lib;
using Protra.Lib.Controls;
using Protra.Lib.Db;
using Protra.Lib.Dialogs;
using PtSim.Dialogs;

namespace PtSim
{
    /// <summary>
    /// AvP[ṼCtH[łB
    /// </summary>
    public class MainForm : System.Windows.Forms.Form
    {
        /// <summary>
        /// őOʂ̃EBhEZbg܂B
        /// </summary>
        [DllImport("user32.dll")]
        private static extern int SetForegroundWindow(int hwnd);

        private ConfigFile configFile = new ConfigFile("ptsimenv");

        private System.Windows.Forms.MainMenu mainMenu;
        private System.Windows.Forms.MenuItem menuItemLog;
        private System.Windows.Forms.MenuItem menuItemLogDelete;
        private System.Windows.Forms.MenuItem menuItemLogAllDelete;
        private System.Windows.Forms.MenuItem menuItemBrandList;
        private System.Windows.Forms.MenuItem menuItemBrandListEdit;
        private System.Windows.Forms.MenuItem menuItemHelp;
        private System.Windows.Forms.MenuItem menuItemMan;
        private System.Windows.Forms.MenuItem menuItemVersion;
        private System.Windows.Forms.Panel panelLeft;
        private System.Windows.Forms.Panel panelSelect;
        private System.Windows.Forms.Label labelMode;
        private System.Windows.Forms.Label labelBrandList;
        private System.Windows.Forms.RadioButton radioButtonDaily;
        private System.Windows.Forms.RadioButton radioButtonWeekly;
        private System.Windows.Forms.ComboBox comboBoxBrandList;
        private System.Windows.Forms.Splitter splitterLeft;
        private System.Windows.Forms.TabControl tabControl;
        private System.Windows.Forms.TabPage tabPageExecute;
        private System.Windows.Forms.TabPage tabPagePerformance;
        private System.Windows.Forms.TabPage tabPageHistory;
        private System.Windows.Forms.ImageList imageListTab;
        private Protra.Lib.Controls.PtFileTreeView ptFileTreeView;
        private Protra.Lib.Controls.SimulateTextBox simulateTextBox;
        private System.Windows.Forms.Button buttonExecute;
        private System.Windows.Forms.ProgressBar progressBarExecute;
        private System.Windows.Forms.TabControl tabControlPerformance;
        private System.Windows.Forms.TabPage tabPagePerformanceSummery;
        private System.Windows.Forms.TabPage tabPagePerformanceProfitGraph;
        private System.Windows.Forms.RichTextBox richTextBoxPerformanceSummery;
        private PtSim.Controls.ProfitGraphBox profitGraphBox;
        private System.Windows.Forms.Button buttonPerformance;
        private System.Windows.Forms.ProgressBar progressBarPerformance;
        private PtSim.Controls.ListViewEx listViewHistory;
        private System.Windows.Forms.ColumnHeader columnHeaderHistoryDate;
        private System.Windows.Forms.ColumnHeader columnHeaderHistoryCode;
        private System.Windows.Forms.ColumnHeader columnHeaderHistoryName;
        private System.Windows.Forms.ColumnHeader columnHeaderHistoryPrice;
        private System.Windows.Forms.ColumnHeader columnHeaderHistoryNumber;
        private System.Windows.Forms.ColumnHeader columnHeaderHistoryOrder;
        private System.Windows.Forms.Label labelDateRange;
        private System.Windows.Forms.Button buttonHistory;
        private System.Windows.Forms.DateTimePicker dateTimePickerHistoryDateMax;
        private System.Windows.Forms.DateTimePicker dateTimePickerHistoryDateMin;
        private System.Windows.Forms.ContextMenu historyContextMenu;
        private System.Windows.Forms.MenuItem copyHistory;
        private BackgroundWorker backgroundWorkerPerformance;
        private BackgroundWorker backgroundWorkerExecute;
        private System.ComponentModel.IContainer components;

        /// <summary>
        /// RXgN^
        /// </summary>
        public MainForm()
        {
            //
            // Windows tH[ fUCi T|[gɕKvłB
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
            //
        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainForm));
            this.mainMenu = new System.Windows.Forms.MainMenu(this.components);
            this.menuItemLog = new System.Windows.Forms.MenuItem();
            this.menuItemLogDelete = new System.Windows.Forms.MenuItem();
            this.menuItemLogAllDelete = new System.Windows.Forms.MenuItem();
            this.menuItemBrandList = new System.Windows.Forms.MenuItem();
            this.menuItemBrandListEdit = new System.Windows.Forms.MenuItem();
            this.menuItemHelp = new System.Windows.Forms.MenuItem();
            this.menuItemMan = new System.Windows.Forms.MenuItem();
            this.menuItemVersion = new System.Windows.Forms.MenuItem();
            this.panelLeft = new System.Windows.Forms.Panel();
            this.ptFileTreeView = new Protra.Lib.Controls.PtFileTreeView();
            this.panelSelect = new System.Windows.Forms.Panel();
            this.labelMode = new System.Windows.Forms.Label();
            this.labelBrandList = new System.Windows.Forms.Label();
            this.comboBoxBrandList = new System.Windows.Forms.ComboBox();
            this.radioButtonDaily = new System.Windows.Forms.RadioButton();
            this.radioButtonWeekly = new System.Windows.Forms.RadioButton();
            this.splitterLeft = new System.Windows.Forms.Splitter();
            this.tabControl = new System.Windows.Forms.TabControl();
            this.tabPageExecute = new System.Windows.Forms.TabPage();
            this.progressBarExecute = new System.Windows.Forms.ProgressBar();
            this.buttonExecute = new System.Windows.Forms.Button();
            this.simulateTextBox = new Protra.Lib.Controls.SimulateTextBox();
            this.tabPagePerformance = new System.Windows.Forms.TabPage();
            this.progressBarPerformance = new System.Windows.Forms.ProgressBar();
            this.buttonPerformance = new System.Windows.Forms.Button();
            this.tabControlPerformance = new System.Windows.Forms.TabControl();
            this.tabPagePerformanceSummery = new System.Windows.Forms.TabPage();
            this.richTextBoxPerformanceSummery = new System.Windows.Forms.RichTextBox();
            this.tabPagePerformanceProfitGraph = new System.Windows.Forms.TabPage();
            this.profitGraphBox = new PtSim.Controls.ProfitGraphBox();
            this.tabPageHistory = new System.Windows.Forms.TabPage();
            this.buttonHistory = new System.Windows.Forms.Button();
            this.labelDateRange = new System.Windows.Forms.Label();
            this.dateTimePickerHistoryDateMax = new System.Windows.Forms.DateTimePicker();
            this.dateTimePickerHistoryDateMin = new System.Windows.Forms.DateTimePicker();
            this.listViewHistory = new PtSim.Controls.ListViewEx();
            this.columnHeaderHistoryDate = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderHistoryCode = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderHistoryName = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderHistoryPrice = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderHistoryNumber = new System.Windows.Forms.ColumnHeader();
            this.columnHeaderHistoryOrder = new System.Windows.Forms.ColumnHeader();
            this.historyContextMenu = new System.Windows.Forms.ContextMenu();
            this.copyHistory = new System.Windows.Forms.MenuItem();
            this.imageListTab = new System.Windows.Forms.ImageList(this.components);
            this.backgroundWorkerPerformance = new System.ComponentModel.BackgroundWorker();
            this.backgroundWorkerExecute = new System.ComponentModel.BackgroundWorker();
            this.panelLeft.SuspendLayout();
            this.panelSelect.SuspendLayout();
            this.tabControl.SuspendLayout();
            this.tabPageExecute.SuspendLayout();
            this.tabPagePerformance.SuspendLayout();
            this.tabControlPerformance.SuspendLayout();
            this.tabPagePerformanceSummery.SuspendLayout();
            this.tabPagePerformanceProfitGraph.SuspendLayout();
            this.tabPageHistory.SuspendLayout();
            this.SuspendLayout();
            // 
            // mainMenu
            // 
            this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemLog,
            this.menuItemBrandList,
            this.menuItemHelp});
            // 
            // menuItemLog
            // 
            this.menuItemLog.Index = 0;
            this.menuItemLog.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemLogDelete,
            this.menuItemLogAllDelete});
            this.menuItemLog.Text = "VXeO(&L)";
            // 
            // menuItemLogDelete
            // 
            this.menuItemLogDelete.Index = 0;
            this.menuItemLogDelete.Shortcut = System.Windows.Forms.Shortcut.Del;
            this.menuItemLogDelete.Text = "폜(&D)";
            this.menuItemLogDelete.Click += new System.EventHandler(this.menuItemLogDelete_Click);
            // 
            // menuItemLogAllDelete
            // 
            this.menuItemLogAllDelete.Index = 1;
            this.menuItemLogAllDelete.Text = "SVXeO폜(&A)";
            this.menuItemLogAllDelete.Click += new System.EventHandler(this.menuItemLogAllDelete_Click);
            // 
            // menuItemBrandList
            // 
            this.menuItemBrandList.Index = 1;
            this.menuItemBrandList.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemBrandListEdit});
            this.menuItemBrandList.Text = "Xg(&L)";
            // 
            // menuItemBrandListEdit
            // 
            this.menuItemBrandListEdit.Index = 0;
            this.menuItemBrandListEdit.Text = "ҏW(&E)";
            this.menuItemBrandListEdit.Click += new System.EventHandler(this.menuItemBrandListEdit_Click);
            // 
            // menuItemHelp
            // 
            this.menuItemHelp.Index = 2;
            this.menuItemHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemMan,
            this.menuItemVersion});
            this.menuItemHelp.Text = "wv(&H)";
            // 
            // menuItemMan
            // 
            this.menuItemMan.Index = 0;
            this.menuItemMan.Shortcut = System.Windows.Forms.Shortcut.F1;
            this.menuItemMan.Text = "}jA(&M)";
            this.menuItemMan.Click += new System.EventHandler(this.menuItemMan_Click);
            // 
            // menuItemVersion
            // 
            this.menuItemVersion.Index = 1;
            this.menuItemVersion.Text = "o[W(&V)";
            this.menuItemVersion.Click += new System.EventHandler(this.menuItemVersion_Click);
            // 
            // panelLeft
            // 
            this.panelLeft.Controls.Add(this.ptFileTreeView);
            this.panelLeft.Controls.Add(this.panelSelect);
            this.panelLeft.Dock = System.Windows.Forms.DockStyle.Left;
            this.panelLeft.Location = new System.Drawing.Point(0, 0);
            this.panelLeft.Name = "panelLeft";
            this.panelLeft.Size = new System.Drawing.Size(184, 400);
            this.panelLeft.TabIndex = 0;
            // 
            // ptFileTreeView
            // 
            this.ptFileTreeView.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ptFileTreeView.HideSelection = false;
            this.ptFileTreeView.ImageIndex = 0;
            this.ptFileTreeView.Location = new System.Drawing.Point(0, 0);
            this.ptFileTreeView.Name = "ptFileTreeView";
            this.ptFileTreeView.RootDirectory = null;
            this.ptFileTreeView.SelectedImageIndex = 0;
            this.ptFileTreeView.Size = new System.Drawing.Size(184, 308);
            this.ptFileTreeView.TabIndex = 0;
            this.ptFileTreeView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.ptFileTreeView_AfterSelect);
            // 
            // panelSelect
            // 
            this.panelSelect.Controls.Add(this.labelMode);
            this.panelSelect.Controls.Add(this.labelBrandList);
            this.panelSelect.Controls.Add(this.comboBoxBrandList);
            this.panelSelect.Controls.Add(this.radioButtonDaily);
            this.panelSelect.Controls.Add(this.radioButtonWeekly);
            this.panelSelect.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.panelSelect.Location = new System.Drawing.Point(0, 308);
            this.panelSelect.Name = "panelSelect";
            this.panelSelect.Size = new System.Drawing.Size(184, 92);
            this.panelSelect.TabIndex = 1;
            // 
            // labelMode
            // 
            this.labelMode.Location = new System.Drawing.Point(12, 24);
            this.labelMode.Name = "labelMode";
            this.labelMode.Size = new System.Drawing.Size(60, 16);
            this.labelMode.TabIndex = 3;
            this.labelMode.Text = "ԃ[h";
            // 
            // labelBrandList
            // 
            this.labelBrandList.Location = new System.Drawing.Point(12, 56);
            this.labelBrandList.Name = "labelBrandList";
            this.labelBrandList.Size = new System.Drawing.Size(60, 16);
            this.labelBrandList.TabIndex = 2;
            this.labelBrandList.Text = "Xg";
            // 
            // comboBoxBrandList
            // 
            this.comboBoxBrandList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.comboBoxBrandList.Location = new System.Drawing.Point(72, 52);
            this.comboBoxBrandList.Name = "comboBoxBrandList";
            this.comboBoxBrandList.Size = new System.Drawing.Size(104, 20);
            this.comboBoxBrandList.Sorted = true;
            this.comboBoxBrandList.TabIndex = 1;
            this.comboBoxBrandList.SelectedIndexChanged += new System.EventHandler(this.comboBoxBrandList_SelectedIndexChanged);
            // 
            // radioButtonDaily
            // 
            this.radioButtonDaily.Checked = true;
            this.radioButtonDaily.Location = new System.Drawing.Point(72, 20);
            this.radioButtonDaily.Name = "radioButtonDaily";
            this.radioButtonDaily.Size = new System.Drawing.Size(52, 20);
            this.radioButtonDaily.TabIndex = 0;
            this.radioButtonDaily.TabStop = true;
            this.radioButtonDaily.Text = "";
            // 
            // radioButtonWeekly
            // 
            this.radioButtonWeekly.Location = new System.Drawing.Point(124, 20);
            this.radioButtonWeekly.Name = "radioButtonWeekly";
            this.radioButtonWeekly.Size = new System.Drawing.Size(52, 20);
            this.radioButtonWeekly.TabIndex = 1;
            this.radioButtonWeekly.Text = "T";
            // 
            // splitterLeft
            // 
            this.splitterLeft.Enabled = false;
            this.splitterLeft.Location = new System.Drawing.Point(184, 0);
            this.splitterLeft.Name = "splitterLeft";
            this.splitterLeft.Size = new System.Drawing.Size(3, 400);
            this.splitterLeft.TabIndex = 0;
            this.splitterLeft.TabStop = false;
            // 
            // tabControl
            // 
            this.tabControl.Appearance = System.Windows.Forms.TabAppearance.FlatButtons;
            this.tabControl.Controls.Add(this.tabPageExecute);
            this.tabControl.Controls.Add(this.tabPagePerformance);
            this.tabControl.Controls.Add(this.tabPageHistory);
            this.tabControl.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tabControl.ImageList = this.imageListTab;
            this.tabControl.Location = new System.Drawing.Point(187, 0);
            this.tabControl.Name = "tabControl";
            this.tabControl.SelectedIndex = 0;
            this.tabControl.Size = new System.Drawing.Size(363, 400);
            this.tabControl.TabIndex = 1;
            // 
            // tabPageExecute
            // 
            this.tabPageExecute.AutoScroll = true;
            this.tabPageExecute.Controls.Add(this.progressBarExecute);
            this.tabPageExecute.Controls.Add(this.buttonExecute);
            this.tabPageExecute.Controls.Add(this.simulateTextBox);
            this.tabPageExecute.ImageIndex = 0;
            this.tabPageExecute.Location = new System.Drawing.Point(4, 26);
            this.tabPageExecute.Name = "tabPageExecute";
            this.tabPageExecute.Size = new System.Drawing.Size(355, 370);
            this.tabPageExecute.TabIndex = 0;
            this.tabPageExecute.Text = "s";
            // 
            // progressBarExecute
            // 
            this.progressBarExecute.Location = new System.Drawing.Point(92, 340);
            this.progressBarExecute.Name = "progressBarExecute";
            this.progressBarExecute.Size = new System.Drawing.Size(248, 16);
            this.progressBarExecute.TabIndex = 2;
            // 
            // buttonExecute
            // 
            this.buttonExecute.Location = new System.Drawing.Point(8, 336);
            this.buttonExecute.Name = "buttonExecute";
            this.buttonExecute.Size = new System.Drawing.Size(75, 23);
            this.buttonExecute.TabIndex = 1;
            this.buttonExecute.Text = "s";
            this.buttonExecute.Click += new System.EventHandler(this.buttonExecute_Click);
            // 
            // simulateTextBox
            // 
            this.simulateTextBox.BackColor = System.Drawing.SystemColors.Window;
            this.simulateTextBox.Dock = System.Windows.Forms.DockStyle.Top;
            this.simulateTextBox.ForeColor = System.Drawing.SystemColors.WindowText;
            this.simulateTextBox.Location = new System.Drawing.Point(0, 0);
            this.simulateTextBox.MaxLength = 0;
            this.simulateTextBox.Multiline = true;
            this.simulateTextBox.Name = "simulateTextBox";
            this.simulateTextBox.ReadOnly = true;
            this.simulateTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.simulateTextBox.Size = new System.Drawing.Size(355, 320);
            this.simulateTextBox.System = null;
            this.simulateTextBox.TabIndex = 0;
            // 
            // tabPagePerformance
            // 
            this.tabPagePerformance.AutoScroll = true;
            this.tabPagePerformance.Controls.Add(this.progressBarPerformance);
            this.tabPagePerformance.Controls.Add(this.buttonPerformance);
            this.tabPagePerformance.Controls.Add(this.tabControlPerformance);
            this.tabPagePerformance.ImageIndex = 1;
            this.tabPagePerformance.Location = new System.Drawing.Point(4, 26);
            this.tabPagePerformance.Name = "tabPagePerformance";
            this.tabPagePerformance.Size = new System.Drawing.Size(355, 370);
            this.tabPagePerformance.TabIndex = 1;
            this.tabPagePerformance.Text = "ьvZ";
            // 
            // progressBarPerformance
            // 
            this.progressBarPerformance.Location = new System.Drawing.Point(92, 340);
            this.progressBarPerformance.Name = "progressBarPerformance";
            this.progressBarPerformance.Size = new System.Drawing.Size(248, 16);
            this.progressBarPerformance.TabIndex = 2;
            // 
            // buttonPerformance
            // 
            this.buttonPerformance.Location = new System.Drawing.Point(8, 336);
            this.buttonPerformance.Name = "buttonPerformance";
            this.buttonPerformance.Size = new System.Drawing.Size(75, 23);
            this.buttonPerformance.TabIndex = 1;
            this.buttonPerformance.Text = "vZ";
            this.buttonPerformance.Click += new System.EventHandler(this.buttonPerformance_Click);
            // 
            // tabControlPerformance
            // 
            this.tabControlPerformance.Controls.Add(this.tabPagePerformanceSummery);
            this.tabControlPerformance.Controls.Add(this.tabPagePerformanceProfitGraph);
            this.tabControlPerformance.Dock = System.Windows.Forms.DockStyle.Top;
            this.tabControlPerformance.Location = new System.Drawing.Point(0, 0);
            this.tabControlPerformance.Name = "tabControlPerformance";
            this.tabControlPerformance.SelectedIndex = 0;
            this.tabControlPerformance.Size = new System.Drawing.Size(355, 320);
            this.tabControlPerformance.TabIndex = 0;
            // 
            // tabPagePerformanceSummery
            // 
            this.tabPagePerformanceSummery.Controls.Add(this.richTextBoxPerformanceSummery);
            this.tabPagePerformanceSummery.Location = new System.Drawing.Point(4, 21);
            this.tabPagePerformanceSummery.Name = "tabPagePerformanceSummery";
            this.tabPagePerformanceSummery.Size = new System.Drawing.Size(347, 295);
            this.tabPagePerformanceSummery.TabIndex = 0;
            this.tabPagePerformanceSummery.Text = "T}[";
            // 
            // richTextBoxPerformanceSummery
            // 
            this.richTextBoxPerformanceSummery.BackColor = System.Drawing.SystemColors.Window;
            this.richTextBoxPerformanceSummery.Dock = System.Windows.Forms.DockStyle.Fill;
            this.richTextBoxPerformanceSummery.Location = new System.Drawing.Point(0, 0);
            this.richTextBoxPerformanceSummery.Name = "richTextBoxPerformanceSummery";
            this.richTextBoxPerformanceSummery.ReadOnly = true;
            this.richTextBoxPerformanceSummery.Size = new System.Drawing.Size(347, 295);
            this.richTextBoxPerformanceSummery.TabIndex = 0;
            this.richTextBoxPerformanceSummery.Text = "";
            // 
            // tabPagePerformanceProfitGraph
            // 
            this.tabPagePerformanceProfitGraph.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.tabPagePerformanceProfitGraph.Controls.Add(this.profitGraphBox);
            this.tabPagePerformanceProfitGraph.Location = new System.Drawing.Point(4, 21);
            this.tabPagePerformanceProfitGraph.Name = "tabPagePerformanceProfitGraph";
            this.tabPagePerformanceProfitGraph.Size = new System.Drawing.Size(347, 295);
            this.tabPagePerformanceProfitGraph.TabIndex = 1;
            this.tabPagePerformanceProfitGraph.Text = "vȐ";
            // 
            // profitGraphBox
            // 
            this.profitGraphBox.BackColor = System.Drawing.SystemColors.Window;
            this.profitGraphBox.Dock = System.Windows.Forms.DockStyle.Fill;
            this.profitGraphBox.Location = new System.Drawing.Point(0, 0);
            this.profitGraphBox.Name = "profitGraphBox";
            this.profitGraphBox.ProfitList = null;
            this.profitGraphBox.Size = new System.Drawing.Size(343, 291);
            this.profitGraphBox.TabIndex = 0;
            // 
            // tabPageHistory
            // 
            this.tabPageHistory.AutoScroll = true;
            this.tabPageHistory.Controls.Add(this.buttonHistory);
            this.tabPageHistory.Controls.Add(this.labelDateRange);
            this.tabPageHistory.Controls.Add(this.dateTimePickerHistoryDateMax);
            this.tabPageHistory.Controls.Add(this.dateTimePickerHistoryDateMin);
            this.tabPageHistory.Controls.Add(this.listViewHistory);
            this.tabPageHistory.ImageIndex = 2;
            this.tabPageHistory.Location = new System.Drawing.Point(4, 26);
            this.tabPageHistory.Name = "tabPageHistory";
            this.tabPageHistory.Size = new System.Drawing.Size(355, 370);
            this.tabPageHistory.TabIndex = 2;
            this.tabPageHistory.Text = "";
            // 
            // buttonHistory
            // 
            this.buttonHistory.Location = new System.Drawing.Point(260, 336);
            this.buttonHistory.Name = "buttonHistory";
            this.buttonHistory.Size = new System.Drawing.Size(75, 23);
            this.buttonHistory.TabIndex = 4;
            this.buttonHistory.Text = "";
            this.buttonHistory.Click += new System.EventHandler(this.buttonHistory_Click);
            // 
            // labelDateRange
            // 
            this.labelDateRange.Location = new System.Drawing.Point(120, 340);
            this.labelDateRange.Name = "labelDateRange";
            this.labelDateRange.Size = new System.Drawing.Size(20, 16);
            this.labelDateRange.TabIndex = 2;
            this.labelDateRange.Text = "`";
            // 
            // dateTimePickerHistoryDateMax
            // 
            this.dateTimePickerHistoryDateMax.Location = new System.Drawing.Point(140, 336);
            this.dateTimePickerHistoryDateMax.Name = "dateTimePickerHistoryDateMax";
            this.dateTimePickerHistoryDateMax.Size = new System.Drawing.Size(108, 19);
            this.dateTimePickerHistoryDateMax.TabIndex = 3;
            // 
            // dateTimePickerHistoryDateMin
            // 
            this.dateTimePickerHistoryDateMin.Location = new System.Drawing.Point(12, 336);
            this.dateTimePickerHistoryDateMin.Name = "dateTimePickerHistoryDateMin";
            this.dateTimePickerHistoryDateMin.Size = new System.Drawing.Size(108, 19);
            this.dateTimePickerHistoryDateMin.TabIndex = 1;
            // 
            // listViewHistory
            // 
            this.listViewHistory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeaderHistoryDate,
            this.columnHeaderHistoryCode,
            this.columnHeaderHistoryName,
            this.columnHeaderHistoryPrice,
            this.columnHeaderHistoryNumber,
            this.columnHeaderHistoryOrder});
            this.listViewHistory.ContextMenu = this.historyContextMenu;
            this.listViewHistory.Dock = System.Windows.Forms.DockStyle.Top;
            this.listViewHistory.FullRowSelect = true;
            this.listViewHistory.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.listViewHistory.Location = new System.Drawing.Point(0, 0);
            this.listViewHistory.Name = "listViewHistory";
            this.listViewHistory.OwnerDraw = true;
            this.listViewHistory.Size = new System.Drawing.Size(355, 320);
            this.listViewHistory.TabIndex = 0;
            this.listViewHistory.UseCompatibleStateImageBehavior = false;
            this.listViewHistory.View = System.Windows.Forms.View.Details;
            // 
            // columnHeaderHistoryDate
            // 
            this.columnHeaderHistoryDate.Text = "t";
            // 
            // columnHeaderHistoryCode
            // 
            this.columnHeaderHistoryCode.Text = "R[h";
            this.columnHeaderHistoryCode.Width = 40;
            // 
            // columnHeaderHistoryName
            // 
            this.columnHeaderHistoryName.Text = "";
            this.columnHeaderHistoryName.Width = 70;
            // 
            // columnHeaderHistoryPrice
            // 
            this.columnHeaderHistoryPrice.Text = "li(~)";
            // 
            // columnHeaderHistoryNumber
            // 
            this.columnHeaderHistoryNumber.Text = "";
            this.columnHeaderHistoryNumber.Width = 50;
            // 
            // columnHeaderHistoryOrder
            // 
            this.columnHeaderHistoryOrder.Text = "";
            this.columnHeaderHistoryOrder.Width = 40;
            // 
            // historyContextMenu
            // 
            this.historyContextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.copyHistory});
            // 
            // copyHistory
            // 
            this.copyHistory.Index = 0;
            this.copyHistory.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
            this.copyHistory.ShowShortcut = false;
            this.copyHistory.Text = "Rs[(&C)";
            this.copyHistory.Click += new System.EventHandler(this.copyHistory_Click);
            // 
            // imageListTab
            // 
            this.imageListTab.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListTab.ImageStream")));
            this.imageListTab.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListTab.Images.SetKeyName(0, "");
            this.imageListTab.Images.SetKeyName(1, "");
            this.imageListTab.Images.SetKeyName(2, "");
            // 
            // backgroundWorkerPerformance
            // 
            this.backgroundWorkerPerformance.WorkerReportsProgress = true;
            this.backgroundWorkerPerformance.WorkerSupportsCancellation = true;
            this.backgroundWorkerPerformance.DoWork += new System.ComponentModel.DoWorkEventHandler(this.backgroundWorkerPerformance_DoWork);
            this.backgroundWorkerPerformance.RunWorkerCompleted += new System.ComponentModel.RunWorkerCompletedEventHandler(this.backgroundWorkerPerformance_RunWorkerCompleted);
            this.backgroundWorkerPerformance.ProgressChanged += new System.ComponentModel.ProgressChangedEventHandler(this.backgroundWorkerPerformance_ProgressChanged);
            // 
            // backgroundWorkerExecute
            // 
            this.backgroundWorkerExecute.WorkerReportsProgress = true;
            this.backgroundWorkerExecute.WorkerSupportsCancellation = true;
            this.backgroundWorkerExecute.DoWork += new System.ComponentModel.DoWorkEventHandler(this.backgroundWorkerExecute_DoWork);
            this.backgroundWorkerExecute.RunWorkerCompleted += new System.ComponentModel.RunWorkerCompletedEventHandler(this.backgroundWorkerExecute_RunWorkerCompleted);
            this.backgroundWorkerExecute.ProgressChanged += new System.ComponentModel.ProgressChangedEventHandler(this.backgroundWorkerExecute_ProgressChanged);
            // 
            // MainForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.ClientSize = new System.Drawing.Size(550, 400);
            this.Controls.Add(this.tabControl);
            this.Controls.Add(this.splitterLeft);
            this.Controls.Add(this.panelLeft);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.KeyPreview = true;
            this.MaximizeBox = false;
            this.Menu = this.mainMenu;
            this.Name = "MainForm";
            this.Text = "PtSim";
            this.Load += new System.EventHandler(this.MainForm_Load);
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.MainForm_FormClosing);
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(this.MainForm_KeyDown);
            this.panelLeft.ResumeLayout(false);
            this.panelSelect.ResumeLayout(false);
            this.tabControl.ResumeLayout(false);
            this.tabPageExecute.ResumeLayout(false);
            this.tabPageExecute.PerformLayout();
            this.tabPagePerformance.ResumeLayout(false);
            this.tabControlPerformance.ResumeLayout(false);
            this.tabPagePerformanceSummery.ResumeLayout(false);
            this.tabPagePerformanceProfitGraph.ResumeLayout(false);
            this.tabPageHistory.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// ݒt@Cǂݍ݂܂B
        /// </summary>
        private void EnvRead()
        {
            try
            {
                configFile.Read();
            }
            catch
            {
                return;
            }
            try
            {
                // tH[
                if (int.Parse(configFile["Mode"]) == 1)
                    this.radioButtonWeekly.Checked = true;
                BrandList brandList = BrandListTable.GetRecord(int.Parse(configFile["BrandListId"]));
                if (brandList != null)
                {
                    BrandListItem item = new BrandListItem(brandList);
                    this.comboBoxBrandList.SelectedItem = item;
                }
            }
            catch {
                using (var dialog = new ApplicationError())
                {
                    dialog.ErrorMessage = "ݒt@CĂ܂:\n" + configFile.Filename;
                    dialog.ShowDialog();
                }
            }
        }

        /// <summary>
        /// ݒt@C݂܂B
        /// </summary>
        private void EnvWrite()
        {
            // tH[
            int mode = this.radioButtonDaily.Checked ? 0 : 1;
            configFile["Mode"] = mode.ToString();

            object item = this.comboBoxBrandList.SelectedItem;
            if (item != null)
            {
                BrandList brandList = ((BrandListItem)item).BrandList;
                configFile["BrandListId"] = brandList.Id.ToString();
            }

            configFile.Write();
        }

        /// <summary>
        /// V~[Vs܂B
        /// </summary>
        private void Execute(BackgroundWorker worker, DoWorkEventArgs e)
        {
            TradingSystem system = (TradingSystem)((object[])e.Argument)[0];
            Brand[] brands = (Brand[])((object[])e.Argument)[1];

            simulateTextBox.System = system; // \͂sB
            bool isDaily = this.radioButtonDaily.Checked;
            for (int i = 0; i < brands.Length; i++)
            {
                if (worker.CancellationPending)
                {
                    e.Cancel = true;
                    return;
                }
                Brand brand = brands[i];
                Price[] prices;
                if (isDaily)
                    prices = PriceTable.PriceList(brand.Id);
                else
                    prices = PriceTable.WeeklyPriceList(brand.Id);
                this.simulateTextBox.Simulate(prices, worker, e);
                worker.ReportProgress(100 * (i + 1) / brands.Length);
            }
        }

        /// <summary>
        /// тvZ܂B
        /// </summary>
        private string Performance(BackgroundWorker worker, DoWorkEventArgs e)
        {
            TradingSystem system = (TradingSystem)((object[])e.Argument)[0];
            Brand[] brands = (Brand[])((object[])e.Argument)[1];
            string targetName = (string)((object[])e.Argument)[2];

            ProfitList profitList = new ProfitList();
            int allTradeNum = 0;			// Sg[h
            int winTradeNum = 0;			// g[h
            int loseTradeNum = 0;			// g[h
            float allTradeAveRatio = 0;		// Sg[hϗ
            float winTradeAveRatio = 0;		// g[hϗ
            float loseTradeAveRatio = 0;	// g[hϑ
            float winTradeMaxRatio = 0;		// g[hő嗘
            float loseTradeMinRatio = 0;	// g[hő呹
            float allTradeAveSpan = 0;		// Sg[hϊ
            float winTradeAveSpan = 0;		// g[hϊ
            float loseTradeAveSpan = 0;		// g[hϊ
            float allTradeProfit = 0;		// v
            float winTradeProfit = 0;		// g[hv
            float loseTradeProfit = 0;		// g[h
            float allTradeAveProfit = 0;	// Sg[hϗv
            float winTradeAveProfit = 0;	// g[hϗv
            float loseTradeAveProfit = 0;	// g[hϑ
            float winTradeMaxProfit = 0;	// g[hő嗘v
            float loseTradeMinProfit = 0;	// g[hő呹
            float pf = 0;					// vtBbgt@N^[
            float ddBook = 0;				// h[_E(뉿)
            float ddMarket = 0;				// h[_E()
            int currentTradeNum = 0;		// ݐis̃g[h

            bool isDaily = this.radioButtonDaily.Checked;
            for (int i = 0; i < brands.Length; i++)
            {
                Brand brand = brands[i];
                Price[] prices;
                if (isDaily)
                    prices = PriceTable.PriceList(brand.Id);
                else
                    prices = PriceTable.WeeklyPriceList(brand.Id);
                SystemLog[] logs = SystemLogTable.GetRecords(system.Id, brand.Id);

                int index = 0;
                DateTime beginDate = new DateTime(); // g[hJn
                bool isHolding = false; // ۗLĂ邩H
                int holdingNum = 0;     // ۗL
                float buySum = 0;       // ̑a
                float sellSum = 0;      // ̑a
                int prePrice = 0;       // Ỏi
                for (int j = 0; j < prices.Length; j++)
                {
                    if (worker.CancellationPending)
                    {
                        e.Cancel = true;
                        return null;
                    }
                    Profit profit = profitList[prices[j].Date];
                    int price = prices[j].Close;
                    if (isHolding && price > 0 && prePrice > 0)
                    {
                        profit.MarketProfit += holdingNum * (price - prePrice);
                        prePrice = price;
                    }
                    else if (price > 0)
                    {
                        prePrice = price;
                    }

                    if (index < logs.Length && logs[index].Date == prices[j].Date)
                    {
                        SystemLog log = logs[index++];
                        if (log.Order == 0) // 
                        {
                            holdingNum += log.Number;
                            buySum += log.Number * log.Price;
                            profit.MarketProfit += log.Number * (prePrice - log.Price);
                        }
                        else // 
                        {
                            holdingNum -= log.Number;
                            sellSum += log.Number * log.Price;
                            profit.MarketProfit -= log.Number * (prePrice - log.Price);
                        }

                        if (!isHolding) // g[h̊Jn
                        {
                            beginDate = log.Date;
                            isHolding = true;
                        }
                        else if (holdingNum == 0) // g[h̏I
                        {
                            allTradeNum++;
                            float ratio = sellSum / buySum - 1;
                            allTradeAveRatio += ratio;
                            int span = (log.Date - beginDate).Days;
                            allTradeAveSpan += span;
                            float p = sellSum - buySum;
                            profit.BookProfit += p;
                            allTradeProfit += p;
                            if (buySum < sellSum) // 
                            {
                                winTradeNum++;
                                winTradeAveRatio += ratio;
                                if (ratio > winTradeMaxRatio)
                                    winTradeMaxRatio = ratio;
                                winTradeAveSpan += span;
                                winTradeProfit += p;
                                if (p > winTradeMaxProfit)
                                    winTradeMaxProfit = p;
                            }
                            else // 
                            {
                                if (ratio < loseTradeMinRatio)
                                    loseTradeMinRatio = ratio;
                                if (p < loseTradeMinProfit)
                                    loseTradeMinProfit = p;
                            }

                            isHolding = false;
                            buySum = sellSum = 0;
                        }
                    }
                }

                if (isHolding)
                    currentTradeNum++;

                worker.ReportProgress(100 * (i + 1) / brands.Length);
            }

            loseTradeNum = allTradeNum - winTradeNum;
            float winProb = allTradeNum == 0 ? 0 : (float)100 * winTradeNum / allTradeNum;
            float loseProb = allTradeNum == 0 ? 0 : 100 - winProb;
            loseTradeAveRatio = 100 * (allTradeAveRatio - winTradeAveRatio) / loseTradeNum;
            allTradeAveRatio = 100 * allTradeAveRatio / allTradeNum;
            winTradeAveRatio = 100 * winTradeAveRatio / winTradeNum;
            loseTradeAveSpan = (allTradeAveSpan - winTradeAveSpan) / loseTradeNum;
            winTradeMaxRatio = 100 * winTradeMaxRatio;
            loseTradeMinRatio = 100 * loseTradeMinRatio;
            allTradeAveSpan = allTradeAveSpan / allTradeNum;
            winTradeAveSpan = winTradeAveSpan / winTradeNum;
            loseTradeProfit = allTradeProfit - winTradeProfit;
            allTradeAveProfit = allTradeProfit / allTradeNum;
            winTradeAveProfit = winTradeProfit / winTradeNum;
            loseTradeAveProfit = loseTradeProfit / loseTradeNum;
            pf = -winTradeProfit / loseTradeProfit;
            // ݐϗvɕϊ
            profitList.Accumulate();
            Profit dd = profitList.MaxDrawDown();
            ddBook = dd.BookProfit;
            ddMarket = dd.MarketProfit;
            profitGraphBox.ProfitList = profitList;

            string msg = "t@C: " + system.File + "\r\n" +
                "ԃ[h: " + (isDaily ? "" : "T") + "\r\n" +
                "Ώۖ: " + targetName + "\r\n" +
                profitList.MinDate.ToShortDateString() + "`" + profitList.MaxDate.ToShortDateString() + "ɂ鐬тłB\r\n" +
                "----------------------------------------\r\n" +
                "Sg[h\t\t" + allTradeNum + "\r\n" +
                "g[h()\t" + winTradeNum + "(" + winProb.ToString("N") + "%)\r\n" +
                "g[h()\t" + loseTradeNum + "(" + loseProb.ToString("N") + "%)\r\n\r\n" +
                "Sg[hϗ\t" + allTradeAveRatio.ToString("N") + "%\r\n" +
                "g[hϗ\t" + winTradeAveRatio.ToString("N") + "%\r\n" +
                "g[hϑ\t" + loseTradeAveRatio.ToString("N") + "%\r\n\r\n" +
                "g[hő嗘\t" + winTradeMaxRatio.ToString("N") + "%\r\n" +
                "g[hő呹\t" + loseTradeMinRatio.ToString("N") + "%\r\n\r\n" +
                "Sg[hϊ\t" + allTradeAveSpan.ToString("N") + "\r\n" +
                "g[hϊ\t" + winTradeAveSpan.ToString("N") + "\r\n" +
                "g[hϊ\t" + loseTradeAveSpan.ToString("N") + "\r\n" +
                "----------------------------------------\r\n" +
                "v\t\t\t" + allTradeProfit.ToString("C") + "\r\n" +
                "g[hv\t\t" + winTradeProfit.ToString("C") + "\r\n" +
                "g[h\t\t" + loseTradeProfit.ToString("C") + "\r\n\r\n" +
                "Sg[hϗv\t" + allTradeAveProfit.ToString("C") + "\r\n" +
                "g[hϗv\t" + winTradeAveProfit.ToString("C") + "\r\n" +
                "g[hϑ\t" + loseTradeAveProfit.ToString("C") + "\r\n\r\n" +
                "g[hő嗘v\t" + winTradeMaxProfit.ToString("C") + "\r\n" +
                "g[hő呹\t" + loseTradeMinProfit.ToString("C") + "\r\n\r\n" +
                "vtBbgt@N^[\t\t" + pf.ToString("N") + "\r\n\r\n" +
                "őh[_E(뉿)\t" + ddBook.ToString("C") + "\r\n" +
                "őh[_E()\t" + ddMarket.ToString("C") + "\r\n" +
                "----------------------------------------\r\n" +
                "ݐis̃g[h\t" + currentTradeNum + "\r\n";
            return msg;
        }

        /// <summary>
        /// AvP[ṼC Gg |CgłB
        /// </summary>
        [STAThread]
        static void Main()
        {
            Process cps = Process.GetCurrentProcess();
            Process[] ps = Process.GetProcessesByName(cps.ProcessName);
            if (ps.Length > 1)
            {
                int i = 0;
                if (ps[0].Id == cps.Id)
                    i = 1;
                SetForegroundWindow(ps[i].MainWindowHandle.ToInt32());
                return;
            }

            Application.Run(new MainForm());
        }

        private void MainForm_Load(object sender, System.EventArgs e)
        {
            BrandList[] brandLists = BrandListTable.GetAllRecords();
            foreach (BrandList brandList in brandLists)
                this.comboBoxBrandList.Items.Add(new BrandListItem(brandList));
            if (this.comboBoxBrandList.Items.Count > 0)
                this.comboBoxBrandList.SelectedIndex = 0;

            this.dateTimePickerHistoryDateMin.Value = DateTime.Now.AddMonths(-1);
            this.ptFileTreeView.RootDirectory = Global.DirSystem;

            EnvRead();
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            EnvWrite();
        }

        private void MainForm_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.F5 || (e.KeyCode == Keys.R && e.Control))
                ptFileTreeView.RootDirectory = Global.DirSystem;
        }

        private void menuItemLogDelete_Click(object sender, System.EventArgs e)
        {
            TradingSystem system = this.GetSelectedSystem();
            if (system == null)
                return;
            string msg = string.Format(
                "t@C: {0}\nԃ[h: {1}\ñVXeO폜܂B낵łH",
                system.File, system.Mode == 0 ? "" : "T");
            DialogResult result = MessageBox.Show(
                this, msg, "mF", MessageBoxButtons.OKCancel,
                MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1);
            if (result == DialogResult.OK)
                SimulateTextBox.DeleteLog(system.Id);
        }

        private void menuItemLogAllDelete_Click(object sender, System.EventArgs e)
        {
            DialogResult result = MessageBox.Show(this,
                "VXeOׂč폜܂B낵łH",
                "mF", MessageBoxButtons.OKCancel,
                MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2);
            if (result == DialogResult.OK)
                SimulateTextBox.DeleteLog();
        }

        private void menuItemBrandListEdit_Click(object sender, System.EventArgs e)
        {
            Form dialog = new EditBrandListDialog();
            dialog.ShowDialog(this);

            object item = this.comboBoxBrandList.SelectedItem;
            this.comboBoxBrandList.Items.Clear();
            BrandList[] brandLists = BrandListTable.GetAllRecords();
            foreach (BrandList brandList in brandLists)
                this.comboBoxBrandList.Items.Add(new BrandListItem(brandList));
            if (item != null && this.comboBoxBrandList.Items.Contains(item))
                this.comboBoxBrandList.SelectedItem = item;
            else if (this.comboBoxBrandList.Items.Count > 0)
                this.comboBoxBrandList.SelectedIndex = 0;
        }

        private void menuItemMan_Click(object sender, System.EventArgs e)
        {
            Process.Start(Global.PathMan);
        }

        private void menuItemVersion_Click(object sender, System.EventArgs e)
        {
            Form dialog = new VersionDialog();
            dialog.ShowDialog(this);
        }

        private void ptFileTreeView_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
        {
            this.comboBoxBrandList_SelectedIndexChanged(sender, e);
        }

        private void comboBoxBrandList_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            if (this.ptFileTreeView.SelectedRelativeFile != null
                && this.comboBoxBrandList.SelectedItem != null)
            {
                if (!backgroundWorkerExecute.IsBusy && !backgroundWorkerPerformance.IsBusy)
                {
                    this.buttonExecute.Enabled = true;
                    this.buttonPerformance.Enabled = true;
                    this.menuItemLogDelete.Enabled = true;
                }
                this.buttonHistory.Enabled = true;
            }
            else
            {
                if (!backgroundWorkerExecute.IsBusy && !backgroundWorkerPerformance.IsBusy)
                {
                    this.buttonExecute.Enabled = false;
                    this.buttonPerformance.Enabled = false;
                    this.menuItemLogDelete.Enabled = false;
                }
                this.buttonHistory.Enabled = false;
            }
        }

        private void buttonExecute_Click(object sender, System.EventArgs e)
        {
            if (backgroundWorkerExecute.IsBusy)
            {
                backgroundWorkerExecute.CancelAsync();
                return;
            }

            TradingSystem system = this.GetSelectedSystem();
            if (system == null)
                return;
            Brand[] brands = this.GetSelectedBrands();
            if (brands == null)
                return;

            // e푀𖳌
            this.buttonExecute.Text = "f";
            this.buttonPerformance.Enabled = false;
            this.menuItemLogDelete.Enabled = false;
            this.menuItemLogAllDelete.Enabled = false;
            this.menuItemBrandListEdit.Enabled = false;
            // simulateTextBox
            this.simulateTextBox.Clear();

            backgroundWorkerExecute.RunWorkerAsync(new object[] { system, brands });
        }

        private void backgroundWorkerExecute_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = sender as BackgroundWorker;
            Execute(worker, e);
        }

        private void backgroundWorkerExecute_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            this.progressBarExecute.Value = e.ProgressPercentage;
        }

        private void backgroundWorkerExecute_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Error != null)
                this.simulateTextBox.AppendText(e.Error.Message + "\r\nG[̂Ŏs𒆒f܂B");
            else if (e.Cancelled)
                this.simulateTextBox.AppendText("f܂B");
            else
                this.simulateTextBox.AppendText("ɏI܂B\r\n");

            // e푀𕜋B
            this.buttonExecute.Text = "s";
            this.progressBarExecute.Value = 0;
            this.menuItemLogAllDelete.Enabled = true;
            if (this.ptFileTreeView.SelectedRelativeFile != null
                && this.comboBoxBrandList.SelectedItem != null)
            {
                this.buttonPerformance.Enabled = true;
                this.menuItemLogDelete.Enabled = true;
                this.menuItemBrandListEdit.Enabled = true;
            }
            else
            {
                this.buttonExecute.Enabled = false;
            }
            this.progressBarPerformance.Value = 0;
        }

        private void buttonPerformance_Click(object sender, System.EventArgs e)
        {
            if (backgroundWorkerPerformance.IsBusy)
            {
                backgroundWorkerPerformance.CancelAsync();
                return;
            }
            TradingSystem system = this.GetSelectedSystem();
            if (system == null)
                return;
            Brand[] brands = this.GetSelectedBrands();
            if (brands == null)
                return;
            string targetName = this.comboBoxBrandList.Text;

            // e푀𖳌ɂB
            this.buttonPerformance.Text = "f";
            this.buttonExecute.Enabled = false;
            this.menuItemLogDelete.Enabled = false;
            this.menuItemLogAllDelete.Enabled = false;
            this.menuItemBrandListEdit.Enabled = false;
            this.richTextBoxPerformanceSummery.Clear();

            // profitGraphBoxB
            this.profitGraphBox.ProfitList = null;

            backgroundWorkerPerformance.RunWorkerAsync(new object[] { system, brands, targetName });
        }

        private void backgroundWorkerPerformance_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = sender as BackgroundWorker;
            e.Result = Performance(worker, e);
        }

        private void backgroundWorkerPerformance_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            this.progressBarPerformance.Value = e.ProgressPercentage;
        }

        private void backgroundWorkerPerformance_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Error != null)
                this.richTextBoxPerformanceSummery.AppendText(e.Error.Message + "\r\nG[̂ŌvZ𒆒f܂B");
            else if (e.Cancelled)
                this.richTextBoxPerformanceSummery.AppendText("f܂B");
            else
                this.richTextBoxPerformanceSummery.AppendText((string)e.Result);

            // e푀𕜋B
            this.buttonPerformance.Text = "vZ";
            this.menuItemLogAllDelete.Enabled = true;
            if (this.ptFileTreeView.SelectedRelativeFile != null
                && this.comboBoxBrandList.SelectedItem != null)
            {
                this.buttonExecute.Enabled = true;
                this.menuItemLogDelete.Enabled = true;
                this.menuItemBrandListEdit.Enabled = true;
            }
            else
            {
                this.buttonPerformance.Enabled = false;
            }
            this.progressBarPerformance.Value = 0;
        }

        /// <summary>
        /// IĂVXe擾܂B
        /// </summary>
        /// <returns>IĂVXełB</returns>
        private TradingSystem GetSelectedSystem()
        {
            string file = this.ptFileTreeView.SelectedRelativeFile;
            if (file != null)
            {
                int mode = 0;
                if (this.radioButtonWeekly.Checked)
                    mode = 1;
                TradingSystem record = SystemTable.GetRecord(file, mode);
                if (record == null)
                    record = SystemTable.Add(file, mode);
                return record;
            }

            return null;
        }

        /// <summary>
        /// IĂΏۖ̃Xg擾܂B
        /// </summary>
        /// <returns>IĂΏۖ̃XgłB</returns>
        private Brand[] GetSelectedBrands()
        {
            object item = this.comboBoxBrandList.SelectedItem;
            if (item != null)
            {
                BrandList brandList = ((BrandListItem)item).BrandList;
                return brandList.Brands;
            }

            return null;
        }

        private void buttonHistory_Click(object sender, System.EventArgs e)
        {
            TradingSystem system = this.GetSelectedSystem();
            if (system == null)
                return;
            Brand[] brands = this.GetSelectedBrands();
            if (brands == null)
                return;

            SystemLog[] logs = SystemLogTable.GetRecords(system.Id,
                    this.dateTimePickerHistoryDateMin.Value,
                    this.dateTimePickerHistoryDateMax.Value);
            Hashtable brandIdTable = new Hashtable();
            foreach (Brand brand in brands)
                brandIdTable.Add(brand.Id, null);

            this.listViewHistory.Items.Clear();
            this.listViewHistory.BeginUpdate();
            foreach (SystemLog log in logs)
            {
                Brand brand = log.Brand;
                if (brandIdTable.ContainsKey(brand.Id))
                {
                    ListViewItem listViewItem = new ListViewItem(new string[]{
						log.Date.ToString("yy/MM/dd"),
						brand.Code.ToString(),
						brand.Name,
						log.Price.ToString(),
						log.Number.ToString(),
						log.Order == 0 ? "" : "" });
                    listViewItem.BackColor = log.Order == 0 ? Color.LightBlue : Color.LightPink;
                    this.listViewHistory.Items.Add(listViewItem);
                }
            }
            this.listViewHistory.EndUpdate();
        }

        private void copyHistory_Click(object sender, System.EventArgs e)
        {
            System.Text.StringBuilder builder = new System.Text.StringBuilder();
            foreach (ListViewItem item in this.listViewHistory.SelectedItems)
            {
                for (int n = 0; n < item.SubItems.Count; n++)
                {
                    builder.Append(item.SubItems[n].Text);
                    if (n < item.SubItems.Count - 1)
                        builder.Append(",");
                }
                builder.Append("\n");
            }
            if (builder.Length == 0)
                return;
            Clipboard.SetDataObject(builder.ToString());
        }
    }
}
