// Copyright(C) 2008 panacorn <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MujinzouUpdator.cs,v 1.1 2008-02-03 13:27:08 panacoran Exp $

using System;
using System.Collections;
using System.ComponentModel;
using System.IO;
using System.Text;
using Protra.Lib.Db;

namespace Protra.Lib.Update
{
	/// <summary>
	/// s𗘗pĊf[^̍XVsNXB
	/// </summary>
	public class MujinzouUpdator: PriceDataUpdator
	{
        /// <summary>
        /// f[^݂ŏ̓t擾B
        /// </summary>
        public static DateTime DataSince
        {
            get { return new DateTime(1996, 1, 4); }
        }

        /// <summary>
		/// f[^XVB
		/// </summary>
		/// <param name="worker">BackgroundWorker</param>
        /// <param name="e">DoWorkCxg̈</param>
		public override void Update(BackgroundWorker worker, DoWorkEventArgs e)
		{
            DateTime begin = (DateTime)e.Argument;
            if (begin < DataSince)
                begin = DataSince;
			DateTime today = DateTime.Now;
			// Vf[^û͑Ăߌ5ȍ~
			if (today.Hour < 17)
				today = today.AddDays(-1);

            for (Start((DateTime)e.Argument, today);
				 ShouldContinue(); NextDate())
			{
				UpdateProgress(worker, e);

                StartDownload();
                DownloadUtil.Url = "http://souba-data.com/data/" + 
					Date.ToString(@"yyyy\/yy_MM\/\TyyMMdd") + ".lzh";
                Stream stream = DownloadUtil.DownloadAndExtract();
                if (stream == null)
                {
                    DecrementTotalDays();
                    continue;
                }
                if (worker.CancellationPending)
                {
                    e.Cancel = true;
                    stream.Close();
                    return;
                }
                StreamReader reader = new StreamReader(stream, Encoding.GetEncoding("shift_jis"));
                ArrayList dataList = new ArrayList();
                string line;
                while ((line = reader.ReadLine()) != null)
                {
                    PriceData tmp = ParseLine(line);
                    if (tmp != null)
                        dataList.Add(tmp);
                }
                reader.Close();
                TotalRecords = dataList.Count;
                EndDownload();

                for (; NumRecords < TotalRecords; IncrementRecords(), UpdateProgress(worker, e))
                {
                    if (worker.CancellationPending)
                    {
                        e.Cancel = true;
                        PriceTable.Delete(Date);
                        return;
                    }
                    
                    PriceData data = (PriceData)dataList[NumRecords];
                    Brand brand = BrandTable.GetRecordOrCreate(data.MarketId, data.Code, data.Name);
                    PriceTable.Add(brand.Id, data.Date, data.Open, data.High, data.Low, data.Close, data.Volume);
                }
                IncrementDays();
            }

			UpdateSplitData(worker, e);
            worker.ReportProgress(100, "");
		}

		/// <summary>
		/// Ɋ܂܂f[^i[IuWFNgԂB
		/// </summary>
		/// <param name="line">w肷B</param>
		/// <returns>IuWFNg</returns>
		private PriceData ParseLine(string line)
		{
			string[] tokens = line.Split(new char [] {'\t', ','});
			PriceData r = new PriceData();
			try
			{
				r.Date = DateTime.Parse(tokens[0]);
				r.Code = int.Parse(tokens[1]);
				r.Name = tokens[3];
				int index = r.Name.IndexOf(' ');
				if (index > 0)
					r.Name = r.Name.Remove(0, index + 1);
				// w̒lɏ܂܂Ă̂double.Parse𗘗pB
				r.Open = (int)double.Parse(tokens[4]);
				r.High = (int)double.Parse(tokens[5]);
				r.Low = (int)double.Parse(tokens[6]);
				r.Close = (int)double.Parse(tokens[7]);
				r.Volume = double.Parse(tokens[8]) / 1000;
				switch (tokens[2])
				{
				case "11":
					r.MarketId = Db.MarketId.Tokyo1;
					break;
				case "12":
					r.MarketId = Db.MarketId.Tokyo2;
					break;
				case "13": 				
					r.MarketId = Db.MarketId.Mothers;
					break;
				case "14":
					r.MarketId = Db.MarketId.TokyoForeign;
					break;
				case "20"://̑؂͂PAQ݂Ă̂łPɂ
				case "21":
					r.MarketId = Db.MarketId.Osaka1;
					break;
				case "22":
					r.MarketId = Db.MarketId.Osaka2;
					break;
				case "23":
				case "24": 
					r.MarketId = Db.MarketId.Hercules;
					break;
				case "30"://̖؂͂PAQ݂Ă̂łPɂ
				case "31":
					r.MarketId = Db.MarketId.Nagoya1;
					break;
				case "32":
					r.MarketId = Db.MarketId.Nagoya2;
					break;
				case "91":
					r.MarketId = Db.MarketId.Jasdaq;
					break;
				default:
					return null;
				}
			}
			catch (FormatException)
			{
				// tH[}bgG[͑SB
				return null;
			}
			return r;
		}
	}
}
