﻿// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: SortableListView.cs 404 2010-12-07 08:42:48Z panacoran $

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace PtSim.Controls
{
    /// <summary>
    /// アイテムのソートが可能なListViewクラス。
    /// </summary>
    public partial class SortableListView : ListView
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SortableListView()
        {
            InitializeComponent();
            OwnerDraw = true; // ListViewが色を正しく塗らないバグに対応するため自分で描画するふりをする。
        }

        /// <summary>
        /// デフォルトの描画をさせる。
        /// </summary>
        /// <param name="e">イベントデータ</param>
        protected override void OnDrawColumnHeader(DrawListViewColumnHeaderEventArgs e)
        {
            e.DrawDefault = true;
            base.OnDrawColumnHeader(e);
        }
        
        /// <summary>
        /// デフォルトの描画をさせる。
        /// </summary>
        /// <param name="e">イベントデータ</param>
        protected override void OnDrawItem(DrawListViewItemEventArgs e)
        {
            e.DrawDefault = true;
            base.OnDrawItem(e);
        }

        /// <summary>
        /// デフォルトの描画をさせる。
        /// </summary>
        /// <param name="e">イベントデータ</param>
        protected override void OnDrawSubItem(DrawListViewSubItemEventArgs e)
        {
            e.DrawDefault = true;
            base.OnDrawSubItem(e);
        }

        /// <summary>
        /// ColumnClickイベントを処理する。
        /// </summary>
        /// <param name="e">ColumnClickイベントの引数</param>
        protected override void OnColumnClick(ColumnClickEventArgs e)
        {
            base.OnColumnClick(e);
            SetSortColumn(e.Column);
        }

        private int sortColumn = -1;
        private int sortColumnOrder = 1;
        private string originalText;

        /// <summary>
        /// ソートするカラムを設定する。デフォルトは昇順で同じカラムを再度指定すると降順になる。
        /// </summary>
        /// <param name="column">ソートするカラムの0から始まる番号</param>
        public void SetSortColumn(int column)
        {
            if (sortColumn == column)
                sortColumnOrder *= -1;
            if (originalText != null)
                Columns[sortColumn].Text = originalText;
            originalText = Columns[column].Text;
            Columns[column].Text = originalText + (sortColumnOrder == 1 ? "▴" : "▾");
            sortColumn = column;
            ListViewItemSorter = new ListViewItemComparer(sortColumn, sortColumnOrder);
        }

        class ListViewItemComparer : IComparer
        {
            private int column;
            private int order;

            public ListViewItemComparer(int column, int order)
            {
                this.column = column;
                this.order = order;
            }

            public int Compare(object x, object y)
            {
                return order * String.Compare(((ListViewItem)x).SubItems[column].Text, ((ListViewItem)y).SubItems[column].Text); 
            }
        }
    }
}
