﻿using System;
using System.Collections.Generic;
using System.Text;
using Protra.Lib.Data;

namespace Protra.Lib.Config
{
    /// <summary>
    /// PtSimの設定を読み書きするクラス。
    /// </summary>
    public class PtSimConfig : ConfigBase
    {
        /// <summary>
        /// システムの実行モードの設定を取得または設定する。
        /// </summary>
        public int Mode { get; set; }

        /// <summary>
        /// 銘柄リストの名前の設定を取得または設定する。
        /// </summary>
        public string BrandListName { get; set; }

        /// <summary>
        /// 設定ファイルの名前を取得する。
        /// </summary>
        protected override string ConfigName
        {
            get { return "ptsim"; }
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PtSimConfig() : base(false)
        {
        }

        /// <summary>
        /// 古い設定ファイルを読み込む。
        /// </summary>
        protected override void ReadOldConfig()
        {
            ConfigFile ptsim = new ConfigFile("ptsim");
            try
            {
                ptsim.Read();
            }
            catch
            {
                return;
            }
            Mode = int.Parse(ptsim["Mode"]);
            var bl = Db.BrandListTable.GetRecord(int.Parse(ptsim["BrandListId"]));
            BrandListName = bl.Name;
        }
    }
}
