// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionNode.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ֐̃m[h\NXłB
	/// </summary>
	public class FunctionNode : Node
	{
		/// <summary>
		/// ֐̃^Cv
		/// </summary>
		private FunctionType ft;
		/// <summary>
		/// ̃m[h̃Xg
		/// </summary>
		private ArrayList nodeList = new ArrayList();

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			// ֐̎擾
			ContextToken ct = (ContextToken)context.Current;
			string name = ct.ToString();

			// ̃`FbN
			context.MoveNext();
			ct = (ContextToken)context.Current;
			string token = ct.ToString();
			if(token != "(")
			{
				ft = new FunctionType(name, nodeList.Count);
				return;
			}
			context.MoveNext();
			ct = (ContextToken)context.Current;
			token = ct.ToString();
			if(token == ")")
			{
				ft = new FunctionType(name, nodeList.Count);
				context.MoveNext();
				return;
			}
			do
			{
				Node node = new ExpressionNode();
				node.Parse(context);
				nodeList.Add(node);
				ct = (ContextToken)context.Current;
				token = ct.ToString();
				if(token == ")")
				{
					ft = new FunctionType(name, nodeList.Count);
					context.MoveNext();
					return;
				}
				else if(token != ",")
					throw new ParseException("',' or ')' expected", this.ContextToken);
			}while(context.MoveNext());
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			for(int i = 0; i < nodeList.Count; i++)
			{
				Node node = (Node)nodeList[i];
				nodeList[i] = node.Simplify();
			}
			return this;
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			// ֐`ĂΎs
			if(resource.FunctionTable.ContainsFunctionType(ft))
			{	
				// ֐`m[h̎擾
				FunctionDefinitionNode fdn = resource.FunctionTable[ft];

				// ̃[Jϐp
				VariableTable lvt = new VariableTable();
				lvt["at"] = new Value(at);
				string[] names = fdn.ArgumentNames;
				for(int i = 0; i < nodeList.Count; i++)
				{
					Node node = (Node)nodeList[i];
					Value val = node.Execute(resource, at);
					lvt[names[i]] = val;
				}
				// [Jϐ̃e[uvbV
				resource.Stack.Push(lvt);

				// ̎s
				Node[] nodes = fdn.Nodes;
				try
				{
					foreach(Node node in nodes)
						node.Execute(resource, at);

					// [Jϐ̃e[u|bv
					resource.Stack.Pop();
					return null;
				}
				catch(ReturnStatementExecutedException exc)
				{
					// [Jϐ̃e[u|bv
					resource.Stack.Pop();
					return exc.Value;
				}
			}

			// ֐IExecuterFactoryɂĒ񋟂ȂΎs
			try
			{
				IExecuter executer = resource.ExecuterFactory.CreateExecuter(ft);
				Value[] args = new Value[nodeList.Count];
				for(int i = 0; i < args.Length; i++)
				{
					Node node = (Node)nodeList[i];
					Value val = node.Execute(resource, at);
					args[i] = val;
				}

				return executer.Execute(args, at);
			}
			catch(NoSuchExecuterException)
			{
				throw new RuntimeException("undefined function --- " + ft.ToString(), this.ContextToken);
			}
		}
	}
}
