// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: LiteralNode.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ẽm[h\NXłB
	/// </summary>
	public class LiteralNode : Node
	{
		/// <summary>
		/// l
		/// </summary>
		private Value val;

		/// <summary>
		/// RXgN^
		/// </summary>
		public LiteralNode() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">l</param>
		public LiteralNode(Value val)
		{
			this.val = val;
		}

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			ContextToken ct = (ContextToken)context.Current;
			if(ct.IsInt)
				val = new Value(int.Parse(ct.ToString()));
			else if(ct.IsFloat)
				val = new Value(double.Parse(ct.ToString()));
			else if(ct.IsString)
			{
				string str = ct.ToString();
				val = new Value(str.Substring(1, str.Length - 2));
			}

			context.MoveNext();
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			return this;
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			return val;
		}
	}
}
