// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: DrawBuiltins.cs,v 1.2 2008-03-27 20:56:16 panacoran Exp $

using System;
using System.Collections.Generic;
using System.Drawing;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// `n̑gݍ݊֐̃fQ[gB
    /// </summary>
    /// <param name="rgb">F</param>
    /// <param name="a1">W1</param>
    /// <param name="a2">W2</param>
    /// <param name="a3">W3</param>
    /// <param name="a4">W4</param>
    public delegate void DrawFunctionDelegate(int rgb, double a1, double a2, double a3, double a4);
    /// <summary>
    /// gݍ݊֐DrawString̃fQ[gB
    /// </summary>
    /// <param name="rgb">F</param>
    /// <param name="text"></param>
    /// <param name="x">xW</param>
    /// <param name="y">yW</param>
    /// <param name="dh">ItZbg</param>
    public delegate void DrawStringDelegate(int rgb, string text, double x, double y, int dh);

    /// <summary>
    /// `n̑gݍ݊֐̎sL^\́B
    /// </summary>
    public struct DrawFunctionRecord
    {
        int rgb;
        double a1, a2, a3, a4;
        string text;
        int dh;
        DrawFunctionDelegate drawFunction;
        DrawStringDelegate drawString;

        /// <summary>
        /// RXgN^B
        /// </summary>
        /// <param name="f">s֐̃fQ[g</param>
        /// <param name="rgb">F</param>
        /// <param name="a1">W1</param>
        /// <param name="a2">W2</param>
        /// <param name="a3">W3</param>
        /// <param name="a4">W4</param>
        public DrawFunctionRecord(DrawFunctionDelegate f, int rgb, double a1, double a2, double a3, double a4)
        {
            drawFunction = f;
            this.rgb = rgb;
            this.a1 = a1; this.a2 = a2; this.a3 = a3; this.a4 = a4;
            drawString = null;
            text = null;
            dh = 0;
        }

        /// <summary>
        /// RXgN^B
        /// </summary>
        /// <param name="f">DrawString̃fQ[g</param>
        /// <param name="rgb">F</param>
        /// <param name="text"></param>
        /// <param name="x">xW</param>
        /// <param name="y">yW</param>
        /// <param name="dh">ItZbg</param>
        public DrawFunctionRecord(DrawStringDelegate f, int rgb, string text, double x, double y, int dh)
        {
            drawString = f;
            this.rgb = rgb;
            this.text = text;
            a1 = x; a2 = y;
            this.dh = dh;
            drawFunction = null;
            a3 = 0; a4 = 0;

        }

        /// <summary>
        /// L^ꂽeۂɎsB
        /// </summary>
        public void Execute()
        {
            if (drawString != null)
            {
                drawString(rgb, text, a1, a2, dh);
                return;
            }
            drawFunction(rgb, a1, a2, a3, a4);
        }
    }

    /// <summary>
    /// `n̑gݍ݊֐NXB
    /// </summary>
    public class DrawBuiltins : BasicBuiltins
    {
        private int x;
        private int dx;
        private double minY;
        private double maxY;
        private List<DrawFunctionRecord> functionList;
        private Graphics g;
        private Font font;
        private Rectangle chartRect;

        /// <summary>
        /// RXgN^B
        /// </summary>
        public DrawBuiltins()
        {
            functionList = new List<DrawFunctionRecord>();
            minY = double.MaxValue;
            maxY = double.MinValue;
        }

        /// <summary>
        /// XW擾܂͐ݒ肷B
        /// </summary>
        public int X
        {
            set { x = value; }
            get { return x; }
        }

        /// <summary>
        /// ̊Ԋuݒ肷B
        /// </summary>
        public int Dx
        {
            set { dx = value; }
        }

         /// <summary>
        /// c̍ŏl擾邢͐ݒ肷B
        /// </summary>
        public double MinY
        {
            get { return minY; }
            set { minY = value; }
        }

        /// <summary>
        /// c̍ől擾邢͐ݒ肷B
        /// </summary>
        public double MaxY
        {
            get { return maxY; }
            set { maxY = value; }
        }

        /// <summary>
        /// gݍ݊֐sB
        /// </summary>
        /// <param name="name">O</param>
        /// <param name="args">̔z</param>
        /// <param name="at">atp[^</param>
        /// <returns></returns>
        public override Value Invoke(string name, Value[] args, int at)
        {
            if (args.Length == 0)
            {
                switch (name)
                {
                    case "X":
                        return new Value(x + at * dx);
                    case "Dx":
                        return new Value(dx);
                    default:
                        return base.Invoke(name, args, at);
                }
            }
            if (args.Length == 3 && name == "Rgb")
            {
                int r = (int)args[0].InnerValue;
                int g = (int)args[1].InnerValue;
                int b = (int)args[2].InnerValue;
                int rgb = Color.FromArgb(r, g, b).ToArgb();
                return new Value(rgb);
            }
            if (name == "DrawString")
            {
                if (args.Length != 4 && args.Length != 5)
                    return base.Invoke(name, args, at);
                int i = 0;
                int rgb = Color.Black.ToArgb();
                if (args.Length == 5)
                    rgb = (int)args[i++].InnerValue;
                string text = (string)args[i++].InnerValue;
                double x = (double)args[i++].Cast(Value.Type.Float).InnerValue;
                double y = (double)args[i++].Cast(Value.Type.Float).InnerValue;
                int dh = (int)args[i++].InnerValue;
                maxY = Math.Max(y, maxY);
                minY = Math.Min(y, minY);
                functionList.Add(new DrawFunctionRecord(DrawString, rgb, text, x, y, dh));
                return null;
            }
            if (args.Length == 5)
            {
                int rgb;
                double a1, a2, a3, a4;
                switch (name)
                {
                    case "DrawLine":
                        rgb = (int)args[0].InnerValue;
                        a1 = (double)args[1].Cast(Value.Type.Float).InnerValue;
                        a2 = (double)args[2].Cast(Value.Type.Float).InnerValue;
                        a3 = (double)args[3].Cast(Value.Type.Float).InnerValue;
                        a4 = (double)args[4].Cast(Value.Type.Float).InnerValue;
                        maxY = Math.Max(Math.Max(a2, a4), maxY);
                        minY = Math.Min(Math.Min(a2, a4), minY);
                        functionList.Add(new DrawFunctionRecord(DrawLine, rgb, a1, a2, a3, a4));
                        return null;
                    case "DrawRectangle":
                        rgb = (int)args[0].InnerValue;
                        a1 = (double)args[1].Cast(Value.Type.Float).InnerValue;
                        a2 = (double)args[2].Cast(Value.Type.Float).InnerValue;
                        a3 = (double)args[3].Cast(Value.Type.Float).InnerValue;
                        a4 = (double)args[4].Cast(Value.Type.Float).InnerValue;
                        maxY = Math.Max(Math.Max(a2, a2 + a4), maxY);
                        minY = Math.Min(Math.Min(a2, a2 + a4), minY);
                        functionList.Add(new DrawFunctionRecord(DrawRectangle, rgb, a1, a2, a3, a4));
                        return null;
                    case "DrawEllipse":
                        rgb = (int)args[0].InnerValue;
                        a1 = (double)args[1].Cast(Value.Type.Float).InnerValue;
                        a2 = (double)args[2].Cast(Value.Type.Float).InnerValue;
                        a3 = (double)args[3].Cast(Value.Type.Float).InnerValue;
                        a4 = (double)args[4].Cast(Value.Type.Float).InnerValue;
                        maxY = Math.Max(Math.Max(a2, a2 + a4), maxY);
                        minY = Math.Min(Math.Min(a2, a2 + a4), minY);
                        functionList.Add(new DrawFunctionRecord(DrawEllipse, rgb, a1, a2, a3, a4));
                        return null;
                    case "FillRectangle":
                        rgb = (int)args[0].InnerValue;
                        a1 = (double)args[1].Cast(Value.Type.Float).InnerValue;
                        a2 = (double)args[2].Cast(Value.Type.Float).InnerValue;
                        a3 = (double)args[3].Cast(Value.Type.Float).InnerValue;
                        a4 = (double)args[4].Cast(Value.Type.Float).InnerValue;
                        maxY = Math.Max(Math.Max(a2, a2 + a4), maxY);
                        minY = Math.Min(Math.Min(a2, a2 + a4), minY);
                        functionList.Add(new DrawFunctionRecord(FillRectangle, rgb, a1, a2, a3, a4));
                        return null;
                    case "FillEllipse":
                        rgb = (int)args[0].InnerValue;
                        a1 = (double)args[1].Cast(Value.Type.Float).InnerValue;
                        a2 = (double)args[2].Cast(Value.Type.Float).InnerValue;
                        a3 = (double)args[3].Cast(Value.Type.Float).InnerValue;
                        a4 = (double)args[4].Cast(Value.Type.Float).InnerValue;
                        maxY = Math.Max(Math.Max(a2, a2 + a4), maxY);
                        minY = Math.Min(Math.Min(a2, a2 + a4), minY);
                        functionList.Add(new DrawFunctionRecord(FillEllipse, rgb, a1, a2, a3, a4));
                        return null;
                }
            }
            return base.Invoke(name, args, at);
        }

        /// <summary>
        /// `֐sB
        /// </summary>
        /// <param name="g">Graphics̃CX^X</param>
        /// <param name="font">tHg</param>
        /// <param name="chartRect">`̈Rectangle</param>
        public void Draw(Graphics g, Font font, Rectangle chartRect)
        {
            this.g = g;
            this.font = font;
            this.chartRect = chartRect;
            foreach (DrawFunctionRecord d in functionList)
                d.Execute();
        }

        private void DrawLine(int rgb, double x1, double y1, double x2, double y2)
        {
            y1 = chartRect.Bottom - chartRect.Height * (y1 - minY) / (maxY - minY);
            y2 = chartRect.Bottom - chartRect.Height * (y2 - minY) / (maxY - minY);
            g.DrawLine(new Pen(Color.FromArgb(rgb)),
                (float)x1, (float)y1, (float)x2, (float)y2);
        }

        private void DrawRectangle(int rgb, double x, double y, double width, double height)
        {
            y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
            height = chartRect.Height * height / (maxY - minY);
            g.DrawRectangle(new Pen(Color.FromArgb(rgb)),
                (float)x, (float)(y - height), (float)width, (float)height);
        }

        private void DrawEllipse(int rgb, double x, double y, double width, double height)
        {
            y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
            height = chartRect.Height * height / (maxY - minY);
            g.DrawEllipse(new Pen(Color.FromArgb(rgb)),
                (float)x, (float)(y - height), (float)width, (float)height);
        }

        private void FillRectangle(int rgb, double x, double y, double width, double height)
        {
            y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
            height = chartRect.Height * height / (maxY - minY);
            if (-1 < height && height < 0)
                height = -1;
            if (0 < height && height < 1)
                height = 1;
            this.g.FillRectangle(new SolidBrush(Color.FromArgb(rgb)),
                (float)x, (float)(y - height), (float)width, (float)height);
        }

        private void FillEllipse(int rgb, double x, double y, double width, double height)
        {
            y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
            height = chartRect.Height * height / (maxY - minY);
            if (-1 < height && height < 0)
                height = -1;
            if (0 < height && height < 1)
                height = 1;
            this.g.FillEllipse(new SolidBrush(Color.FromArgb(rgb)),
                (float)x, (float)(y - height), (float)width, (float)height);
        }

        private void DrawString(int rgb, string text, double x, double y, int dh)
        {
            SizeF size = g.MeasureString(text, font);
            y = chartRect.Bottom - chartRect.Height * (y - minY) / (maxY - minY);
            this.g.DrawString(text, font, new SolidBrush(Color.FromArgb(rgb)),
                (float)(x - size.Width / 2), (float)(y - size.Height / 2) - dh);
        }
    }
}
