// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionType.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ֐̌^\NXłB
	/// ֐ƈ̐܂B
	/// </summary>
	public class FunctionType
	{
		/// <summary>
		/// ֐
		/// </summary>
		private string name;
		/// <summary>
		/// ̐
		/// </summary>
		private int num;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="name">֐</param>
		/// <param name="num">̐</param>
		public FunctionType(string name, int num)
		{
			this.name = name;
			this.num = num;
		}

		/// <summary>
		/// ֐擾܂B
		/// </summary>
		public string Name
		{
			get { return name; }
		}

		/// <summary>
		/// ̐擾܂B
		/// </summary>
		public int ArgumentNum
		{
			get { return num; }
		}

		/// <summary>
		/// w肵IuWFNgƓǂ𔻒f܂B
		/// </summary>
		/// <param name="o">IuWFNg</param>
		/// <returns>trueɂȂ܂B</returns>
		public override bool Equals(object o)
		{
			if(o is FunctionType)
				return ((FunctionType)o).name == this.name
					&& ((FunctionType)o).num == this.num;
			return false;
		}

		/// <summary>
		/// nbVlvZ܂B
		/// </summary>
		/// <returns>nbVl</returns>
		public override int GetHashCode()
		{
			return name.GetHashCode() + num;
		}

		/// <summary>
		/// \łB
		/// </summary>
		/// <returns>\</returns>
		public override string ToString()
		{
			return name + "(" + num.ToString() + ")";
		}
	}
}
