// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: StatementNode.cs,v 1.4 2008-03-26 22:12:54 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ̃m[h\NXłB
	/// </summary>
	public class StatementNode : Node
	{
		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
		public override Node Parse()
		{
            Token = Scanner.Token;
			switch (Token.Value)
			{
				case "if":
					return new IfStatementNode().Parse();
				case "while":
					return new WhileStatementNode().Parse();
				case "return":
					return new ReturnStatementNode().Parse();
				case "break":
					return new BreakStatementNode().Parse();
				case "continue":
					return new ContinueStatementNode().Parse();
				case ";":
					return new EmptyStatementNode().Parse();
				default:
					return new ExpressionStatementNode().Parse();
			}
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			return null;
		}
	}
}
