// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: BrandTreeView.cs,v 1.5 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using Protra.Lib.Db;

namespace Protra.Controls
{
	/// <summary>
	/// Xg\TreeViewłB
	/// </summary>
	public class BrandTreeView : System.Windows.Forms.TreeView
	{
		/// <summary>
		/// Ǝ̕
		/// </summary>
		private string[] categories = {
			"Y/z/", "Hi", "@//pv", "w/i",
			"Ζ/S/q", "S|/S", "@B",
			"d@", "A@/", "/SݓX", "s/،/",
			"sY/A", "d/KX/T[rX" };
		/// <summary>
		/// R[h̃CfbNX
		/// </summary>
		private int[] codeIndex = {
			1300, 2000, 3000, 4000, 5000, 5400, 6000, 6500,
			7000, 8000, 8300, 8800, 9400, 10000 };

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public BrandTreeView()
		{
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();

			this.BeforeExpand += new TreeViewCancelEventHandler(OnBeforeExpand);
			//Initialize();
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		/// <summary>
		/// ܂B
		/// </summary>
		public void Initialize()
		{
			this.Nodes.Clear();

			// s̓o^
			Market[] markets = MarketTable.GetAllRecords();
			foreach(Market market in markets)
			{
				TreeNode tn = new TreeNode(market.Name);
				tn.Nodes.Add("dummy");
				this.Nodes.Add(tn);
			}

			// 1100̖̓o^
			Brand[] brands = BrandTable.GetRecords(MarketId.Tokyo1, 1000, 1099);
			foreach (Brand brand in brands)
				this.Nodes.Add(brand.Code + " " + brand.Name);
			
			// oςΑI
			this.Select();
			if (BrandTable.GetRecord(MarketId.Tokyo1, 1001) != null)
				this.SelectedNode = this.Nodes[markets.Length];
		}

		private void OnBeforeExpand(object sender, System.Windows.Forms.TreeViewCancelEventArgs e)
		{
			// _~[m[h̃NA
			e.Node.Nodes.Clear();

			if(e.Node.Parent == null) // sꂩƎւ̓WJ
			{
				foreach(string category in categories)
				{
					TreeNode tn = new TreeNode(category);
					tn.Nodes.Add("dummy");
					e.Node.Nodes.Add(tn);
				}
				return;
			}

			// Ǝ킩ւ̓WJ
			Market market = MarketTable.GetRecord((MarketId)(e.Node.Parent.Index + 1));
			int minCode = codeIndex[e.Node.Index];
			int maxCode = codeIndex[e.Node.Index + 1] - 1;
			Brand[] brands = BrandTable.GetRecords(market.Id, minCode, maxCode);
			foreach(Brand brand in brands)
				e.Node.Nodes.Add(brand.Code + " " + brand.Name);
		}

		/// <summary>
		/// IĂ擾܂B
		/// </summary>
		public Brand SelectedBrand
		{
			get
			{
				TreeNode node = this.SelectedNode;
				if(node == null)
					return null;
				Regex regex = new Regex("^([0-9]+) .+$");
				Match match = regex.Match(node.Text);
				if(match.Success)
				{
					int brandCode = int.Parse(match.Groups[1].Value);
					MarketId marketId;
					if(node.Parent == null)
						marketId = MarketId.Tokyo1;
					else
						marketId = (MarketId)(node.Parent.Parent.Index + 1);
					return BrandTable.GetRecord(marketId, brandCode);
				}
				else
				{
					return null;
				}
			}
		}
	}
}
