// Protra - Easy trading system development environment.
// Copyright(C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: LhaExtracter.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.IO;
using System.Runtime.InteropServices;

namespace Protra.Lib.Archiver
{
	/// <summary>
	/// LhaIExtracterłB
	/// </summary>
	public class LhaExtracter : IExtracter
	{
		[DllImport("unlha32.dll")]
		private static extern int Unlha(
			int hwnd, string szCmdLine, string szOutput, int dwSize);

		/// <summary>
		/// 𓀂܂B
		/// </summary>
		/// <param name="file">kt@C</param>
		/// <param name="dir">𓀐fBNg</param>
		public void Extract(string file, string dir)
		{
			if(dir[dir.Length - 1] != Path.DirectorySeparatorChar)
				dir += Path.DirectorySeparatorChar;
			string cmd = "e -n \"" + file + "\" \"" + dir + "\"";
			Unlha(0, cmd, null, 0);
		}
	}
}
