// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ContextToken.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Text.RegularExpressions;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ContextɂX̃g[N\NXłB
	/// ContextMementoł܂B
	/// </summary>
	public class ContextToken
	{
		// \̃Xg
		private string[] registeredWords
			= {	"int", "float", "string", "null", "if", "else",  "elsif",
				"while", "def", "end", "return", "break", "continue" };
		private string[] typeWords
			= { "int", "float", "string" };

		/// <summary>
		/// g[N̎
		/// </summary>
		private string token;
		/// <summary>
		/// g[N̑t@C
		/// </summary>
		private string file;
		/// <summary>
		/// ̃g[N݂̑s
		/// </summary>
		private int line;
		/// <summary>
		/// ̃g[N̊Jnʒu
		/// </summary>
		private int pos;
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="token">g[N</param>
		/// <param name="file">g[N̑t@C</param>
		/// <param name="line">g[N݂̑s</param>
		/// <param name="pos">g[N̊Jnʒu</param>
		public ContextToken(string token, string file, int line, int pos)
		{
			this.token = token;
			this.file = file;
			this.line = line;
			this.pos = pos;
		}

		/// <summary>
		/// g[N̕Ԃ܂B
		/// </summary>
		/// <returns>g[N̕</returns>
		public override string ToString()
		{
			return token;
		}

		/// <summary>
		/// g[N̑t@C擾܂B
		/// </summary>
		public string FileName
		{
			get { return file; }
		}

		/// <summary>
		/// ̃g[N݂̑sԍ擾܂B
		/// </summary>
		public int Line
		{
			get { return line; }
		}

		/// <summary>
		/// ̃g[N̊Jnʒu擾܂B
		/// </summary>
		public int Position
		{
			get { return pos; }
		}

		/// <summary>
		/// g[N\ł邩ǂ_l擾܂B
		/// </summary>
		public bool IsRegisteredWord
		{
			get
			{
				if(token == null)
					return false;
				for(int i = 0; i < registeredWords.Length; i++)
					if(token == registeredWords[i])
						return true;
				return false;
			}
		}

		/// <summary>
		/// g[NOł邩ǂ_l擾܂B
		/// </summary>
		public bool IsName
		{
			get
			{
				if(token == null)
					return false;
				if(IsRegisteredWord)
					return false;
				Regex regex = new Regex(@"^[A-Za-z][A-Za-z0-9_]*$|^\$[A-Za-z0-9_]+$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[Nϐ̖Oł邩ǂ_l擾܂B
		/// </summary>
		public bool IsVariableName
		{
			get
			{
				if(token == null)
					return false;
				if(IsRegisteredWord)
					return false;
				Regex regex = new Regex(@"^\$[A-Za-z0-9_]+$|^[a-z][A-Za-z0-9_]*$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[NO[oϐ̖Oł邩ǂ_l擾܂B
		/// </summary>
		public bool IsGlobalVariableName
		{
			get
			{
				if(token == null)
					return false;
				Regex regex = new Regex(@"^\$[A-Za-z0-9_]+$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[N[Jϐ̖Oł邩ǂ_l擾܂B
		/// </summary>
		public bool IsLocalVariableName
		{
			get
			{
				if(token == null)
					return false;
				if(IsRegisteredWord)
					return false;
				Regex regex = new Regex(@"^[a-z][A-Za-z0-9_]*$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[N֐ł邩ǂ_l擾܂B
		/// </summary>
		public bool IsFunctionName
		{
			get
			{
				if(token == null)
					return false;
				Regex regex = new Regex(@"^[A-Z][A-Za-z0-9_]*$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[N^Cvł邩ǂ_l擾܂B
		/// </summary>
		public bool IsType
		{
			get
			{
				if(token == null)
					return false;
				for(int i = 0; i < typeWords.Length; i++)
					if(token == typeWords[i])
						return true;
				return false;
			}
		}

		/// <summary>
		/// g[Neł邩ǂ_l擾܂B
		/// </summary>
		public bool IsLiteral
		{
			get
			{
				if(token == null)
					return false;
				return IsInt || IsFloat || IsString || token == "null";
			}
		}


		/// <summary>
		/// g[Nint^̃eł邩ǂ_l擾܂B
		/// </summary>
		public bool IsInt
		{
			get
			{
				if(token == null)
					return false;
				Regex regex = new Regex(@"^[1-9][0-9]*$|^0$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[Nfloat^̃eł邩ǂ_l擾܂B
		/// </summary>
		public bool IsFloat
		{
			get
			{
				if(token == null)
					return false;
				Regex regex = new Regex(@"^[1-9][0-9]*\.[0-9]+$|^0\.[0-9]+$");
				return regex.IsMatch(token);
			}
		}

		/// <summary>
		/// g[Nstring^̃eł邩ǂ_l擾܂B
		/// </summary>
		public bool IsString
		{
			get
			{
				if(token == null)
					return false;
				Regex regex = new Regex(@"^""[^""]*""$");
				return regex.IsMatch(token);
			}
		}
	}
}
