// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionTable.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ֐̏ꏊi[邽߂̃e[ułB
	/// FunctionTypeL[Ƃ
	/// FunctionDefinitionNodei[ReiƂȂ܂B
	/// </summary>
	public class FunctionTable
	{
		/// <summary>
		/// ֐ʒuێnbV
		/// </summary>
		Hashtable hash = new Hashtable();

		/// <summary>
		/// RXgN^
		/// </summary>
		public FunctionTable() {}

		/// <summary>
		/// w肳ꂽ^Cv̊֐邩ǂf܂B
		/// </summary>
		/// <param name="ft">֐̃^Cv</param>
		/// <returns>֐݂邩ǂ_lłB</returns>
		public bool ContainsFunctionType(FunctionType ft)
		{
			return hash.ContainsKey(ft);
		}

		/// <summary>
		/// ׂĂ̗vf폜܂B
		/// </summary>
		public void Clear()
		{
			hash.Clear();
		}

		/// <summary>
		/// ֐^CvL[ƂĊ֐ʒu擾܂͐ݒ肵܂B
		/// </summary>
		public FunctionDefinitionNode this[FunctionType ft]
		{
			get { return (FunctionDefinitionNode)hash[ft]; }
			set { hash[ft] = value; }
		}
	}
}
