// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2005 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ConfigFile.cs 283 2010-03-05 22:15:12Z panacoran $

using System;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;

namespace Protra.Lib
{
	/// <summary>
	/// ݒt@CǂݏB
	/// </summary>
    public class ConfigFile
    {
        private Dictionary<string, string> hash = new Dictionary<string, string>();
        private string filename;

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="configName"></param>
        public ConfigFile(string configName)
        {
            filename = Path.Combine(Global.DirConf, configName + ".conf");
        }

        /// <summary>
        /// t@C擾B
        /// </summary>
        public string Filename
        {
            get { return filename; }
        }

        /// <summary>
        /// ݒt@CǂݍށB
        /// </summary>
        public void Read()
        {
            StreamReader reader = new StreamReader(filename);
            string line;
            Regex regex = new Regex(@"^([^=]+)=(.*)$");
            while ((line = reader.ReadLine()) != null)
            {
                Match m = regex.Match(line);
                if (m.Success)
                    hash[m.Groups[1].Value] = m.Groups[2].Value;
            }
            reader.Close();
        }

        /// <summary>
        /// ݒt@CށB
        /// </summary>
        public void Write()
        {
            if (!Directory.Exists(Global.DirConf))
                Directory.CreateDirectory(Global.DirConf);
            StreamWriter writer = new StreamWriter(filename);
            List<string> keys = new List<string>(hash.Keys);
            keys.Sort();
            foreach (string key in keys)
                if (hash[key] != null)
                    writer.WriteLine(key + "=" + (string)hash[key]);
            writer.Close();
        }

        /// <summary>
        /// ݒe擾܂͐ݒ肷B
        /// </summary>
        public string this[string key]
        {
            get
            {
                try
                {
                    return (string)hash[key];
                }
                catch (KeyNotFoundException)
                {
                    return null;
                }
            }
            set { hash[key] = value; }
        }
    }
}
