// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: StackArea.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// [Jϐ̃e[uvbVX^bNB
	/// </summary>
	public class StackArea
	{
		/// <summary>
		/// IuWFNgێ郊Xg
		/// </summary>
		private ArrayList list = new ArrayList();

		/// <summary>
		/// RXgN^
		/// </summary>
		public StackArea() {}

		/// <summary>
		/// [Jϐ̃e[uvbV܂B
		/// </summary>
		/// <param name="vt">[Jϐ̃e[u</param>
		public void Push(VariableTable vt)
		{
			list.Add(vt);
		}

		/// <summary>
		/// [Jϐ̃e[u|bv܂B
		/// </summary>
		/// <returns>|bvꂽIuWFNgłB</returns>
		public VariableTable Pop()
		{
			VariableTable vt = (VariableTable)list[list.Count - 1];
			list.RemoveAt(list.Count - 1);
			return vt;
		}

		/// <summary>
		/// ׂĂ̗vf폜܂B
		/// </summary>
		public void Clear()
		{
			list.Clear();
		}

		/// <summary>
		/// X^bN̗vf擾܂B
		/// </summary>
		/// <returns>vf̐łB</returns>
		public int Count
		{
			get{ return list.Count; }
		}

		/// <summary>
		/// X^bN̐擪ɂIuWFNg擾܂B
		/// </summary>
		public VariableTable Top
		{
			get{ return (VariableTable)list[list.Count - 1]; }
		}
	}
}
