﻿// Copyright(C) 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: OverwriteDialog.cs 389 2010-11-28 06:45:45Z panacoran $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Protra.Lib.Dialogs
{
    /// <summary>
    /// ファイルの上書きについて質問するダイアログボックスです。
    /// </summary>
    public partial class OverwriteDialog : Form
    {
        /// <summary>
        /// 表示するファイル名を設定する。
        /// </summary>
        public string File
        {
            set
            {
                labelMessage.Text = value + "は存在します。上書きしますか？";
            }
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OverwriteDialog()
        {
            InitializeComponent();
        }
    }
}
