// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004, 2005 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Market.cs,v 1.8 2008-02-03 13:27:08 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Db
{
	/// <summary>
	/// MarketId\񋓌^B
	/// </summary>
	public enum MarketId
	{
		/// <summary>
		/// 1
		/// </summary>
		Tokyo1 = 1,
		/// <summary>
		/// 2
		/// </summary>
		Tokyo2,
		/// <summary>
		/// }U[Y
		/// </summary>
		Mothers,
		/// <summary>
		/// ؊O
		/// </summary>
		TokyoForeign,
		/// <summary>
		/// 1
		/// </summary>
		Osaka1,
		/// <summary>
		/// 2
		/// </summary>
		Osaka2,
		/// <summary>
		/// wNX
		/// </summary>
		Hercules,
		/// <summary>
		/// 1
		/// </summary>
		Nagoya1,
		/// <summary>
		/// 2
		/// </summary>
		Nagoya2,
		/// <summary>
		/// Jasdaq
		/// </summary>
		Jasdaq,
		/// <summary>
		/// ől
		/// </summary>
		Max = Jasdaq
	}

	/// <summary>
	/// Markete[ũR[h\NXłB
	/// </summary>
	public class Market: IRecord
	{
		private MarketId id;
		private string name;

		/// <summary>
		/// ̃RXgN^
		/// </summary>
		public Market() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		public Market(MarketId id, string name)
		{
			this.id = id;
			this.name = name;
		}

		/// <summary>
		/// sID擾B
		/// </summary>
		public MarketId Id
		{
			get { return id; }
		}

		/// <summary>
		/// sꖼ擾邢͕ύXB
		/// </summary>
		public string Name
		{
			get { return name; }
			set { 
				MarketTable.ChangeMarketName(id, value);
				name = value;
			}
		}

		/// <summary>
		/// f[^x[X̃R[hIuWFNgɕϊB
		/// </summary>
		/// <param name="values">lCeBu`̒l̔z</param>
		/// <returns>ϊMarketIuWFNgԂB</returns>
		public Object ToObject(Object[] values)
		{
			return new Market((MarketId)values[0], // @Id
							  (string)values[1]); // @Name
		}
	}

	/// <summary>
	/// Markete[u𑀍삷B
	/// ̃NX͍ŏɂׂẴR[hzɓǂݍށBꕔ̃\bhz̃CfbNX+1R[h@Idƈv邱Ƃ肵ĂBMarkete[uspӂɕҏWƂ̉肪̂ŗvӁB
	/// </summary>
	public class MarketTable
	{
		private static Connection conn;
		private static Connection Conn
		{
			get 
			{
				if (conn != null)
					return conn;
				conn = new Connection("protra");
				return conn;
			}
		}

		private static Market[] byId;

		/// <summary>
		/// ׂẴR[hێz擾B
		/// </summary>
		private static Market[] ById
		{
			get {
				if (byId != null)
					return byId;
				string sql = "SELECT * FROM Market ORDER BY @Id";
				ArrayList list = Conn.Query(sql, new Market());
				byId = (Market[])list.ToArray(typeof(Market));
				return byId;
			}
		}

		/// <summary>
		/// w肳ꂽsID̃R[h擾B
		/// </summary>
		/// <param name="id">sID</param>
		/// <returns>MarketIuWFNgԂB</returns>
		public static Market GetRecord(MarketId id) 
		{
			return ById[(int)id - 1];
		}

		/// <summary>
		/// ׂẴR[h擾B
		/// </summary>
		/// <returns>MarketIuWFNg̔zԂB</returns>
		public static Market[] GetAllRecords()
		{
			return ById;
		}

		/// <summary>
		/// sꖼύXB
		/// </summary>
		/// <param name="id">sꃊXgID</param>
		/// <param name="name">VO</param>
		public static void ChangeMarketName(MarketId id, string name)
		{
			string sql = string.Format(
				"UPDATE Market SET @Name='{0}' WHERE @Id={1}", name, (int)id);
			Conn.Execute(sql);
		}

		/// <summary>
		/// Sf[^폜B
		/// </summary>
		public static void Delete()
		{
			string sql = "DELETE FROM Market";
			Conn.Execute(sql);
		}
	}
}
