#include "common.h"
#include <zlib.h>

#define BUF_WRITE	65535


// obt@TCY
#define		IN_BUFSIZE		65536	// ͗p
#define		OUT_BUFSIZE		65536	// o͗p
#define		GZ_WINBITS		(15 + 16)


// o͗p̍\
typedef struct Cio
{
	SceUID		in;		// ̓t@C
	SceUID		out;		// o̓t@C
	u8			out_f;

	u32			size_in;

	z_stream	z;	// kp̍\

	u8			type;

	unsigned char *in_buf;		// ͗p̃obt@
	unsigned char *out_buf;		// o͗pobt@
}	Cio, *hCio;

typedef struct
{
	SceUID  blockId;
	SceSize size;
} memory_header;


static u32 mem_num = 0;


extDirObj* extDirOpen(const char *path)
{
	extDirObj *obj = memoryAlloc(sizeof(extDirObj));

	if( obj == NULL ) return NULL;

	memset(obj,0,sizeof(extDirObj));

	obj->dp = sceIoDopen(path);

	if( obj->dp < 0 )
	{
		extDirClose( obj );
		return NULL;
	}

	//strcpy(obj->root,path);

	return obj;
}

extDirEnt* extDirNext( extDirObj *obj )
{
	extDirEnt *ent = NULL;

	if( obj == NULL || obj->dp < 0 ) return NULL;

	ent = memoryAlloc(sizeof(extDirEnt));

	if( ent == NULL ) return NULL;

	memset(&(ent->entry), 0, sizeof(ent->entry));

	if( sceIoDread(obj->dp, &(ent->entry)) <= 0 )
	{
		memoryFree(ent);
		return NULL;
	}

	if(	obj->ent_root == NULL )
	{
		ent->ent_prev = NULL;
		ent->ent_next = NULL;

		obj->ent_root = ent;
	}
	else
	{
		ent->ent_prev = obj->ent_old;
		ent->ent_next = NULL;

		obj->ent_old->ent_next = ent;
	}

	obj->ent_old = ent;

	return ent;
}


void extDirClose( extDirObj *obj )
{
	extDirEnt *ent = obj->ent_root;
	extDirEnt *ent_p = NULL;

	while( ent )
	{
		ent_p = ent->ent_next;

		memoryFree(ent);

		ent = ent_p;
	}

	memoryFree(obj);
}


int extDirEntType( extDirEnt *ent )
{
	if( FIO_S_ISDIR(ent->entry.d_stat.st_mode) )
	{
		if( strcmp(ent->entry.d_name, ".") == 0 || strcmp(ent->entry.d_name, "..") == 0 )
		{
			return extEnt_Invalid;
		}
		else
		{
			return extEnt_Dir;
		}
	}
	else
	{
		return extEnt_File;
	}
}

//void read_dir(const char *path)
//{
//	SceUID dp;
//	SceIoDirent entry;
//
//	dp = sceIoDopen(path);
//
//	if(dp >= 0)
//	{
//		memset(&entry, 0, sizeof(entry));
//
//		while( sceIoDread(dp, &entry) > 0 )
//		{
//			switch( entry.d_stat.st_mode & FIO_S_IFMT )
//			{
//				case FIO_S_IFREG:
//				{
//					printf("%s/%s [FILE]\n",path,entry.d_name);
//
//					break;
//				}
//
//				case FIO_S_IFDIR:
//				{
//					if((strcmp(&entry.d_name[0], ".") != 0) && (strcmp(&entry.d_name[0], "..") != 0))
//					{
//						printf("%s/%s [DIR]\n",path,entry.d_name);
//					}
//
//					break;
//				}
//			}
//		}
//
//		sceIoDclose(dp);
//	}
//}






int Sync_sceIoMkdir(const char *root,const char *dir,SceMode mode)
{
	char path[512];
	int ret = 0;

	sprintf(path,"%s%s",root,dir);
	ret = sceIoMkdir(path, 0777);

	return ret;
}





void ErrorExit(int milisecs, char *fmt, ...)
{
	va_list list;
	char msg[256];
	
	va_start(list, fmt);
	vsprintf(msg, fmt, list);
	va_end(list);
	
	printf(msg);
	
	//sceKernelDelayThread(milisecs*1000);
	
	printf("\n\nPress X to exit\n");
	
	while (1)
	{
		SceCtrlData pad;
		sceCtrlReadBufferPositive(&pad, 1);
		
		if (pad.Buttons & PSP_CTRL_CROSS)	break;
		
		sceKernelDelayThread(10000);
	}
	
	
	sceKernelExitGame();
}






int ReadFile(const char *file,  void *buf, SceSize seek, SceSize size)
{
	SceUID fd = sceIoOpen(file, PSP_O_RDONLY, 0);
	
	if (fd < 0)	return fd;

	if( seek) sceIoLseek(fd,seek,SEEK_SET);
	
	int read = sceIoRead(fd, buf, size);
	
	sceIoClose(fd);
	return read;
}

int Write(u8 flag, SceUID fd_out, const char *file, void *buf, int size)
{
	if( buf == NULL )	return -1;

	if( fd_out == -1 && file != NULL)
	{
		fd_out = sceIoOpen(file, PSP_O_WRONLY | PSP_O_CREAT | PSP_O_TRUNC, 0777);
	}
	
	if( fd_out < 0 )	return -1;
	
	int written = sceIoWrite(fd_out, buf, size);
	
	if( !flag ) sceIoClose(fd_out);

	return written;
}






u32 WriteAppend(u8 type_file, u8 flag, const char *out, SceUID fd_out, const char *in, int seek, u8 *buf, SceSize size)
{
	SceSize ret = size;
	SceUID fd_in = -1;


	if( fd_out == -1 && out != NULL )
	{
		fd_out = sceIoOpen(out, PSP_O_WRONLY|PSP_O_APPEND|PSP_O_CREAT, 0777);
	}

	if ( fd_out < 0  )	goto Err_WriteAppend;

	if( type_file && in != NULL )
	{
		u8 buf_in[BUF_WRITE];
		u32 pos = seek ,last = seek + size;
		u32 read ;

		fd_in = sceIoOpen(in, PSP_O_RDONLY, 0);

		if ( fd_in < 0  )
		{
			ret = 0;
			goto Err_WriteAppend;
		}


		if( seek ) pos = sceIoLseek32(fd_in,seek,SEEK_SET);

		while( pos < last )
		{
			if( (pos + BUF_WRITE) > last )
			{
				read = last - pos;
			}
			else
			{
				read = BUF_WRITE;
			}

			if( sceIoRead(fd_in,buf_in,read) != read )
			{
				ret = 0;
				break;
			}

			sceIoWrite(fd_out,buf_in,read);

			pos += read;
		}
	}
	else
	{
		if( sceIoWrite(fd_out,buf,size) != size ) ret = 0;
	}

Err_WriteAppend:

	if( fd_in >= 0 ) sceIoClose(fd_in);
	if( !flag && fd_out >= 0 ) sceIoClose(fd_out);

	return ret;
}


SceSize GetSize( const char *file )
{
	SceSize size;
	SceUID fd = sceIoOpen(file, PSP_O_RDONLY, 0);

	
	if (fd < 0)	return 0;

	size = sceIoLseek(fd,0,SEEK_END);
	
	sceIoClose(fd);

	return size;
}






// o̓t@C
static void gzClose( hCio h )
{
	// ǩЕt,\̂j

	if( h->type == MODE_DEFLATE )
	{
		deflateEnd( &h->z );
	}
	else if( h->type == MODE_INFLATE )
	{
		inflateEnd( &h->z );
	}

	if( h->in_buf ) memoryFree(h->in_buf);
	if( h->out_buf ) memoryFree(h->out_buf);

	if ( h->in >= 0 )
	{
		sceIoClose( h->in );
	}

	if ( h->out >= 0 && h->out_f == 0 )
	{
		sceIoClose( h->out );
	}
}

// o̓t@CJ
// sꍇCin  out  NULL ɂ -1 Ԃ
static int gzOpen( hCio h, u8 type, const char *out_path, SceUID out_fd, const char *in_path, int seek_in, int size_in )
{
	if( size_in <= 0 ) return -1;

	memset( h, 0, sizeof(Cio) );

	h->type	= type;
	h->in	= sceIoOpen(in_path, PSP_O_RDONLY, 0);

	if( h->in < 0 ) return -1;

	if( out_fd != -1 )
	{
		h->out		= out_fd;
		h->out_f	= 1;
	}
	else
	{
		h->out	= sceIoOpen(out_path, PSP_O_WRONLY | PSP_O_CREAT | PSP_O_TRUNC, 0777);
	}

	if( h->out < 0 ) return -1;

	h->in_buf	= memoryAlloc( IN_BUFSIZE );// ͗p̃obt@
	h->out_buf	= memoryAlloc( OUT_BUFSIZE );//malloc(OUT_BUFSIZE);		// o͗pobt@

	if( h->in_buf == NULL || h->out_buf == NULL ) return -1;

	if( seek_in )
	{
		if( sceIoLseek32(h->in,seek_in,SEEK_SET) != seek_in ) return -1;
	}

	h->size_in = size_in;

	return	0;
}

// o̓obt@ɂ
static u32 gzFlush( hCio h )
{
	u32 wbyte = OUT_BUFSIZE - h->z.avail_out;

	// o̓t@Cւ̏
	if ( sceIoWrite(h->out,h->out_buf, wbyte) != wbyte )
	{
		printf("write err\n");
		return 0;
	}
	
	h->z.next_out	= h->out_buf;
	h->z.avail_out	= OUT_BUFSIZE;

	return wbyte;
}




// k
static int gzWork( hCio h )
{
	int	ret;
	int	flush = Z_NO_FLUSH;
	u32 total = 0;
	u32 wret;
	int (*decode)(z_streamp strm, int flush) = NULL;
	

	// mۂ̓CuɔC
	h->z.zalloc	= Z_NULL;
	h->z.zfree	= Z_NULL;
	h->z.opaque	= Z_NULL;

	// kp̍\̂

	if( h->type == MODE_DEFLATE )
	{
		ret		= deflateInit2(&h->z, Z_DEFAULT_COMPRESSION, Z_DEFLATED, GZ_WINBITS, 8, Z_DEFAULT_STRATEGY);
		decode	= deflate;
	}
	else if( h->type == MODE_INFLATE )
	{
		ret		= inflateInit2( &h->z,GZ_WINBITS );
		decode	= inflate;
	}
	else
	{
		return 0;
	}

	if( ret != Z_OK ) return 0;

	// o͂
	h->z.next_in	= h->in_buf;
	h->z.avail_in	= 0;
	h->z.next_out	= h->out_buf;
	h->z.avail_out	= OUT_BUFSIZE;

	//printf("init ok = %x\n",h->size_in );
	// k̃[v

	while ( ( ret = decode( &h->z, flush ) ) != Z_STREAM_END )
	{
		switch ( ret )
		{
			case	Z_OK:			// Ȃ
			case	Z_BUF_ERROR:	// ̓obt@󂩏o̓obt@t
			{
				// ̓obt@𖄂߂
				if ( !h->z.avail_in )
				{
					h->z.next_in	= h->in_buf;

					SceSize read = 0;

					if( h->size_in >= IN_BUFSIZE )
					{
						read = IN_BUFSIZE;
					}
					else
					{
						read = h->size_in;
						flush = Z_FINISH;
					}

					//printf("read = %d\n",h->size_in);

					h->z.avail_in	= sceIoRead(h->in,h->in_buf,read);
					h->size_in		-= read;

					//ǂݍݎs
					if ( h->z.avail_in != read ) return 0;

				}

				// o̓obt@ɂ
				if ( !h->z.avail_out  )
				{
					wret = gzFlush( h );

					// o̓t@Cւ̏
					if( wret == 0 ) return 0;
					
					total += wret;
				}

				break;
			}

			case	Z_NEED_DICT:	// Kv
			case	Z_DATA_ERROR:	// sȃf[^
			{
				return 0;
			}

			case	Z_STREAM_ERROR:
			{
				printf("Z_STREAM_ERROR\n");
				return	0;
			}
		}
	}

	//printf("comp loop ok\n");

	// o̓obt@̎co̓t@Cɏo
	if( OUT_BUFSIZE - h->z.avail_out )
	{
		if( (wret = gzFlush(h)) == 0 ) return 0;

		total += wret;
	}


	return total;
}


u32 gz(u8 type, const char *file_out, SceUID out_fd,const char *file_in,  int seek_in, int size_in )
{
	int	ret = 0;
	Cio		io;

	// o̓t@CJ
	if ( gzOpen( &io, type, file_out,out_fd, file_in, seek_in, size_in ) == 0 )
	{
		// k
		//printf("open ok\n");
		ret = gzWork( &io );
	}

	// o̓t@C
	gzClose( &io );

	return	ret;
}

static char rpath[256];
static char tpath[256];

const char* bulidOutPath( const char *file )
{
	char *p = strrchr(file,'/');

	//printf("bpath len = %d[%s]\n",strlen(p),p);

	if( p == NULL || strlen(p) == 1 ) return NULL;

	sprintf(rpath,"%s%s",rpath,p+1);

	return (const char *)rpath;
}


void setPathRoot( const char *path )
{
	strcpy(rpath,path);
}

void setPathTmp( const char *path )
{
	strcpy(tpath,path);
}


const char* getPathRoot()
{
	return (const char*)rpath;
}
	

const char* getPathTmp()
{
	return (const char*)tpath;
}


#define	STR_MAX_DEF	512

void Log(u8 use_time, const char *format, ...)
{
	SceUID file; 
	char path[STR_MAX_DEF]		= {'\0'};
	char va_str[STR_MAX_DEF]	= {'\0'};


	va_list ap;

	snprintf(path,STR_MAX_DEF,"%slog.txt",getPathRoot());
	if( (file = sceIoOpen (path, PSP_O_WRONLY|PSP_O_APPEND|PSP_O_CREAT, 0777)) < 0 ) return;//t@CI[vs


	if( use_time )
	{
		pspTime time;
		char time_str[10]			= {'\0'};

		//擾s烍O͏o͂Ȃ
		if(sceRtcGetCurrentClockLocalTime(&time) < 0 ) return;

		//găOt@Cp̃tH[}bg쐬
		snprintf(time_str,10,"%02d:%02d:%02d ",time.hour,time.minutes,time.seconds);
		sceIoWrite(file, time_str, strlen(time_str));
	}

	//όăOp̕񐶐
	va_start( ap, format );
	vsnprintf( va_str, STR_MAX_DEF, format, ap );
	va_end( ap );


	sceIoWrite(file, va_str, strlen(va_str));
	
	sceIoClose(file);
}






void* memoryAlloc( SceSize size )
{
	char mem_name[32];

	sprintf(mem_name,"malloc_%0X8",mem_num);

	void *mem = memoryAllocEx( mem_name	, MEMORY_USER, 0, size, PSP_SMEM_Low );
	
	if( !mem )
	{
		mem = memoryAllocEx( mem_name, MEMORY_USER, 0, size, PSP_SMEM_High );
	}

	return mem;
}

int memoryFree( void *memblock )
{
	if( ! memblock ) return 0;

	memory_header *header = (memory_header*)( (uintptr_t)memblock - sizeof(memory_header) );

	mem_num--;
	
	return sceKernelFreePartitionMemory( header->blockId );
}



void* memoryAllocEx( const char *name, MemoryPartition partition, u32 align, SceSize size, int type )
{
	if( ! size ) return NULL;

	memory_header header;
	void *memblock;
	SceSize real_size = MEMORY_PAGE_SIZE * (u32)ceil( (double)size / (double)MEMORY_PAGE_SIZE );
	// MEMORY_PAGE_SIZE؂̎ۂɊmۂꂽlɕ␳
	
	header.blockId	= sceKernelAllocPartitionMemory( partition, name, type, sizeof(memory_header) + real_size + align, NULL );
	header.size		= real_size; 	

	if( header.blockId < 0 ) return NULL;

	
	//InfovXAhXԂ
	memblock = (void *)( (uintptr_t)(sceKernelGetBlockHeadAddr( header.blockId )) + sizeof(memory_header) );

	if( align )
	{
		if( ! MEMORY_POWER_OF_TWO( align ) )
		{
			sceKernelFreePartitionMemory( header.blockId );
			return NULL;
		}

		memblock = (void *)MEMORY_ALIGN_ADDR( align, memblock );
	}
	
	memcpy( (void *)( (uintptr_t)memblock - sizeof(memory_header) ), (void *)&header, sizeof(memory_header) );

	mem_num++;
	
	return memblock;
}




int GetFileSig( const char *file ,int seek )
{
	u32 signature;

	//PBP/ELFt@C̃^Cv擾
	if( ReadFile( file,&signature, seek, sizeof(signature)) != sizeof(signature) ) return SIGNATURE_ERR;
	

	switch( signature )
	{
		case SIGNATURE_PSP	:
		case SIGNATURE_PBP	:
		case SIGNATURE_ELF	:
		case SIGNATURE_PSAR	:
		case SIGNATURE_PSF	:
		case SIGNATURE_SCE	:
		{
			return signature;
		}
	}

	return SIGNATURE_ERR;
};
