#include "common.h"

#include "unpackpsar.h"
#include "packer.h"
#include "usb.h"

PSP_MODULE_INFO("PSP_Ex_Tools", PSP_MODULE_USER, 1, 1);
PSP_MAIN_THREAD_ATTR(0);


#define	MODE_PACK	0
#define	MODE_UNPACK	1

const char *ret_str = NULL;

void GetErrStr( const char *file ,int mode ,int ret )
{
	ret_str = "No Support File.";

	switch( ret )
	{
		//case 	extErr_GetSg	:
		//case 	extErr_GetSc	:
		//case 	extErr_GetSList	:
		//{
		//	ret_str = "No Support File.";
		//	break;
		//}

		case	extErr_PbpK		:
		{
			ret_str = "No PBP Kernel support.";
			break;
		}

		case	extErr_VshPrx	:
		{
			ret_str = "No VSH prx support.";
			break;
		}

		case	extErr_PbpAttr	:
		{
			ret_str = "PBP(DATA.PSP) attribute is Not 0x200.";
			break;
		}

		case extErr_Write		:
		{
			ret_str = "Write Err.";
			break;
		}

		case extErr_Packed		:
		{
			if( mode == MODE_PACK )
			{
				ret_str = "Already packed.";
			}

			break;
		}

		case extErr_NotPack		:
		{
			if( mode == MODE_UNPACK )
			{
				ret_str = "Already Unpacked.";
			}

			break;
		}
	}
}


int main(void)
{
	int mode = -1;
	int opt = 0;
	int opt_old = opt;

	pspDebugScreenInit();
	

	SceUID mod = pspSdkLoadStartModule("Bridge.prx", PSP_MEMORY_PARTITION_KERNEL);
	if (mod < 0)
	{
		ErrorExit(5000, "Error 0x%08X loading/starting Bridge.prx.\n", mod);
	}
	

	sceIoMkdir("ms0:/PSPExT", 0777);

	//pspDebugScreenSetTextColor(COLOR_W);
	printf("PSP Extra Tools v0.1(Beta)\n\n");

	pspDebugScreenSetTextColor(COLOR_B);
	printf("Pack  ");
	pspDebugScreenSetTextColor(COLOR_W);
	printf(" File = CIRCLE [ Option : 0x%02X ]\n\n",opt);
	printf("Add/Rmv Pack Option\n");
	printf("Ltrigger = Use SceHeader.                      [ 0x01 ]\n");
	printf("Rtrigger = Enable Fix PBP(DATA.PSP) Attr 0x200 [ 0x02 ]\n\n");

	pspDebugScreenSetTextColor(COLOR_G);
	printf("Unpack");
	pspDebugScreenSetTextColor(COLOR_W);
	printf(" File = SQUARE\n");


	while (1)
	{
		SceCtrlData pad;
		
		sceCtrlReadBufferPositive(&pad, 1);
		
		if (pad.Buttons & PSP_CTRL_CIRCLE)
		{
			mode = MODE_PACK;
			break;
		}
		else if (pad.Buttons & PSP_CTRL_SQUARE)
		{
			mode = MODE_UNPACK;
			break;
		}
		
		if (pad.Buttons & PSP_CTRL_LTRIGGER )
		{
			if( opt & pspPackOpt_USE_SCE_H )
			{
				opt &= ~pspPackOpt_USE_SCE_H;
			}
			else
			{
				opt |= pspPackOpt_USE_SCE_H;
			}
		}
		
		if ( pad.Buttons & PSP_CTRL_RTRIGGER )
		{
			if( opt & pspPackOpt_FIX_PBP_ATTR )
			{
				opt &= ~pspPackOpt_FIX_PBP_ATTR;
			}
			else
			{
				opt |= pspPackOpt_FIX_PBP_ATTR;
			}
		}

		if( opt != opt_old )
		{
			opt_old = opt;

			pspDebugScreenSetXY(6,2);
			printf(" File = CIRCLE [ Option : 0x%02X ]\n",opt);
		}
		
		sceKernelDelayThread(100000);
	}

	pspDebugScreenClear();
	printf("%sing File\n\n",(mode == MODE_PACK ? "Pack" : "Unpack") );


	extDirObj *obj = extDirOpen(EXT_PATH_ROOT);
	extDirEnt *ent = NULL;

	if( obj )
	{
		while( (ent = extDirNext(obj)) )
		{	
			if( extDirEntType(ent) == FIO_S_IFREG )
			{
				char name[256];
				ret_str = "Success.";
				int ret;
				
				sprintf(name,"%s/%s",EXT_PATH_ROOT,ent->entry.d_name);

				if( mode == MODE_PACK )
				{
					ret = pspPack(name,FILE_TMP_NAME,opt);
				}
				else
				{
					ret = pspUnpack(name,FILE_TMP_NAME);
				}

				if( ret == 0 )
				{
					sceIoRemove(name);
					sceIoRename(FILE_TMP_NAME,ent->entry.d_name);
				}
				else
				{
					GetErrStr(name,mode,ret);
				}
				
				pspDebugScreenSetTextColor(COLOR_G);
				printf(ent->entry.d_name);
				pspDebugScreenSetTextColor(COLOR_W);
				printf(" = %s (ErrCode:%d)\n",ret_str,ret);
			}
		}
	}
	else
	{
		printf("Not Found '%s'.\n",EXT_PATH_ROOT);
	}

	extDirClose(obj);


	sceKernelDelayThread(1000000);
    scePowerTick(0);
	ErrorExit(10000, "\n\nPress X to exit\n");
	
    return 0;
}






