#include "packer.h"
#include "decrypt.h"
//#include "memory.h"

/*#define	ErrMakeHeader(fmt,...)	printf( fmt, ## __VA_ARGS__ );		*/	

#define	ErrMakeHeader(code)			{									\
										ret = code;						\
										goto Err_MakeHeader;			\
									}									


#define	ErrPspPack(code)			{						\
										ret = code;			\
										goto Err_pspPack;	\
									}									

#define	ErrPspUnpack(code)			{						\
										ret = code;			\
										goto Err_pspUnpack;	\
									}	


#define	SIZE_HEADER_SCE		0x40
#define	SIZE_HEADER_PSP		0x150
#define	SIZE_HEADER_FULL	( SIZE_HEADER_SCE + SIZE_HEADER_PSP )

#define	sce_header	( opt & pspPackOpt_USE_SCE_H )


typedef struct
{
	u32		signature;			// 0
	u16		attribute;			// 4  modinfo
	u16		comp_attribute;		// 6
	u8		module_ver_lo;		// 8
	u8		module_ver_hi;		// 9
	char	modname[28];		// 0A
	u8		version;			// 26
	u8		nsegments;			// 27
	int		elf_size;			// 28
	int		psp_size;			// 2C
	u32		entry;				// 30
	u32		modinfo_offset;		// 34
	int		bss_size;			// 38
	u16		seg_align[4];		// 3C
	u32		seg_address[4];		// 44
	int		seg_size[4];		// 54
	u32		reserved[5];		// 64
	u32		devkitversion;		// 78
	u32		decrypt_mode;		// 7C 
	u8		key_data0[0x30];	// 80
	int		comp_size;			// B0
	int		_80;				// B4
	int		reserved2[2];		// B8
	u8		key_data1[0x10];	// C0
	u32		tag;				// D0
	u8		scheck[0x58];		// D4
	u32		key_data2;			// 12C
	u32		oe_tag;				// 130
	u8		key_data3[0x1C];	// 134
} __attribute__((packed)) PSP_Header;

typedef struct 
{ 
	u32 e_magic;	//0
	u8	e_class;	//4
	u8	e_data;		//5
	u8	e_idver;	//6
	u8	e_pad[9];	//7,8,9,a,b,c,d,e,f
	u16 e_type;		//10
    u16 e_machine;	//12
    u32 e_version;	//14
    u32 e_entry;	//18
    u32 e_phoff;	//1c
    u32 e_shoff;	//20
    u32 e_flags; 
    u16 e_ehsize; 
    u16 e_phentsize; 
    u16 e_phnum; 
    u16 e_shentsize;//2 
    u16 e_shnum;	//30
    u16 e_shstrndx;	//32
}  Elf32_Ehdr;//34

//3 + 8   11
//16 * 8  16
//32 * 6  24

typedef struct 
{ 
	u32 p_type; 
	u32 p_offset; 
	u32	p_vaddr; 
	u32	p_paddr; 
    u32	p_filesz; 
    u32	p_memsz; 
    u32	p_flags; 
    u32 p_align; 
} __attribute__((packed)) Elf32_Phdr;//20

typedef struct 
{ 
	u32 sh_name; 
	u32 sh_type; 
	u32 sh_flags; 
	u32 sh_addr; 
	u32 sh_offset; 
	u32 sh_size; 
	u32 sh_link; 
	u32 sh_info; 
	u32 sh_addralign; 
	u32 sh_entsize; 
} __attribute__((packed)) Elf32_Shdr;//28

typedef struct 
{
	u16		attribute;
	u8		module_ver_lo;	
	u8		module_ver_hi;
	char	modname[28];
} __attribute__((packed)) PspModuleInfo;//20


typedef struct
{
	u8 h_sce[64];
	PSP_Header h_psp;
} __attribute__((packed)) pack_header;
	


typedef struct tagInfo
{
	u32 psp_tag;
	u32 oe_tag;
} tagInfo;

enum moduleType
{
	MODULE_KERNEL,
	MODULE_USER,
	MODULE_PBP
};

static tagInfo tags[] =
{
	{ 0xDADADAF0, 0x55668D96 },
	{ 0x457B06F0, 0x8555ABF2 },
	{ 0xADF305F0, 0x7316308C },
};



static u8 h_sce[64] = 
{
	0x7E, 0x53, 0x43, 0x45, 0x40, 0x00, 0x00, 0x00, 0x5C, 0x79, 0x72, 0x3D, 0x6B, 0x68, 0x5A, 0x30, 
	0x5C, 0x7D, 0x34, 0x67, 0x57, 0x59, 0x34, 0x78, 0x79, 0x8A, 0x4E, 0x3D, 0x47, 0x4B, 0x44, 0x44, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};



int GenRandom( void *buf, int size)
{
	u8 tmp[0x14];
	u8 *buf_p = (u8*)buf;
	int i;

	memset(buf,0,size);

	while( size )
	{
		if( KIRK_Random(&tmp) < 0 ) break;

		for(i = 1 ; i < 0x14 ; i++)
		{
			tmp[0] ^= tmp[i];
		}

		*buf_p = tmp[0];
		buf_p++;
		size--;
	}

	return size;
}





int MakeHeader(const char *file ,pack_header *header_pack ,SceSize size ,SceSize seek ,int pbp ,int opt)
{
	Elf32_Ehdr elf_header;
	PspModuleInfo modinfo;
	int i ,ret = 0,v_size;

	Elf32_Phdr *segments	= NULL;
	Elf32_Shdr *sections	= NULL;
	u8 *strtab_list			= NULL;

	// Fill simple fields
	header_pack->h_psp.signature		= SIGNATURE_PSP;
	header_pack->h_psp.comp_attribute	= 1;
	header_pack->h_psp.version			= 1;
	header_pack->h_psp.elf_size			= size;
	header_pack->h_psp._80				= 0x80;


	if( ReadFile(file,&elf_header, seek, sizeof(elf_header)) != sizeof(elf_header) ) ErrMakeHeader(extErr_GetElfH);
	
	// Fill fields from elf header
	header_pack->h_psp.entry		= elf_header.e_entry;
	header_pack->h_psp.nsegments	= (elf_header.e_phnum > 2) ? 2 : elf_header.e_phnum;

	// Fill segements
	if( (v_size = header_pack->h_psp.nsegments * sizeof(Elf32_Phdr)) > 0 )
	{
		if( (segments = memoryAlloc(v_size)) == NULL ) ErrMakeHeader(extErr_GetSg);

		if( ReadFile(file,segments, seek+elf_header.e_phoff, v_size) != v_size ) ErrMakeHeader(extErr_GetSg);

		for (i = 0; i < header_pack->h_psp.nsegments; i++)
		{
			header_pack->h_psp.seg_align[i]		= segments[i].p_align;
			header_pack->h_psp.seg_address[i]	= segments[i].p_vaddr;
			header_pack->h_psp.seg_size[i]		= segments[i].p_memsz;
		}

		// Fill module info fields
		header_pack->h_psp.modinfo_offset		= segments[0].p_paddr;
	}
	else
	{
		ErrMakeHeader(extErr_GetSg);
	}



	if( ReadFile(file,&modinfo,seek + (header_pack->h_psp.modinfo_offset&0x7FFFFFFF), sizeof(modinfo)) != sizeof(modinfo) ) ErrMakeHeader(extErr_GetMInfo);

	if( modinfo.attribute & PSP_MODULE_VSH )
	{
		ErrMakeHeader(extErr_VshPrx);
	}
	else if( pbp )
	{
		if( (modinfo.attribute & PSP_MODULE_KERNEL) )
		{
			ErrMakeHeader(extErr_PbpK);
		}
		else if( modinfo.attribute != 0x200 && !(opt & pspPackOpt_FIX_PBP_ATTR) )
		{
			ErrMakeHeader(extErr_PbpAttr);
		}
	}


	//modinfõRs[
	header_pack->h_psp.attribute		= modinfo.attribute;
	header_pack->h_psp.module_ver_lo	= modinfo.module_ver_lo;
	header_pack->h_psp.module_ver_hi	= modinfo.module_ver_hi;
	strncpy(header_pack->h_psp.modname, modinfo.modname, 28);


	if( (v_size = elf_header.e_shnum * sizeof(Elf32_Shdr)) > 0 )
	{
		if( (sections = memoryAlloc(v_size)) == NULL ) ErrMakeHeader(extErr_GetSc);

		if( ReadFile(file,sections,seek+ elf_header.e_shoff, v_size) != v_size ) ErrMakeHeader(extErr_GetSc);
	}
	else
	{
		ErrMakeHeader(extErr_GetSc);
	}

	
	if( (v_size = sections[elf_header.e_shstrndx].sh_size) > 0 )
	{
		if( (strtab_list = memoryAlloc(v_size)) == NULL ) ErrMakeHeader(extErr_GetSList);

		if( ReadFile(file,strtab_list,seek+ sections[elf_header.e_shstrndx].sh_offset , v_size) != v_size) ErrMakeHeader(extErr_GetSList);

		header_pack->h_psp.bss_size = segments[0].p_memsz - segments[0].p_filesz;
		
		for(i = 0; i < elf_header.e_shnum; i++)
		{
			//printf("%s\n",(char*)strtab_list+sections[i].sh_name);

			if( strcmp((char*)strtab_list+sections[i].sh_name, ".bss") == 0 )
			{
				header_pack->h_psp.bss_size = sections[i].sh_size;			
				break;
			}
		}

		if( i == elf_header.e_shnum ) ErrMakeHeader(extErr_BssNotF);
	}
	else
	{
		ErrMakeHeader(extErr_GetSList);
	}

	if( header_pack->h_psp.attribute & PSP_MODULE_KERNEL )
	{
		header_pack->h_psp.devkitversion	= 0x03070010;
		header_pack->h_psp.oe_tag			= tags[MODULE_KERNEL].oe_tag;
		header_pack->h_psp.tag				= tags[MODULE_KERNEL].psp_tag;
		header_pack->h_psp.decrypt_mode		= 2;
	}
	else
	{
		if( pbp )
		{
			header_pack->h_psp.attribute		= modinfo.attribute = 0x200;
			header_pack->h_psp.oe_tag			= tags[MODULE_PBP].oe_tag;
			header_pack->h_psp.tag				= tags[MODULE_PBP].psp_tag;
			header_pack->h_psp.decrypt_mode		= 0x0D;
		}
		else
		{
			header_pack->h_psp.devkitversion	= 0x03050010;
			header_pack->h_psp.oe_tag			= tags[MODULE_USER].oe_tag;
			header_pack->h_psp.tag				= tags[MODULE_USER].psp_tag;
			header_pack->h_psp.decrypt_mode		= 4;
		}
	}
	
	// Fill key data with random bytes
	GenRandom( header_pack->h_psp.key_data0, sizeof(header_pack->h_psp.key_data0));
	GenRandom( header_pack->h_psp.key_data1, sizeof(header_pack->h_psp.key_data1));
	GenRandom(&header_pack->h_psp.key_data2, sizeof(header_pack->h_psp.key_data2));
	GenRandom( header_pack->h_psp.key_data3, sizeof(header_pack->h_psp.key_data3));

Err_MakeHeader:

	if( segments )		memoryFree(segments);
	if( sections )		memoryFree(sections);
	if( strtab_list )	memoryFree(strtab_list);

	return ret;
}



int pspPack( const char *file , const char *out,int opt )
{
	pbp_header header;
	u32 signature  ;
	SceUID f_new = -1;
	int size = 0, ret, is_pbp = 0,seek = 0;
	int psar_size = 0 ,psp_size = 0 ,psar_old = 0;


	pack_header header_pack;

	u8 *h_p		= (sce_header ? (u8*)&header_pack : (u8*)&header_pack.h_psp);
	u32 h_size	= (sce_header ? SIZE_HEADER_FULL : SIZE_HEADER_PSP);

	int comp_size = 0 ,new_size = SIZE_HEADER_PSP;
	int ofs_comp_size	= ( sce_header ? (0xB0 + SIZE_HEADER_SCE) : 0xB0 );
	int ofs_psp_size	= ( sce_header ? (0x2C + SIZE_HEADER_SCE) : 0x2C );



	//t@CTCY擾
	if( (size = GetSize(file)) == 0 ) ErrPspPack(extErr_GetFSize);

	//PBP/ELFt@C̃^Cv擾
	if( ReadFile( file,&signature, 0, sizeof(signature)) != sizeof(signature) ) ErrPspPack(extErr_GetSig);

	//PBPt@CȂDATA.PSP̏ꏊT
	if ( signature == SIGNATURE_PBP )
	{
		//PBP wb_[ǂݍ
		if( ReadFile(file, &header, 0, sizeof(header)) != sizeof(header) ) ErrPspPack(extErr_GetPbpH);

		psar_old	= header.pos_psar;
		psar_size	= size - header.pos_psar;
		psp_size	= header.pos_psar - header.pos_psp;

		//seek,size DATA.PSPɍ킹
		seek		= header.pos_psp;
		size		= psp_size;

		is_pbp		= 1;
	}


	//ELFt@Cł͂Ȃ
	if( (ret = isPack(file,seek)) != extErr_NotPack ) ErrPspPack(ret);
	

	//~PSPwb_[̍쐬
	memset(&header_pack, 0 , sizeof(pack_header));

	if( sce_header )	memcpy(&header_pack.h_sce, &h_sce, SIZE_HEADER_SCE);

	if( (ret = MakeHeader(file ,&header_pack ,size ,seek ,is_pbp ,opt)) < 0 ) ErrPspPack(ret);


	//sceIoRemove(out);


	//Zbg
	ret = 0;

	if( (f_new = sceIoOpen(out, PSP_O_WRONLY | PSP_O_CREAT | PSP_O_TRUNC, 0777)) < 0 ) ErrPspPack(extErr_Write);

	if( is_pbp )
	{
		//PBPwb_[
		WriteFileUID(f_new, &header, sizeof(header));

		//DATA.PSPÕt@CS
		WriteFileAppendUID(f_new, file, sizeof(header), header.pos_psp - sizeof(header));
		
		//DATA.PSP(wb_[ + gzFile)
		WriteBufAppendUID(f_new, h_p, h_size);
		comp_size = gzComppresUID( f_new, file, seek,psp_size);

		if( comp_size == 0 ) ErrPspPack(extErr_Pack);

		header.pos_psar = sceIoLseek32(f_new,0,SEEK_CUR);

		//DATA.PSAR
		WriteFileAppendUID(f_new, file, psar_old, psar_size);

		//DATA.PSP wb_[̊eItZbg
		ofs_comp_size	+= header.pos_psp;
		ofs_psp_size	+= header.pos_psp;

		//PBP wb_[(header.pos_psar)
		//DATA.PSAR̈ʒuς
		sceIoLseek32(f_new, 0x24, SEEK_SET);
		sceIoWrite(f_new,&header.pos_psar,4);
	}
	else
	{
		//DATA.PSP(wb_[ + gzFile)
		WriteFileUID(f_new, h_p, h_size);
		comp_size = gzComppresUID( f_new, file, seek , size);

		if( comp_size == 0 ) ErrPspPack(extErr_Pack);
	}

	//DATA.PSP ŏIIȃTCY
	new_size += comp_size;

	//DATA.PSP wb_[(comp_size,psp_size)
	sceIoLseek32(f_new, ofs_comp_size, SEEK_SET);
	sceIoWrite(f_new,&comp_size,4);
	sceIoLseek32(f_new, ofs_psp_size, SEEK_SET);
	sceIoWrite(f_new,&new_size,4);
	
Err_pspPack:

	if( f_new >= 0 ) sceIoClose(f_new);

	if( ret < 0	)
	{
		sceIoRemove(out);
	}
	//else
	//{
	//	sceIoRemove(file);
	//	sceIoRename(FILE_TMP_NAME,file);
	//}

	return ret;
}



int pspUnpack( const char *file, const char *out )
{
	pbp_header header;
	u32 signature;
	SceUID f_new = -1;
	int size = 0, ret, is_pbp = 0,seek = 0;
	int psar_size = 0 ,psp_size = 0 ,psar_old = 0;



	if( (size = GetSize(file)) == 0 ) ErrPspUnpack(extErr_GetFSize);

	//t@C̃^Cv擾
	if( (signature = GetFileSig(file ,0)) == SIGNATURE_ERR ) ErrPspUnpack(extErr_GetSig);

	if( signature == SIGNATURE_PBP )
	{
		//PBP wb_[ǂݍ
		if( ReadFile(file, &header, 0, sizeof(header)) != sizeof(header) ) ErrPspUnpack(extErr_GetPbpH);

		if( (signature = GetFileSig(file ,header.pos_psp)) == SIGNATURE_ERR ) ErrPspUnpack(extErr_GetSig);

		psar_old	= header.pos_psar;
		psar_size	= size - header.pos_psar;
		psp_size	= header.pos_psar - header.pos_psp;
		seek		= header.pos_psp;
		is_pbp		= 1;
	}
	else
	{
		psp_size = size;
	}


	if( (ret = isPack(file,seek)) != extErr_Packed ) ErrPspUnpack(ret);


	if( signature == SIGNATURE_SCE )
	{
		seek		+= SIZE_HEADER_SCE;
		psp_size	-= SIZE_HEADER_SCE;
	}

	seek		+= SIZE_HEADER_PSP;
	psp_size	-= SIZE_HEADER_PSP;


	//sceIoRemove(out);
	

	//Zbg
	ret = 0;

	if( (f_new = sceIoOpen(out, PSP_O_WRONLY | PSP_O_CREAT | PSP_O_TRUNC, 0777)) < 0 ) ErrPspUnpack(extErr_Write);

	if( is_pbp )
	{
		int decomp_size;

		//𓀌DATA.PSPTCY擾
		//PBPwb_[ DATA.PSAR̈ʒuC
		ReadFile(file,&decomp_size,psar_old - 4,sizeof(decomp_size));
		header.pos_psar = header.pos_psp + decomp_size;

		//PBP wb_[ 
		WriteFileUID(f_new,&header,sizeof(header));
		//DATA.PSPÕt@CS
		WriteFileAppendUID(f_new, file, sizeof(header), header.pos_psp - sizeof(header));
	}

	//DATA.PBP
	if( gzDeComppresUID(f_new,file,seek,psp_size) == 0 ) ErrPspUnpack(extErr_Unpack);

	if( is_pbp )
	{
		//DATA.PSAR
		WriteFileAppendUID(f_new, file, psar_old, psar_size);
	}

Err_pspUnpack:

	if( f_new >= 0 ) sceIoClose(f_new);

	if( ret < 0 )
	{
		sceIoRemove(out);
	}
	//else
	//{
	//	sceIoRemove(file);
	//	sceIoRename(FILE_TMP_NAME,file);
	//}

	return ret;
}

int isPack( const char* file ,int seek )
{
	u32 signature,tag;
	int i;

	if( (signature = GetFileSig(file,seek)) == SIGNATURE_ERR ) return extErr_GetSig;
	
	if( signature == SIGNATURE_SCE )
	{
		seek += SIZE_HEADER_SCE;
		if( (signature = GetFileSig(file,seek)) == SIGNATURE_ERR ) return extErr_GetSig;
	}

	if( signature == SIGNATURE_PSP )
	{
		if( ReadFile( file,&tag, seek+OFS_FILE_TAG, sizeof(tag)) != sizeof(tag) ) return extErr_GetTag;

		for( i = 0 ; i < sizeof(tags) ; i++ )
		{
			if( tag == tags[i].psp_tag ) break;
		}

		return ( i == sizeof(tags) ? extErr_NotSup : extErr_Packed ) ;
	}
	else if( signature == SIGNATURE_ELF )
	{
		return extErr_NotPack;
	}

	return extErr_NotSup;
}


//
//int isPackTag( u32 tag )
//{
//}