﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;


namespace Psychlops{


	public partial class Image : Internal.PrimitiveFigure
	{
		public WriteableBitmap buffer;
		public Point datum { get; set; }
		public Point getDatum() { return datum; }
		public Point setDatum(Point p) { datum = p; return datum; }
		public Rectangle self_rect;
		protected bool AsyncBool;

		public Image() 
		{
			self_rect = new Rectangle(1, 1);
			initialize__(1, 1);
		}

		public Image(string uri)
		{
			self_rect = new Rectangle();
			load__(uri);
		}

		public Image(int wid, int hei)
		{
			self_rect = new Rectangle(wid, hei);
			initialize__(wid, hei);
		}
		public Image(double wid, double hei)
		{
			self_rect = new Rectangle(Math.round(wid), Math.round(hei));
			initialize__((int)Math.round(wid), (int)Math.round(hei));
		}

		public Image set(int wid, int hei)
		{
			self_rect = new Rectangle(wid, hei);
			initialize__(wid, hei);
			return this;
		}
		public Image set(double wid, double hei)
		{
			self_rect = new Rectangle(Math.round(wid), Math.round(hei));
			initialize__((int)Math.round(wid), (int)Math.round(hei));
			return this;
		}

		public Figure shift(Point p)
		{
			datum = datum + p;
			return this;
		}
		public Figure centering(Point p)
		{
			datum = new Point( p.x - width / 2.0, p.y - height / 2.0);
			return this;
		}
		public Image move_to(Point p) { datum = p; return this; }
		public Image move_to(double x, double y, double z) { datum = new Point(x, y, z); return this; }
		public Image locate(Point p) { datum = p; return this; }
		public Image locate(double x, double y, double z) { datum = new Point(x, y, z); return this; }

		public void pix(int x, int y, Color col)
		{
			buffer.SetPixel(x, y, col);
		}

		public void release()
		{
		}

		public void cache(bool on_off = true)
		{
		}

		public void alpha(int x, int y, double a)
		{
			buffer.SetPixel(x, y, (byte)(a*255), buffer.GetPixel(x, y));
		}

		public void clear(Color col)
		{
			for (int y = 0; y < height; y++)
			{
				for (int x = 0; x < width; x++)
				{
					pix(x, y, col);
				}
			}
		}


		public void field(System.Func<int, int, System.Windows.Media.Color> func)
		{
			field__(func);
		}
		public void field(System.Func<int, int, System.Windows.Media.Color, System.Windows.Media.Color> func)
		{
			field__(func);
		}
		public void each(System.Func<int, int, System.Windows.Media.Color> func)
		{
			field__(func);
		}
		public void each(System.Func<int, int, System.Windows.Media.Color, System.Windows.Media.Color> func)
		{
			field__(func);
		}

		public void load(string uri)
		{
			load__(uri);
		}

		public void draw()
		{
			Main.drawable.image(this);
		}


		public double width { get { return self_rect.width; } }
		public double height { get { return self_rect.height; } }
		public Point center { get { return new Point(width/2.0, height/2.0); } }
		public double getWidth() { return width; }
		public double getHeight() { return height; }
		public Point getCenter() { return center; }
		public double getHcenter() { return width / 2.0; }
		public double getVcenter() { return height / 2.0; }

		public double left { get { return datum.x; } }
		public double right { get { return datum.x + width; } }
		public double top { get { return datum.y; } }
		public double bottom { get { return datum.y + height; } }
		public double getLeft() { return left; }
		public double getRight() { return right; }
		public double getTop() { return top; }
		public double getBottom() { return bottom; }

	}


}