#pragma once

#include <string>

#include "../GeomObject.h"
#include "../GeomFileFormat.h"
#include "../NodeMap.h"

#include <assimp/vector3.h>
#include <assimp/matrix4x4.h>



class SceneMain;
class IOConfig;
struct aiScene;
struct aiNode;
struct aiMesh;
struct aiBone;
struct aiNodeAnim;
struct aiAnimation;


namespace geom
{

class GeomObject;

}


class AssimpReader
{
public:
	AssimpReader(geom::GeomFileFormat fmt_);

	geom::GeomObject* LoadGeom(SceneMain& scene, const std::string& filename);
	bool LoadCamera(SceneMain& scene, const std::string& filename);

private:
	void SetNodeTree(const aiScene* ai_scene, geom::GeomObject* geom);
	void SetNodeTreeSub(const aiScene* ai_scene, const aiNode* an, geom::GeomObject* geom, geom::SceneNode* gn);

	void ResetBone(geom::MeshBuf* mbuf, aiMesh* mesh);
	void ConvertBoneWeight(const aiBone* s_bone, geom::Bone& d_bone);

	void SetBoneNodeRef(geom::NodeMap& nodemap, geom::GeomObject* geom);
	void LoadAnimation(geom::NodeMap& nodemap, const aiScene* ai_scene, geom::GeomObject* geom, IOConfig& conf);

	void ReadKeys(aiNodeAnim* ch, geom::SeqTrans& st, const aiAnimation* anim, IOConfig& conf);

	void PlotASNode(aiNode* n);

	void ReadMeshShape(aiMesh* mesh_src, lib_geo::BaseMesh& mesh_dst);

	std::string GetIndexedName(const std::string& base, int idx);

private:
	geom::GeomFileFormat fmt;
};
