#pragma once

#include "PixelFormat.h"

#include "GlInclude.h"


namespace lib_gl
{


//! windows GUI pOpenGL_OReLXgǗNX
class CHglrc
{
public:
	CHglrc(void)
		: m_hdc(NULL)
		, m_hglrc(NULL)
	{}

	~CHglrc(void)
	{
		Release();
	}

	//! Bpfdw肵Ȃꍇ͂悭p悤ȕWݒŏ.
	bool Init(HDC i_hdc);
	bool Init(HDC i_hdc, const PIXELFORMATDESCRIPTOR& i_pfd);

	//! t@CiCY.
	bool Release(void);

	//! ς݂mF.
	bool IsInitialized(void) const;

	//! Init_GLpfdłŎgppfdԂ.
	const PIXELFORMATDESCRIPTOR& GetStandardPFD(void) const;

	//! ݂̃_OReLXgANeBuɂ.
	void BeginDraw(void) const;
	//! _OReLXgANeBuɂ.
	void EndDraw(void) const;

	//! _uobt@ÕvC}obt@XV.
	void SwapBuffers(void) const;
	void Refresh(void) const;

	HDC   GetHDC(void)   const { return m_hdc;   }
	HGLRC GetHGLRC(void) const { return m_hglrc; }

	bool HasHDC(void)   const { return m_hdc   != NULL ; }
	bool HasHGLRC(void) const { return m_hglrc != NULL ; }

private:
	CHglrc(const CHglrc&) {}
	void operator=(const CHglrc&) {}

protected:
	HDC   m_hdc;
	HGLRC m_hglrc;
};



inline
bool CHglrc::Init(HDC i_hdc)
{
	return Init( i_hdc , GetStandardPFD() );
}

inline
bool CHglrc::Init(HDC i_hdc, const PIXELFORMATDESCRIPTOR& i_pfd)
{
	if( m_hdc != NULL || m_hglrc != NULL )
		return false;

	if( !CPixelFormat::SetPFD( i_hdc , i_pfd ) )
		return false;

	m_hglrc = wglCreateContext( i_hdc );

	if( m_hglrc == NULL )
		return false;

	m_hdc = i_hdc;
	
	return true;
}

inline
bool CHglrc::Release(void)
{
	if( m_hglrc == NULL )
		return false;

	wglMakeCurrent( NULL , NULL );
	if( wglDeleteContext( m_hglrc ) == FALSE )
		return false;

	m_hdc   = NULL ;
	m_hglrc = NULL ;
	return true;
}

inline
bool CHglrc::IsInitialized(void) const
{
	return ( m_hdc != NULL );
}


inline
const PIXELFORMATDESCRIPTOR& CHglrc::GetStandardPFD(void) const
{
	return CPixelFormat::GetStandardPFD();
}

inline
void CHglrc::BeginDraw(void) const
{
	wglMakeCurrent( m_hdc , m_hglrc );
}

inline
void CHglrc::EndDraw(void) const
{
	wglMakeCurrent( m_hdc , 0 );
}

inline
void CHglrc::SwapBuffers(void) const
{
	::SwapBuffers( m_hdc );
}

// TODO : dl
inline
void CHglrc::Refresh(void) const
{
	SwapBuffers();
}


}
