#pragma once

#include "Color.h"


namespace lib_graph
{


//! Phong̃}eA
class Material
{
public:
	Material(void) : m_Shininess( 0.0f ) {} 
	Material
		(
			float ambient_r  , float ambient_g  , float ambient_b  , float ambient_a  ,
			float diffuse_r  , float diffuse_g  , float diffuse_b  , float diffuse_a  ,
			float specular_r , float specular_g , float specular_b , float specular_a ,
			float emission_r , float emission_g , float emission_b , float emission_a ,
			float shininess
		)
		: m_Ambient ( ambient_r  , ambient_g  , ambient_b  , ambient_a  ) ,
		  m_Diffuse ( diffuse_r  , diffuse_g  , diffuse_b  , diffuse_a  ) ,
		  m_Specular( specular_r , specular_g , specular_b , specular_a ) ,
		  m_Emission( emission_r , emission_g , emission_b , emission_a ) ,
		  m_Shininess( shininess )
	{}
	
	Material
		(
			const float* i_ambient ,
			const float* i_diffuse ,
			const float* i_specular ,
			const float* i_emission ,
			float i_shininess 
		)
		: m_Ambient ( i_ambient[0]  , i_ambient[1]  , i_ambient[2]  , i_ambient[3]  ) ,
		  m_Diffuse ( i_diffuse[0]  , i_diffuse[1]  , i_diffuse[2]  , i_diffuse[3]  ) ,
		  m_Specular( i_specular[0] , i_specular[1] , i_specular[2] , i_specular[3] ) ,
		  m_Emission( i_emission[0] , i_emission[1] , i_emission[2] , i_emission[3] ) ,
		  m_Shininess( i_shininess )
	{}

	Material
		(
			float ambient_r  , float ambient_g  , float ambient_b  , float ambient_a  ,
			float diffuse_r  , float diffuse_g  , float diffuse_b  , float diffuse_a  ,
			float specular_r , float specular_g , float specular_b , float specular_a ,
			float shininess
		)
		: m_Ambient ( ambient_r  , ambient_g  , ambient_b  , ambient_a  ) ,
		  m_Diffuse ( diffuse_r  , diffuse_g  , diffuse_b  , diffuse_a  ) ,
		  m_Specular( specular_r , specular_g , specular_b , specular_a ) ,
		  m_Emission( 0.0f       , 0.0f       , 0.0f       , 1.0f       ) ,
		  m_Shininess( shininess )
	{}
	
	Material
		(
			const float* i_ambient ,
			const float* i_diffuse ,
			const float* i_specular ,
			float i_shininess
		)
		: m_Ambient ( i_ambient[0]  , i_ambient[1]  , i_ambient[2]  , i_ambient[3]  ) ,
		  m_Diffuse ( i_diffuse[0]  , i_diffuse[1]  , i_diffuse[2]  , i_diffuse[3]  ) ,
		  m_Specular( i_specular[0] , i_specular[1] , i_specular[2] , i_specular[3] ) ,
		  m_Emission( 0.0f          , 0.0f          , 0.0f          , 1.0f          ) ,
		  m_Shininess( i_shininess )
	{}

	Material(const Material& m) :
		m_Ambient   ( m.m_Ambient   ),
		m_Diffuse   ( m.m_Diffuse   ),
		m_Specular  ( m.m_Specular  ),
		m_Emission  ( m.m_Emission  ),
		m_Shininess ( m.m_Shininess )
	{}

	//! Svf̃ɓlݒ肷
	void SetAlphaAll( float i_alpha )
	{
		m_Ambient  .a() = i_alpha;
		m_Diffuse  .a() = i_alpha;
		m_Specular .a() = i_alpha;
		m_Emission .a() = i_alpha;
	}


public:
	color4f m_Ambient;
	color4f m_Diffuse;
	color4f m_Specular;
	color4f m_Emission;
	float   m_Shininess;
};


// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//! ʃ}eANX
class DoublesideMaterial
{
public:
	DoublesideMaterial(void) {}

	DoublesideMaterial( const Material& i_material )
		: m_FrontMaterial( i_material )
		, m_BackMaterial( i_material )
	{}

	DoublesideMaterial( const Material& i_front_mat , const Material& i_back_mat )
		: m_FrontMaterial( i_front_mat )
		, m_BackMaterial( i_back_mat )
	{}


public:
	lib_graph::Material m_FrontMaterial;
	lib_graph::Material m_BackMaterial;
};


}
