#pragma once

#include <vector>

#include <C2/lm/vector2.h>
#include <C2/lm/vector3.h>
#include <C2/lm/range3.h>


namespace lib_geo
{


//! 2Ď`󓯎m̊􉽊wZ.
//  @\AvZ.
//  p[^3DxNgɂȂĂ֐́Ax,yvfg
//  ěvZs. z͖.
//  ʒuԂꍇȂ, vector3`ŕԂꍇzvf͏0Ԃ.
class Geom2d
{
public:
	typedef lm::vec2f   vec2f;
	typedef lm::vec3f   vec3f;
	typedef lm::range3f range3f;

public:
	// ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

	// ΐ̌
	static bool Intersect_Segments( const vec3f& a0 , const vec3f& a1 , const vec3f& b0 , const vec3f& b1 );
	static bool Intersect_Segments( const vec3f& a0 , const vec3f& a1 , const vec3f& b0 , const vec3f& b1 , vec3f& intersect_point );
	static bool Intersect_Segments( const vec3f& a0 , const vec3f& a1 , const vec3f& b0 , const vec3f& b1 , float& m , float& n );

	// Β̌
	static bool Intersect_Segment_Line( const vec3f& e0 , const vec3f& e1 , const vec3f& line_pos , const vec3f& line_dir );
	static bool Intersect_Segment_Line( const vec3f& e0 , const vec3f& e1 , const vec3f& line_pos , const vec3f& line_dir , vec3f& intersect_point );
	static bool Intersect_Segment_Line( const vec3f& e0 , const vec3f& e1 , const vec3f& line_pos , const vec3f& line_dir , float& m , float& n );

	// Ή~̌
	static int Intersect_Circle_Segment( const vec3f& center , const float& radius , const vec3f& e0 , const vec3f& e1 );
	static int Intersect_Circle_Segment( const vec3f& center , const float& radius , const vec3f& e0 , const vec3f& e1 , float& m , float& n );

	// AABB̌
	static bool Intersect_AABB_Segment( const range3f& aabb , const vec3f& e0 , const vec3f& e1 );

	// _3p`ɓĂ邩ׂ
	static float Intersect_Triangle_Point( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 , const vec3f& p );

	// e0-e1pɍł߂_߂.
	static vec3f Closest_Segment_Point( const vec3f& e0 , const vec3f& e1 , const vec3f& p );
	static vec3f Closest_Segment_Point( const vec3f& e0 , const vec3f& e1 , const vec3f& p , float& o_weight );

	// _ō\ꂽȐlinepɍł߂_߂.
	static vec3f Closest_CurveLine_Point( const std::vector<vec3f>& line , const vec3f& p );
	static vec3f Closest_CurveLine_Point( const std::vector<vec3f>& line , const vec3f& p , int& o_segment_idx , float& o_norm_pos );

	// 2_xyʂ猩Ƃ̋
	static float DistanceXY( const vec3f& p0 , const vec3f& p1 );
	static float SqDistanceXY( const vec3f& p0 , const vec3f& p1 );

	//! 3p`̖ʐς߂
	static float AreaSize_Triangle( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 );

	//! 3dxNg2dɓe
	static vec2f Proj_To2d( const vec3f& v );

	//! dSW擾
	static void Get_BaryCentCoord( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 , const vec3f& p , float& u , float& v , float& w );
	static void Get_BaryCentCoord( const vec3f& t0 , const vec3f& t1 , const vec3f& t2 , const vec3f& p , vec3f& bary_coord );

	//! 2̃xNg̐p߂.
	static float Get_Angle( const vec3f& v0 , const vec3f& v1 );
	//! 2̃xNg̐p0`2PI͈̔͂ŋ߂.
	static float Get_RoundAngle( const vec3f& v0 , const vec3f& v1 );
};


}
